/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.Recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Container.CMIList;
import net.Zrips.CMILib.Container.CMINamespacedKey;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Recipes.CMIRecipeChoice;
import net.Zrips.CMILib.Recipes.CMIRecipeCraftData;
import net.Zrips.CMILib.Recipes.CMIRecipeIngredient;
import net.Zrips.CMILib.Recipes.CMIRecipeType;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CMIRecipe {
    private Recipe recipe = null;
    private String identificator = null;
    private String customKey = null;
    private CMIRecipeType type = null;
    private CMIRecipeCraftData data = null;

    public CMIRecipe(String identificator, CMIRecipeType type) {
        this.identificator = identificator;
        this.type = type;
    }

    public String getIdentificator() {
        return this.identificator;
    }

    public CMIRecipe setIdentificator(String identificator) {
        this.identificator = identificator;
        return this;
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    public CMIRecipe setRecipe(Recipe recipe) {
        this.recipe = recipe;
        return this;
    }

    public CMIRecipeType getType() {
        return this.type;
    }

    public CMIRecipe setType(CMIRecipeType type) {
        this.type = type;
        return this;
    }

    public ItemStack getResult() {
        return this.recipe.getResult();
    }

    public HashMap<Integer, ItemStack> getIngridients() {
        HashMap<Integer, ItemStack> map = new HashMap<Integer, ItemStack>();
        switch (this.type) {
            case Shaped: {
                ShapedRecipe src = (ShapedRecipe)this.recipe;
                String[] shape = src.getShape();
                ArrayList<String> chars = new ArrayList<String>();
                for (String one : shape) {
                    chars.addAll(Arrays.asList(one.split("(?<=\\G.)")));
                }
                for (int i = 0; i < 9 && chars.size() > i; ++i) {
                    String ch = (String)chars.get(i);
                    ItemStack item = (ItemStack)src.getIngredientMap().get(Character.valueOf(ch.charAt(0)));
                    if (item == null) continue;
                    map.put(i + 1, item);
                }
                return map;
            }
            case Shapeless: {
                ShapelessRecipe rc = (ShapelessRecipe)this.recipe;
                int i = 0;
                for (ItemStack one : rc.getIngredientList()) {
                    ++i;
                    if (one == null) continue;
                    map.put(i, one);
                }
                return map;
            }
            case Furnace: {
                FurnaceRecipe fc = (FurnaceRecipe)this.recipe;
                map.put(1, fc.getInput());
                return map;
            }
        }
        return null;
    }

    public static Recipe makeShapedRecipe(ItemStack result, HashMap<Integer, CMIRecipeIngredient> Recipe2) {
        return CMIRecipe.makeShapedRecipe(result, Recipe2, null);
    }

    public static Recipe makeShapedRecipe(ItemStack result, HashMap<Integer, CMIRecipeIngredient> Recipe2, String customKey) {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            ShapedRecipe NewShapedRecipe = new ShapedRecipe(new NamespacedKey((Plugin)CMILib.getInstance(), customKey == null ? CMIRecipe.getRecipeIdentificator(CMIRecipeType.Shaped, result, Recipe2) : customKey), result);
            LinkedHashMap<String, CMIRecipeIngredient> itemsused = new LinkedHashMap<String, CMIRecipeIngredient>();
            StringBuilder ss = new StringBuilder();
            int y = 0;
            for (int i = 0; i < 9; ++i) {
                CMIRecipeIngredient ritem = Recipe2.get(i);
                if (ritem == null) {
                    ss.append(" ");
                    continue;
                }
                int e = 1;
                ItemStack item = ritem.getItem().clone();
                String ident = item.toString();
                if (!itemsused.containsKey(ident)) {
                    itemsused.put(ident, ritem.setItem(item));
                    e = ++y;
                } else {
                    e = CMIRecipe.getIndex(itemsused, ident) + 1;
                }
                ss.append(String.valueOf(e));
            }
            NewShapedRecipe.shape(ss.toString().split("(?<=\\G...)"));
            char[] charId = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9'};
            int i = 0;
            for (Map.Entry<String, CMIRecipeIngredient> one : itemsused.entrySet()) {
                char ch = charId[i];
                ItemStack item = one.getValue().getItem();
                if (item == null) continue;
                ++i;
                NewShapedRecipe.setIngredient(ch, (RecipeChoice)one.getValue().generateChoice());
            }
            return NewShapedRecipe;
        }
        ShapedRecipe NewShapedRecipe = null;
        NewShapedRecipe = Version.isCurrentHigher(Version.v1_11_R1) ? new ShapedRecipe(new NamespacedKey((Plugin)CMILib.getInstance(), customKey == null ? CMIRecipe.getRecipeIdentificator(CMIRecipeType.Shaped, result, Recipe2) : customKey), result) : new ShapedRecipe(result);
        LinkedHashMap<String, CMIRecipeIngredient> itemsused = new LinkedHashMap<String, CMIRecipeIngredient>();
        String ss = "";
        int y = 0;
        for (int i = 0; i < 9; ++i) {
            CMIRecipeIngredient ritem = Recipe2.get(i);
            if (ritem == null) {
                ss = ss + " ";
                continue;
            }
            int e = 1;
            ItemStack item = new ItemStack(ritem.getItem().getType(), 1, (short)ritem.getItem().getData().getData());
            if (!itemsused.containsKey(item.getType() + ":" + ritem.getItem().getData().getData())) {
                itemsused.put(item.getType() + ":" + ritem.getItem().getData().getData(), ritem.setItem(item));
                e = ++y;
            } else {
                e = CMIRecipe.getIndex(itemsused, item.getType() + ":" + ritem.getItem().getData().getData()) + 1;
            }
            ss = ss + String.valueOf(e);
        }
        NewShapedRecipe.shape(ss.split("(?<=\\G...)"));
        char[] charId = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9'};
        int i = 0;
        for (Map.Entry one : itemsused.entrySet()) {
            char ch = charId[i];
            ItemStack item = ((CMIRecipeIngredient)one.getValue()).getItem();
            if (item == null) continue;
            ++i;
            NewShapedRecipe.setIngredient(ch, item.getData());
        }
        return NewShapedRecipe;
    }

    public static int getIndex(LinkedHashMap<String, CMIRecipeIngredient> itemsused, Object value) {
        int result = 0;
        for (Map.Entry<String, CMIRecipeIngredient> entry : itemsused.entrySet()) {
            if (entry.getKey().equals(value)) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    public static Recipe makeShaplessRecipe(ItemStack result, HashMap<Integer, CMIRecipeIngredient> recipe) {
        return CMIRecipe.makeShaplessRecipe(result, recipe, null, null);
    }

    public static Recipe makeShaplessRecipe(ItemStack result, HashMap<Integer, CMIRecipeIngredient> recipe, String customKey) {
        return CMIRecipe.makeShaplessRecipe(result, recipe, null, customKey);
    }

    public static Recipe makeShaplessRecipe(ItemStack result, HashMap<Integer, CMIRecipeIngredient> recipe, CMINamespacedKey key) {
        return CMIRecipe.makeShaplessRecipe(result, recipe, key, null);
    }

    public static Recipe makeShaplessRecipe(ItemStack result, HashMap<Integer, CMIRecipeIngredient> recipe, CMINamespacedKey key, String customKey) {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            ShapelessRecipe NewShapelessRecipe = new ShapelessRecipe(key == null ? new NamespacedKey((Plugin)CMILib.getInstance(), customKey == null ? CMIRecipe.getRecipeIdentificator(CMIRecipeType.Shapeless, result, recipe) : customKey) : new NamespacedKey(key.getNamespace(), key.getKey()), result);
            for (CMIRecipeIngredient item : recipe.values()) {
                if (item == null) continue;
                NewShapelessRecipe.addIngredient((RecipeChoice)item.generateChoice());
            }
            return NewShapelessRecipe;
        }
        ShapelessRecipe NewShapelessRecipe = null;
        NewShapelessRecipe = Version.isCurrentHigher(Version.v1_11_R1) ? new ShapelessRecipe(key == null ? new NamespacedKey((Plugin)CMILib.getInstance(), customKey == null ? CMIRecipe.getRecipeIdentificator(CMIRecipeType.Shapeless, result, recipe) : customKey) : new NamespacedKey(key.getNamespace(), key.getKey()), result) : new ShapelessRecipe(result);
        for (CMIRecipeIngredient item : recipe.values()) {
            if (item == null) continue;
            NewShapelessRecipe.addIngredient(1, item.getItem().getData());
        }
        return NewShapelessRecipe;
    }

    public static Recipe makeFurnaceRecipe(ItemStack result, CMIRecipeIngredient Recipe2) {
        return CMIRecipe.makeFurnaceRecipe(result, Recipe2, null, null);
    }

    public static Recipe makeFurnaceRecipe(ItemStack result, CMIRecipeIngredient Recipe2, CMIRecipeCraftData temp) {
        return CMIRecipe.makeFurnaceRecipe(result, Recipe2, temp, null);
    }

    public static Recipe makeFurnaceRecipe(ItemStack result, CMIRecipeIngredient Recipe2, CMIRecipeCraftData temp, String customKey) {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            float exp = 0.1f;
            int duration = 60;
            if (temp != null) {
                exp = temp.getExp();
                duration = temp.getCookingTime();
            }
            return new FurnaceRecipe(new NamespacedKey((Plugin)CMILib.getInstance(), customKey == null ? CMIRecipe.getRecipeIdentificator(CMIRecipeType.Furnace, result, Recipe2) : customKey), result, (RecipeChoice)Recipe2.generateChoice(), exp, duration);
        }
        FurnaceRecipe NewShapelessRecipe = new FurnaceRecipe(result, Recipe2.getItem().getData());
        return NewShapelessRecipe;
    }

    public static Recipe makeSmithingRecipe(ItemStack result, CMIRecipeIngredient ingredient1, CMIRecipeIngredient ingredient2) {
        return CMIRecipe.makeSmithingRecipe(result, ingredient1, ingredient2, null);
    }

    public static Recipe makeSmithingRecipe(ItemStack result, CMIRecipeIngredient ingredient1, CMIRecipeIngredient ingredient2, String customKey) {
        if (Version.isCurrentEqualOrLower(Version.v1_13_R1)) {
            return null;
        }
        return new SmithingRecipe(new NamespacedKey((Plugin)CMILib.getInstance(), customKey == null ? CMIRecipe.getRecipeIdentificator(CMIRecipeType.Smithing, result, ingredient1, ingredient2) : customKey), result, (RecipeChoice)ingredient1.generateChoice(), (RecipeChoice)ingredient2.generateChoice());
    }

    public static Recipe makeStonecuttingRecipe(ItemStack result, CMIRecipeIngredient ingredient1) {
        return CMIRecipe.makeStonecuttingRecipe(result, ingredient1, null);
    }

    public static Recipe makeStonecuttingRecipe(ItemStack result, CMIRecipeIngredient ingredient1, String customKey) {
        if (Version.isCurrentEqualOrLower(Version.v1_13_R1)) {
            return null;
        }
        return new StonecuttingRecipe(new NamespacedKey((Plugin)CMILib.getInstance(), customKey == null ? CMIRecipe.getRecipeIdentificator(CMIRecipeType.Stonecutting, result, ingredient1) : customKey), result, (RecipeChoice)ingredient1.generateChoice());
    }

    public static Recipe makeCampfireRecipe(ItemStack result, CMIRecipeIngredient ingredient1, CMIRecipeCraftData temp) {
        return CMIRecipe.makeCampfireRecipe(result, ingredient1, temp, null);
    }

    public static Recipe makeCampfireRecipe(ItemStack result, CMIRecipeIngredient ingredient1, CMIRecipeCraftData temp, String customKey) {
        if (Version.isCurrentEqualOrLower(Version.v1_13_R1)) {
            return null;
        }
        float exp = 0.1f;
        int duration = 60;
        if (temp != null) {
            exp = temp.getExp();
            duration = temp.getCookingTime();
        }
        return new CampfireRecipe(new NamespacedKey((Plugin)CMILib.getInstance(), customKey == null ? CMIRecipe.getRecipeIdentificator(CMIRecipeType.Campfire, result, ingredient1) : customKey), result, (RecipeChoice)ingredient1.generateChoice(), exp, duration);
    }

    public static Recipe makeSmokingRecipe(ItemStack result, CMIRecipeIngredient ingredient1, CMIRecipeCraftData temp) {
        return CMIRecipe.makeSmokingRecipe(result, ingredient1, temp, null);
    }

    public static Recipe makeSmokingRecipe(ItemStack result, CMIRecipeIngredient ingredient1, CMIRecipeCraftData temp, String customKey) {
        if (Version.isCurrentEqualOrLower(Version.v1_13_R1)) {
            return null;
        }
        float exp = 0.1f;
        int duration = 60;
        if (temp != null) {
            exp = temp.getExp();
            duration = temp.getCookingTime();
        }
        return new SmokingRecipe(new NamespacedKey((Plugin)CMILib.getInstance(), customKey == null ? CMIRecipe.getRecipeIdentificator(CMIRecipeType.Smoking, result, ingredient1) : customKey), result, (RecipeChoice)ingredient1.generateChoice(), exp, duration);
    }

    public static Recipe makeBlastingRecipe(ItemStack result, CMIRecipeIngredient ingredient1, CMIRecipeCraftData temp) {
        return CMIRecipe.makeBlastingRecipe(result, ingredient1, temp, null);
    }

    public static Recipe makeBlastingRecipe(ItemStack result, CMIRecipeIngredient ingredient1, CMIRecipeCraftData temp, String customKey) {
        if (Version.isCurrentEqualOrLower(Version.v1_13_R1)) {
            return null;
        }
        float exp = 0.1f;
        int duration = 60;
        if (temp != null) {
            exp = temp.getExp();
            duration = temp.getCookingTime();
        }
        return new BlastingRecipe(new NamespacedKey((Plugin)CMILib.getInstance(), customKey == null ? CMIRecipe.getRecipeIdentificator(CMIRecipeType.Blasting, result, ingredient1) : customKey), result, (RecipeChoice)ingredient1.generateChoice(), exp, duration);
    }

    public static Recipe createRecipe(CMIRecipeType type, ItemStack result, HashMap<Integer, CMIRecipeIngredient> Recipe2) {
        return CMIRecipe.createRecipe(type, result, Recipe2, null);
    }

    public static Recipe createRecipe(CMIRecipeType type, ItemStack result, HashMap<Integer, CMIRecipeIngredient> Recipe2, CMIRecipeCraftData temp) {
        return CMIRecipe.createRecipe(type, result, Recipe2, temp, null);
    }

    public static Recipe createRecipe(CMIRecipeType type, ItemStack result, HashMap<Integer, CMIRecipeIngredient> Recipe2, CMIRecipeCraftData temp, String customKey) {
        Recipe recipe = null;
        switch (type) {
            case Shaped: {
                recipe = CMIRecipe.makeShapedRecipe(result, Recipe2, customKey);
                break;
            }
            case Shapeless: {
                recipe = CMIRecipe.makeShaplessRecipe(result, Recipe2, customKey);
                break;
            }
            case Furnace: {
                recipe = CMIRecipe.makeFurnaceRecipe(result, Recipe2.get(0), temp, customKey);
                break;
            }
            case Smithing: {
                recipe = CMIRecipe.makeSmithingRecipe(result, Recipe2.get(0), Recipe2.get(1), customKey);
                break;
            }
            case Stonecutting: {
                recipe = CMIRecipe.makeStonecuttingRecipe(result, Recipe2.get(0), customKey);
                break;
            }
            case Campfire: {
                recipe = CMIRecipe.makeCampfireRecipe(result, Recipe2.get(0), temp, customKey);
                break;
            }
            case Smoking: {
                recipe = CMIRecipe.makeSmokingRecipe(result, Recipe2.get(0), temp, customKey);
                break;
            }
            case Blasting: {
                recipe = CMIRecipe.makeBlastingRecipe(result, Recipe2.get(0), temp, customKey);
            }
        }
        return recipe;
    }

    public static List<ItemStack> getIngredientsList(Recipe recipe) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (CMIRecipeIngredient one : CMIRecipe.getIngredientsMap(recipe).values()) {
            if (one.getItem() == null) continue;
            list.add(one.getItem());
        }
        return list;
    }

    public HashMap<Integer, CMIRecipeIngredient> getIngredients() {
        return CMIRecipe.getIngredientsMap(this.recipe);
    }

    public static HashMap<Integer, CMIRecipeIngredient> getIngredientsMap(Recipe recipe) {
        HashMap<Integer, CMIRecipeIngredient> map = new HashMap<Integer, CMIRecipeIngredient>();
        if (recipe == null) {
            return map;
        }
        if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe rc = (ShapelessRecipe)recipe;
            for (int i = 0; i < rc.getIngredientList().size(); ++i) {
                CMIRecipeIngredient CMIri = new CMIRecipeIngredient((ItemStack)rc.getIngredientList().get(i));
                if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                    CMIRecipe.setChoice((RecipeChoice)rc.getChoiceList().get(i), CMIri);
                }
                map.put(i, CMIri);
            }
        } else if (recipe instanceof ShapedRecipe) {
            ShapedRecipe rc = (ShapedRecipe)recipe;
            String[] shape = rc.getShape();
            int i = -1;
            for (int x = 0; x < 3 && shape.length > x; ++x) {
                String line = shape[x];
                for (int z = 0; z < 3; ++z) {
                    ++i;
                    if (line.length() <= z) continue;
                    char oneS = line.charAt(z);
                    ItemStack item = (ItemStack)rc.getIngredientMap().get(Character.valueOf(oneS));
                    if (item == null) continue;
                    CMIRecipeIngredient CMIri = new CMIRecipeIngredient(item);
                    if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                        CMIRecipe.setChoice((RecipeChoice)rc.getChoiceMap().get(Character.valueOf(oneS)), CMIri);
                    }
                    map.put(i, CMIri);
                }
            }
        } else if (recipe instanceof FurnaceRecipe) {
            FurnaceRecipe rc = (FurnaceRecipe)recipe;
            CMIRecipeIngredient CMIri = new CMIRecipeIngredient(rc.getInput());
            if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                CMIRecipe.setChoice(rc.getInputChoice(), CMIri);
            }
            map.put(0, CMIri);
        } else {
            CMIRecipeType recipeType = CMIRecipeType.getByName(recipe.getClass().getSimpleName());
            switch (recipeType) {
                case Blasting: {
                    BlastingRecipe brc = (BlastingRecipe)recipe;
                    CMIRecipeIngredient CMIri = new CMIRecipeIngredient(brc.getInput());
                    if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                        CMIRecipe.setChoice(brc.getInputChoice(), CMIri);
                    }
                    map.put(0, CMIri);
                    break;
                }
                case Campfire: {
                    CampfireRecipe cfr = (CampfireRecipe)recipe;
                    CMIRecipeIngredient CMIri = new CMIRecipeIngredient(cfr.getInput());
                    if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                        CMIRecipe.setChoice(cfr.getInputChoice(), CMIri);
                    }
                    map.put(0, CMIri);
                    break;
                }
                case Cooking: {
                    CookingRecipe cor = (CookingRecipe)recipe;
                    CMIRecipeIngredient CMIri = new CMIRecipeIngredient(cor.getInput());
                    if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                        CMIRecipe.setChoice(cor.getInputChoice(), CMIri);
                    }
                    map.put(0, CMIri);
                    break;
                }
                case Merchant: {
                    MerchantRecipe mer = (MerchantRecipe)recipe;
                    for (int i = 0; i < mer.getIngredients().size(); ++i) {
                        CMIRecipeIngredient CMIri = new CMIRecipeIngredient((ItemStack)mer.getIngredients().get(i));
                        map.put(i, CMIri);
                    }
                    break;
                }
                case Smoking: {
                    SmokingRecipe smr = (SmokingRecipe)recipe;
                    CMIRecipeIngredient CMIri = new CMIRecipeIngredient(smr.getInput());
                    if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                        CMIRecipe.setChoice(smr.getInputChoice(), CMIri);
                    }
                    map.put(0, CMIri);
                    break;
                }
                case Stonecutting: {
                    StonecuttingRecipe str = (StonecuttingRecipe)recipe;
                    CMIRecipeIngredient CMIri = new CMIRecipeIngredient(str.getInput());
                    if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                        CMIRecipe.setChoice(str.getInputChoice(), CMIri);
                    }
                    map.put(0, CMIri);
                    break;
                }
                case Smithing: {
                    SmithingRecipe smtr = (SmithingRecipe)recipe;
                    CMIRecipeIngredient CMIri = new CMIRecipeIngredient(smtr.getBase().getItemStack());
                    if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                        CMIRecipe.setChoice(smtr.getBase(), CMIri);
                    }
                    map.put(0, CMIri);
                    CMIri = new CMIRecipeIngredient(smtr.getAddition().getItemStack());
                    if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                        CMIRecipe.setChoice(smtr.getAddition(), CMIri);
                    }
                    map.put(1, CMIri);
                }
            }
        }
        return map;
    }

    private static void setChoice(RecipeChoice choice, CMIRecipeIngredient CMIri) {
        try {
            if (choice instanceof RecipeChoice.ExactChoice) {
                CMIri.setChoice(CMIRecipeChoice.byItemStack);
            } else {
                CMIri.setChoice(CMIRecipeChoice.byMaterial);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static String getRecipeIdentificator(CMIRecipeType type, Recipe recipe) {
        return CMIRecipe.getRecipeIdentificator(type, recipe.getResult(), CMIRecipe.getIngredientsMap(recipe));
    }

    private static String getRecipeIdentificator(CMIRecipeType type, ItemStack result, CMIRecipeIngredient ingredient1, CMIRecipeIngredient ingredient2) {
        HashMap<Integer, CMIRecipeIngredient> temp = new HashMap<Integer, CMIRecipeIngredient>();
        temp.put(1, ingredient1);
        temp.put(2, ingredient2);
        return CMIRecipe.getRecipeIdentificator(type, result, temp);
    }

    private static String getRecipeIdentificator(CMIRecipeType type, ItemStack result, CMIRecipeIngredient ingredient1) {
        HashMap<Integer, CMIRecipeIngredient> temp = new HashMap<Integer, CMIRecipeIngredient>();
        temp.put(1, ingredient1);
        return CMIRecipe.getRecipeIdentificator(type, result, temp);
    }

    private static String getRecipeIdentificator(CMIRecipeType type, ItemStack result, HashMap<Integer, CMIRecipeIngredient> Recipe2) {
        StringBuilder str = new StringBuilder();
        str.append(type.toString());
        str.append(result.getType() + ":" + result.getAmount());
        for (Map.Entry<Integer, CMIRecipeIngredient> one : Recipe2.entrySet()) {
            if (one.getValue().getItem() == null) continue;
            if (one.getValue().getChoice().equals((Object)CMIRecipeChoice.byItemStack)) {
                CMINBT nbt;
                Integer value;
                if (one.getValue().getItem().hasItemMeta()) {
                    ItemMeta meta = one.getValue().getItem().getItemMeta();
                    if (meta.hasDisplayName()) {
                        str.append(":" + meta.getDisplayName());
                    }
                    if (meta.hasLore()) {
                        str.append(CMIList.listToString(meta.getLore()));
                    }
                }
                if ((value = (nbt = new CMINBT(one.getValue().getItem())).getInt("CustomModelData")) != null) {
                    str.append(":" + value);
                }
            }
            str.append(one.getValue().getItem().getType() + ":" + one.getValue().getItem().getAmount() + ":" + (one.getValue().getChoice().equals((Object)CMIRecipeChoice.byItemStack) ? "1:" : "") + one.getKey());
        }
        return UUID.nameUUIDFromBytes(str.toString().getBytes()).toString();
    }

    public static Recipe getRecipe(CMINamespacedKey key) {
        if (Version.isCurrentEqualOrHigher(Version.v1_17_R1)) {
            return Bukkit.getServer().getRecipe(new NamespacedKey(key.getNamespace(), key.getKey()));
        }
        Iterator iter = Bukkit.getServer().recipeIterator();
        while (iter.hasNext()) {
            Recipe recipe = (Recipe)iter.next();
            CMINamespacedKey subKey = CMINamespacedKey.getKey(recipe);
            if (subKey == null || !subKey.toString().equals(key.toString())) continue;
            return recipe;
        }
        return null;
    }

    public CMIRecipeCraftData getData() {
        return this.data;
    }

    public CMIRecipe setData(CMIRecipeCraftData data) {
        this.data = data;
        return this;
    }

    public String getCustomKey() {
        return this.customKey;
    }

    public CMIRecipe setCustomKey(String customKey) {
        this.customKey = customKey;
        return this;
    }
}

