/*
 * Decompiled with CFR 0.152.
 */
package net.Zrips.CMILib.TitleMessages;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import net.Zrips.CMILib.ActionBar.CMIActionBar;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMICommandSender;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.PlayerConnection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class CMITitleMessage {
    private static Method getHandle;
    private static Method sendPacket;
    private static Field playerConnection;
    private static Class<?> nmsIChatBaseComponent;
    private static Constructor<?> nmsPacketPlayOutTitle;
    private static Constructor<?> nmsPacketPlayOutTimes;
    private static Class<?> enumTitleAction;
    private static Method fromString;
    private static boolean simpleTitleMessages;
    private static Object timerResetPacket;

    public static void send(CMICommandSender receivingPacket, Object title, Object subtitle) {
        if (!receivingPacket.isPlayer()) {
            receivingPacket.sendMessage(String.valueOf(title) + String.valueOf(subtitle));
            return;
        }
        CMITitleMessage.send(receivingPacket.getPlayer(), title, subtitle, 0, 40, 10);
    }

    public static void send(Player receivingPacket, Object title, Object subtitle) {
        CMITitleMessage.send(receivingPacket, title, subtitle, 0, 40, 10);
    }

    public static void send(final Player receivingPacket, final Object title, final Object subtitle, final int fadeIn, final int keep, final int fadeOut) {
        if (receivingPacket == null) {
            return;
        }
        CMIScheduler.get().runTaskAsynchronously(new Runnable(){

            @Override
            public void run() {
                String s;
                String t = title == null ? null : CMIChatColor.translate((String)title);
                String string = s = subtitle == null ? null : CMIChatColor.translate((String)subtitle);
                if (Version.isCurrentEqualOrLower(Version.v1_7_R4)) {
                    CMIActionBar.send(receivingPacket, (t == null ? "" : t) + (s == null ? "" : s));
                    return;
                }
                if (simpleTitleMessages) {
                    receivingPacket.sendMessage(t);
                    receivingPacket.sendMessage(s);
                    return;
                }
                try {
                    switch (Version.getCurrent()) {
                        default: {
                            receivingPacket.sendTitle(t, s, fadeIn, keep, fadeOut);
                            break;
                        }
                        case v1_9_R1: 
                        case v1_9_R2: 
                        case v1_10_R1: 
                        case v1_11_R1: 
                        case v1_8_R1: 
                        case v1_8_R2: 
                        case v1_8_R3: {
                            Object packetTitle;
                            Object packetTimes = nmsPacketPlayOutTimes.newInstance(fadeIn, keep, fadeOut);
                            CMITitleMessage.sendPacket(receivingPacket, packetTimes);
                            if (title != null) {
                                packetTitle = nmsPacketPlayOutTitle.newInstance(enumTitleAction.getField("TITLE").get(null), ((Object[])fromString.invoke(null, t))[0]);
                                CMITitleMessage.sendPacket(receivingPacket, packetTitle);
                            }
                            if (subtitle != null) {
                                if (title == null) {
                                    packetTitle = nmsPacketPlayOutTitle.newInstance(enumTitleAction.getField("TITLE").get(null), ((Object[])fromString.invoke(null, ""))[0]);
                                    CMITitleMessage.sendPacket(receivingPacket, packetTitle);
                                }
                                Object packetSubtitle = nmsPacketPlayOutTitle.newInstance(enumTitleAction.getField("SUBTITLE").get(null), ((Object[])fromString.invoke(null, s))[0]);
                                CMITitleMessage.sendPacket(receivingPacket, packetSubtitle);
                            }
                            break;
                        }
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException | InvocationTargetException ex) {
                    simpleTitleMessages = true;
                    Bukkit.getLogger().log(Level.SEVERE, "Your server can't fully support title messages. They will be shown in chat instead.");
                }
            }
        });
    }

    private static void sendPacket(Player player, Object packet) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object handle = getHandle.invoke((Object)player, new Object[0]);
        Object connection = playerConnection.get(handle);
        sendPacket.invoke(connection, packet);
    }

    private static String getPacketPlayOutTitleClasspath() {
        return "net.minecraft.server." + (Object)((Object)Version.getCurrent()) + ".PacketPlayOutTitle";
    }

    private static String getEnumTitleActionClasspath() {
        return CMITitleMessage.getPacketPlayOutTitleClasspath() + "$EnumTitleAction";
    }

    static {
        simpleTitleMessages = false;
        timerResetPacket = null;
        if (Version.isCurrentHigher(Version.v1_7_R4)) {
            Version version = Version.getCurrent();
            if (Version.isCurrentEqualOrHigher(Version.v1_20_R2)) {
                try {
                    getHandle = Class.forName("org.bukkit.craftbukkit." + (Object)((Object)version) + ".entity.CraftPlayer").getMethod("getHandle", new Class[0]);
                    nmsIChatBaseComponent = IChatBaseComponent.class;
                    playerConnection = EntityPlayer.class.getField("c");
                    sendPacket = PlayerConnection.class.getMethod("a", Packet.class);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            } else if (Version.isCurrentEqualOrHigher(Version.v1_20_R1)) {
                try {
                    getHandle = Class.forName("org.bukkit.craftbukkit." + (Object)((Object)version) + ".entity.CraftPlayer").getMethod("getHandle", new Class[0]);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                nmsIChatBaseComponent = IChatBaseComponent.class;
                try {
                    playerConnection = EntityPlayer.class.getField("c");
                    sendPacket = PlayerConnection.class.getMethod("a", Packet.class);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            } else if (Version.isCurrentEqualOrHigher(Version.v1_17_R1)) {
                try {
                    getHandle = Class.forName("org.bukkit.craftbukkit." + (Object)((Object)version) + ".entity.CraftPlayer").getMethod("getHandle", new Class[0]);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                nmsIChatBaseComponent = IChatBaseComponent.class;
                try {
                    playerConnection = EntityPlayer.class.getField("b");
                    sendPacket = PlayerConnection.class.getMethod(Version.isCurrentEqualOrHigher(Version.v1_18_R1) ? "a" : "sendPacket", Packet.class);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    Class<?> typeCraftPlayer = Class.forName("org.bukkit.craftbukkit." + (Object)((Object)version) + ".entity.CraftPlayer");
                    Class<?> typeNMSPlayer = Class.forName("net.minecraft.server." + (Object)((Object)version) + ".EntityPlayer");
                    Class<?> typePlayerConnection = Class.forName("net.minecraft.server." + (Object)((Object)version) + ".PlayerConnection");
                    nmsIChatBaseComponent = Class.forName("net.minecraft.server." + (Object)((Object)version) + ".IChatBaseComponent");
                    getHandle = typeCraftPlayer.getMethod("getHandle", new Class[0]);
                    playerConnection = typeNMSPlayer.getField("playerConnection");
                    sendPacket = typePlayerConnection.getMethod("sendPacket", Class.forName("net.minecraft.server." + (Object)((Object)version) + ".Packet"));
                }
                catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException | SecurityException ex) {
                    Bukkit.getLogger().log(Level.SEVERE, "Error {0}", ex);
                }
                try {
                    Class<?> typePacketPlayOutTitle = Class.forName(CMITitleMessage.getPacketPlayOutTitleClasspath());
                    enumTitleAction = Class.forName(CMITitleMessage.getEnumTitleActionClasspath());
                    nmsPacketPlayOutTitle = typePacketPlayOutTitle.getConstructor(enumTitleAction, nmsIChatBaseComponent);
                    nmsPacketPlayOutTimes = typePacketPlayOutTitle.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    fromString = Class.forName("org.bukkit.craftbukkit." + (Object)((Object)version) + ".util.CraftChatMessage").getMethod("fromString", String.class);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException ex) {
                    simpleTitleMessages = true;
                }
            }
        }
    }
}

