/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.worldeditselectionvisualizer;

import com.sk89q.worldedit.regions.Region;
import fr.mrmicky.worldeditselectionvisualizer.commands.CommandWesv;
import fr.mrmicky.worldeditselectionvisualizer.compat.CompatibilityHelper;
import fr.mrmicky.worldeditselectionvisualizer.config.ConfigurationManager;
import fr.mrmicky.worldeditselectionvisualizer.config.GlobalSelectionConfig;
import fr.mrmicky.worldeditselectionvisualizer.display.DisplayType;
import fr.mrmicky.worldeditselectionvisualizer.display.ParticlesTask;
import fr.mrmicky.worldeditselectionvisualizer.listeners.PlayerListener;
import fr.mrmicky.worldeditselectionvisualizer.metrics.WesvMetrics;
import fr.mrmicky.worldeditselectionvisualizer.placeholders.PlaceholderAPIExpansion;
import fr.mrmicky.worldeditselectionvisualizer.selection.PlayerVisualizerData;
import fr.mrmicky.worldeditselectionvisualizer.selection.SelectionManager;
import fr.mrmicky.worldeditselectionvisualizer.selection.SelectionType;
import fr.mrmicky.worldeditselectionvisualizer.selection.StorageManager;
import fr.mrmicky.worldeditselectionvisualizer.utils.ChatUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public final class WorldEditSelectionVisualizer
extends JavaPlugin {
    private final Map<SelectionType, GlobalSelectionConfig> configurations = new EnumMap<SelectionType, GlobalSelectionConfig>(SelectionType.class);
    private final Map<UUID, PlayerVisualizerData> players = new HashMap<UUID, PlayerVisualizerData>();
    private final List<BukkitTask> particlesTasks = new ArrayList<BukkitTask>(6);
    private SelectionManager selectionManager;
    private StorageManager storageManager;
    private ConfigurationManager configurationManager;
    private CompatibilityHelper compatibilityHelper;

    public void onEnable() {
        this.saveDefaultConfig();
        this.migrateV1Config();
        this.compatibilityHelper = new CompatibilityHelper(this);
        this.storageManager = new StorageManager(this);
        this.configurationManager = new ConfigurationManager(this);
        this.selectionManager = new SelectionManager(this);
        if (this.compatibilityHelper.getWorldEditVersion() == 7) {
            try {
                Region.class.getMethod("getVolume", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.getLogger().severe("**********************************");
                this.getLogger().severe("You are using an unsupported WorldEdit version (7.0.x or 7.1.x) !");
                this.getLogger().severe("WorldEditSelection visualizer don't works with outdated WorldEdit version.");
                this.getLogger().severe("You can download the latest WorldEdit version here: https://dev.bukkit.org/projects/worldedit/files");
                this.getLogger().severe("**********************************");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        }
        this.getCommand("worldeditselectionvisualizer").setExecutor((CommandExecutor)new CommandWesv(this));
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.loadConfig();
        this.getServer().getOnlinePlayers().forEach(this::loadPlayer);
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PlaceholderAPIExpansion(this).registerExpansion();
        }
        if (this.getConfig().getBoolean("check-updates")) {
            this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, this::checkUpdate);
        }
        WesvMetrics.register(this);
    }

    public void reloadConfig() {
        super.reloadConfig();
        if (this.configurationManager != null) {
            this.loadConfig();
        }
    }

    private void loadConfig() {
        this.particlesTasks.forEach(BukkitTask::cancel);
        this.particlesTasks.clear();
        for (SelectionType type : SelectionType.values()) {
            GlobalSelectionConfig config = this.configurationManager.loadGlobalSelectionConfig(type);
            this.configurations.put(type, config);
            for (DisplayType display : DisplayType.values()) {
                ParticlesTask task = new ParticlesTask(this, type, display, config.byType(display));
                this.particlesTasks.add(task.start());
            }
        }
    }

    public void updateHoldingSelectionItem(PlayerVisualizerData playerData) {
        playerData.setHoldingSelectionItem(this.compatibilityHelper.isHoldingSelectionItem(playerData.getPlayer()));
    }

    public void loadPlayer(Player player) {
        if (this.players.containsKey(player.getUniqueId())) {
            return;
        }
        PlayerVisualizerData playerData = new PlayerVisualizerData(player);
        for (SelectionType type : SelectionType.values()) {
            boolean enable = !this.getConfig().getBoolean("save-toggle") || this.storageManager.isEnabled(player, type);
            playerData.toggleSelectionVisibility(type, enable);
        }
        this.updateHoldingSelectionItem(playerData);
        this.players.put(player.getUniqueId(), playerData);
    }

    public void unloadPlayer(Player player) {
        this.players.remove(player.getUniqueId());
    }

    @NotNull
    public PlayerVisualizerData getPlayerData(Player player) {
        PlayerVisualizerData playerData = this.players.get(player.getUniqueId());
        if (playerData == null) {
            throw new IllegalStateException("No player data loaded for " + player.getName());
        }
        return playerData;
    }

    @NotNull
    public Optional<PlayerVisualizerData> getOptionalPlayerData(Player player) {
        return Optional.ofNullable(this.players.get(player.getUniqueId()));
    }

    @NotNull
    public Collection<PlayerVisualizerData> getPlayers() {
        return this.players.values();
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public CompatibilityHelper getCompatibilityHelper() {
        return this.compatibilityHelper;
    }

    public GlobalSelectionConfig getSelectionConfig(SelectionType selectionType) {
        return this.configurations.get((Object)selectionType);
    }

    public String getMessage(String path) {
        return ChatUtils.color(this.getConfig().getString("messages." + path));
    }

    private void checkUpdate() {
        try {
            URL url = new URL("https://api.spigotmc.org/legacy/update.php?resource=17311");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                String lastVersion = reader.readLine();
                if (!this.getDescription().getVersion().equalsIgnoreCase(lastVersion)) {
                    this.getLogger().warning("A new version is available ! Last version is " + lastVersion + " and you are on " + this.getDescription().getVersion());
                    this.getLogger().warning("You can download it on: " + this.getDescription().getWebsite());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void migrateV1Config() {
        File configBackupFile;
        if (this.getConfig().get("lang") == null) {
            return;
        }
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.renameTo(configBackupFile = new File(this.getDataFolder(), "config-old.yml"))) {
            this.getLogger().warning("Unable to rename old config.yml file.");
        }
        this.saveDefaultConfig();
        this.reloadConfig();
    }
}

