/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.AllListeners;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Config;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionInfo;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import net.Zrips.CMILib.Items.CMIMaterial;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.inventory.meta.BookMeta;

public class GlicthListeners
implements Listener {
    private CMI plugin;

    public GlicthListeners(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCommand(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        if (playerCommandPreprocessEvent.isCancelled()) {
            return;
        }
        if (!Config.NoCommandsInBed) {
            return;
        }
        if (!playerCommandPreprocessEvent.getPlayer().isSleeping()) {
            return;
        }
        playerCommandPreprocessEvent.setCancelled(true);
        CMILC.info_NoCommandWhileSleeping.sendMessage(playerCommandPreprocessEvent.getPlayer(), new Object[0]);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerEditBookEvent(PlayerEditBookEvent playerEditBookEvent) {
        if (playerEditBookEvent.isCancelled()) {
            return;
        }
        if (!Config.LimitBooks) {
            return;
        }
        BookMeta bookMeta = playerEditBookEvent.getNewBookMeta();
        PermissionInfo permissionInfo = this.plugin.getPermissionsManager().getPermissionInfo(playerEditBookEvent.getPlayer(), PermissionsManager.CMIPerm.book_pages_$1);
        int n = permissionInfo.getMaxValue(20);
        if (bookMeta.getPageCount() > n) {
            int n2 = n + 1;
            while (n2 <= bookMeta.getPageCount()) {
                bookMeta.setPage(n2, "");
                ++n2;
            }
            playerEditBookEvent.setNewBookMeta(bookMeta);
            CMILC.info_book_exploit.sendMessage(playerEditBookEvent.getPlayer(), "[amount]", n);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void EntityTeleportEvent(EntityTeleportEvent entityTeleportEvent) {
        if (!Config.BlockEndPortalItemTransfers) {
            return;
        }
        if (!entityTeleportEvent.getEntityType().equals((Object)EntityType.DROPPED_ITEM)) {
            return;
        }
        if (!entityTeleportEvent.getFrom().getWorld().getEnvironment().equals((Object)World.Environment.THE_END)) {
            return;
        }
        Location location = entityTeleportEvent.getFrom();
        if (!(CMIMaterial.get((Block)location.getBlock()).equals((Object)CMIMaterial.END_GATEWAY) || CMIMaterial.get((Block)location.clone().add(1.0, 0.0, 0.0).getBlock()).equals((Object)CMIMaterial.END_GATEWAY) || CMIMaterial.get((Block)location.clone().add(0.0, 0.0, 1.0).getBlock()).equals((Object)CMIMaterial.END_GATEWAY) || CMIMaterial.get((Block)location.clone().add(-1.0, 0.0, 0.0).getBlock()).equals((Object)CMIMaterial.END_GATEWAY) || CMIMaterial.get((Block)location.clone().add(0.0, 0.0, -1.0).getBlock()).equals((Object)CMIMaterial.END_GATEWAY) || CMIMaterial.get((Block)location.clone().add(0.0, 1.0, 0.0).getBlock()).equals((Object)CMIMaterial.END_GATEWAY) || CMIMaterial.get((Block)location.clone().add(0.0, -1.0, 0.0).getBlock()).equals((Object)CMIMaterial.END_GATEWAY))) {
            return;
        }
        Item item2 = (Item)entityTeleportEvent.getEntity();
        item2.setPickupDelay(0);
        entityTeleportEvent.setCancelled(true);
        entityTeleportEvent.getEntity().setVelocity(entityTeleportEvent.getEntity().getVelocity().multiply(-1));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void EntityPortalEvent(EntityPortalEvent entityPortalEvent) {
        if (!Config.BlockEndPortalItemTransfers) {
            return;
        }
        if (!entityPortalEvent.getEntityType().equals((Object)EntityType.DROPPED_ITEM)) {
            return;
        }
        if (!entityPortalEvent.getFrom().getWorld().getEnvironment().equals((Object)World.Environment.THE_END)) {
            return;
        }
        if (!entityPortalEvent.getFrom().getBlock().getType().equals((Object)Material.END_PORTAL)) {
            return;
        }
        entityPortalEvent.setCancelled(true);
    }
}

