/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.AllListeners;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.worldFlyState;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class WorldLimits
implements Listener {
    private CMI plugin;

    public WorldLimits(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler
    public void onWorldChangeGameMode(PlayerChangedWorldEvent playerChangedWorldEvent) {
        this.processGameMode(playerChangedWorldEvent.getPlayer());
    }

    @EventHandler
    public void onLoginGameMode(PlayerLoginEvent playerLoginEvent) {
        this.processGameMode(playerLoginEvent.getPlayer());
    }

    private void processGameMode(Player player) {
        if (!this.plugin.getConfigManager().WorldLimits) {
            return;
        }
        World world2 = player.getWorld();
        if (!this.plugin.getConfigManager().worldGameMode.containsKey(world2.getName())) {
            return;
        }
        if (PermissionsManager.CMIPerm.worldlimit_gamemode_bypass.hasPermission((CommandSender)player)) {
            return;
        }
        player.setGameMode(this.plugin.getConfigManager().worldGameMode.get(world2.getName()));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onWorldChangeFly(PlayerChangedWorldEvent playerChangedWorldEvent) {
        this.processFly(playerChangedWorldEvent.getPlayer(), playerChangedWorldEvent.getFrom().getName());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldChangeFlyCached(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player player = playerChangedWorldEvent.getPlayer();
        World world2 = player.getWorld();
        boolean bl = player.getAllowFlight();
        if (!this.plugin.getConfigManager().WorldLimits || !this.plugin.getConfigManager().worldFlyMode.containsKey(world2.getName())) {
            CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
            if (cMIUser == null) {
                return;
            }
            worldFlyState worldFlyState2 = cMIUser.removeFlyCachedMode(world2.getName());
            if (worldFlyState2 != null) {
                if (worldFlyState2.isFlyEnabled() && worldFlyState2.getGameMode().equals((Object)player.getGameMode())) {
                    cMIUser.setAllowFlight(true);
                    if (!player.isOnGround() && player.isOnline()) {
                        player.setFallDistance(0.0f);
                        player.setFlying(true);
                    }
                }
            } else {
                worldFlyState worldFlyState3 = cMIUser.removeFlyCachedMode(playerChangedWorldEvent.getFrom().getName());
                if (bl || worldFlyState3 != null && player.getGameMode().equals((Object)worldFlyState3.getGameMode()) && worldFlyState3.isFlyEnabled()) {
                    cMIUser.setAllowFlight(true);
                }
            }
        } else if (Version.isCurrentEqualOrLower((Version)Version.v1_16_R3) && this.plugin.getConfigManager().WorldLimits) {
            this.plugin.getConfigManager().worldFlyMode.containsKey(world2.getName());
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onTeleport(PlayerTeleportEvent playerTeleportEvent) {
        if (playerTeleportEvent.getFrom().getWorld().equals(playerTeleportEvent.getTo().getWorld())) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(playerTeleportEvent.getPlayer());
        if (playerTeleportEvent.getFrom().getWorld() != null && playerTeleportEvent.getPlayer().getAllowFlight()) {
            cMIUser.addFlyToCache(playerTeleportEvent.getFrom().getWorld().getName(), playerTeleportEvent.getPlayer().getAllowFlight(), true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onLoginFly(final PlayerLoginEvent playerLoginEvent) {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (playerLoginEvent.getPlayer().isOnline()) {
                    WorldLimits.this.processFly(playerLoginEvent.getPlayer(), playerLoginEvent.getPlayer().getWorld().getName());
                    if (playerLoginEvent.getPlayer().getAllowFlight()) {
                        CMIUser cMIUser = WorldLimits.this.plugin.getPlayerManager().getUser(playerLoginEvent.getPlayer());
                        cMIUser.addFlyToCache(playerLoginEvent.getPlayer().getWorld().getName(), playerLoginEvent.getPlayer().getAllowFlight(), false);
                    }
                }
            }
        }, 10L);
    }

    private void processFly(Player player, String string) {
        if (!this.plugin.getConfigManager().WorldLimits) {
            return;
        }
        World world2 = player.getWorld();
        if (!this.plugin.getConfigManager().worldFlyMode.containsKey(world2.getName())) {
            return;
        }
        if (PermissionsManager.CMIPerm.worldlimit_fly_bypass.hasPermission((CommandSender)player)) {
            return;
        }
        if (this.plugin.getConfigManager().worldFlyMode.get(world2.getName()).booleanValue()) {
            player.setAllowFlight(true);
            player.setFlying(true);
        } else if (!player.getGameMode().toString().equalsIgnoreCase("SPECTATOR")) {
            player.setFlying(false);
            player.setAllowFlight(false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onLoginGod(PlayerLoginEvent playerLoginEvent) {
        this.processGod(playerLoginEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldChangeGod(PlayerChangedWorldEvent playerChangedWorldEvent) {
        this.processGod(playerChangedWorldEvent.getPlayer());
    }

    private void processGod(Player player) {
        if (!this.plugin.getConfigManager().WorldLimits) {
            return;
        }
        final World world2 = player.getWorld();
        if (!this.plugin.getConfigManager().worldGodMode.containsKey(world2.getName())) {
            return;
        }
        if (PermissionsManager.CMIPerm.worldlimit_god_bypass.hasPermission((CommandSender)player)) {
            return;
        }
        final CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (cMIUser.isOnline()) {
                    boolean bl = ((WorldLimits)WorldLimits.this).plugin.getConfigManager().worldGodMode.get(world2.getName());
                    WorldLimits.this.plugin.getNMS().changeGodMode(cMIUser.getPlayer(), bl);
                }
            }
        }, 10L);
    }
}

