/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.BungeeCord;

import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class CMIBungeeCord {
    private static WeakHashMap<Plugin, CMIBungeeCord> registeredInstances = new WeakHashMap();
    private final PluginMessageListener messageListener;
    private final Plugin plugin;
    private final Map<String, Queue<CompletableFuture<?>>> callbackMap;
    private Map<String, ForwardConsumer> forwardListeners;
    private ForwardConsumer globalForwardListener;

    public static synchronized CMIBungeeCord of(Plugin plugin) {
        return registeredInstances.compute(plugin, (plugin2, cMIBungeeCord) -> {
            if (cMIBungeeCord == null) {
                cMIBungeeCord = new CMIBungeeCord(plugin);
            }
            return cMIBungeeCord;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMIBungeeCord(Plugin plugin2) {
        this.plugin = Objects.requireNonNull(plugin2, "plugin cannot be null");
        this.callbackMap = new HashMap();
        WeakHashMap<Plugin, CMIBungeeCord> weakHashMap = registeredInstances;
        synchronized (weakHashMap) {
            registeredInstances.compute(plugin2, (plugin, cMIBungeeCord) -> {
                if (cMIBungeeCord != null) {
                    cMIBungeeCord.unregister();
                }
                return this;
            });
        }
        this.messageListener = this::onPluginMessageReceived;
        Messenger messenger = Bukkit.getServer().getMessenger();
        messenger.registerOutgoingPluginChannel(plugin2, "BungeeCord");
        messenger.registerIncomingPluginChannel(plugin2, "BungeeCord", this.messageListener);
    }

    public void registerForwardListener(ForwardConsumer forwardConsumer) {
        this.globalForwardListener = forwardConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForwardListener(String string, ForwardConsumer forwardConsumer) {
        if (this.forwardListeners == null) {
            this.forwardListeners = new HashMap<String, ForwardConsumer>();
        }
        Map<String, ForwardConsumer> map = this.forwardListeners;
        synchronized (map) {
            this.forwardListeners.put(string, forwardConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Integer> getPlayerCount(String string) {
        Player player = this.getFirstPlayer();
        CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
        if (player == null) {
            return completableFuture;
        }
        ByteArrayDataOutput byteArrayDataOutput = this.callbackMap;
        synchronized (byteArrayDataOutput) {
            this.callbackMap.compute("PlayerCount-" + string, this.computeQueueValue(completableFuture));
        }
        byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("PlayerCount");
        byteArrayDataOutput.writeUTF(string);
        player.sendPluginMessage(this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<List<String>> getPlayerList(String string) {
        Player player = this.getFirstPlayer();
        CompletableFuture<List<String>> completableFuture = new CompletableFuture<List<String>>();
        if (player == null) {
            return completableFuture;
        }
        ByteArrayDataOutput byteArrayDataOutput = this.callbackMap;
        synchronized (byteArrayDataOutput) {
            this.callbackMap.compute("PlayerList-" + string, this.computeQueueValue(completableFuture));
        }
        byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("PlayerList");
        byteArrayDataOutput.writeUTF(string);
        player.sendPluginMessage(this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<List<String>> getServers() {
        Player player = this.getFirstPlayer();
        CompletableFuture<List<String>> completableFuture = new CompletableFuture<List<String>>();
        if (player == null) {
            return completableFuture;
        }
        ByteArrayDataOutput byteArrayDataOutput = this.callbackMap;
        synchronized (byteArrayDataOutput) {
            this.callbackMap.compute("GetServers", this.computeQueueValue(completableFuture));
        }
        byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("GetServers");
        player.sendPluginMessage(this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
        return completableFuture;
    }

    public void connect(Player player, String string) {
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("Connect");
        byteArrayDataOutput.writeUTF(string);
        player.sendPluginMessage(this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
    }

    public void connectOther(String string, String string2) {
        Player player = this.getFirstPlayer();
        if (player == null) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("ConnectOther");
        byteArrayDataOutput.writeUTF(string);
        byteArrayDataOutput.writeUTF(string2);
        player.sendPluginMessage(this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<InetSocketAddress> getIp(Player player) {
        CompletableFuture<InetSocketAddress> completableFuture = new CompletableFuture<InetSocketAddress>();
        ByteArrayDataOutput byteArrayDataOutput = this.callbackMap;
        synchronized (byteArrayDataOutput) {
            this.callbackMap.compute("IP", this.computeQueueValue(completableFuture));
        }
        byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("IP");
        player.sendPluginMessage(this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
        return completableFuture;
    }

    public void sendMessage(String string, String string2) {
        Player player = this.getFirstPlayer();
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        if (player == null) {
            return;
        }
        byteArrayDataOutput.writeUTF("Message");
        byteArrayDataOutput.writeUTF(string);
        byteArrayDataOutput.writeUTF(string2);
        player.sendPluginMessage(this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<String> getServer() {
        Player player = this.getFirstPlayer();
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        if (player == null) {
            return completableFuture;
        }
        ByteArrayDataOutput byteArrayDataOutput = this.callbackMap;
        synchronized (byteArrayDataOutput) {
            this.callbackMap.compute("GetServer", this.computeQueueValue(completableFuture));
        }
        byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("GetServer");
        player.sendPluginMessage(this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<String> getUUID(Player player) {
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        ByteArrayDataOutput byteArrayDataOutput = this.callbackMap;
        synchronized (byteArrayDataOutput) {
            this.callbackMap.compute("UUID", this.computeQueueValue(completableFuture));
        }
        byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("UUID");
        player.sendPluginMessage(this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<String> getUUID(String string) {
        Player player = this.getFirstPlayer();
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        if (player == null) {
            return completableFuture;
        }
        ByteArrayDataOutput byteArrayDataOutput = this.callbackMap;
        synchronized (byteArrayDataOutput) {
            this.callbackMap.compute("UUIDOther-" + string, this.computeQueueValue(completableFuture));
        }
        byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("UUIDOther");
        byteArrayDataOutput.writeUTF(string);
        player.sendPluginMessage(this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<InetSocketAddress> getServerIp(String string) {
        Player player = this.getFirstPlayer();
        CompletableFuture<InetSocketAddress> completableFuture = new CompletableFuture<InetSocketAddress>();
        if (player == null) {
            return completableFuture;
        }
        ByteArrayDataOutput byteArrayDataOutput = this.callbackMap;
        synchronized (byteArrayDataOutput) {
            this.callbackMap.compute("ServerIP-" + string, this.computeQueueValue(completableFuture));
        }
        byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("ServerIP");
        byteArrayDataOutput.writeUTF(string);
        player.sendPluginMessage(this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kickPlayer(String string, String string2) {
        Player player = this.getFirstPlayer();
        if (player == null) {
            return;
        }
        CompletableFuture completableFuture = new CompletableFuture();
        ByteArrayDataOutput byteArrayDataOutput = this.callbackMap;
        synchronized (byteArrayDataOutput) {
            this.callbackMap.compute("KickPlayer", this.computeQueueValue(completableFuture));
        }
        byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("KickPlayer");
        byteArrayDataOutput.writeUTF(string);
        byteArrayDataOutput.writeUTF(string2);
        player.sendPluginMessage(this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
    }

    public void forward(String string, String string2, byte[] byArray) {
        Player player = this.getFirstPlayer();
        if (player == null) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("Forward");
        byteArrayDataOutput.writeUTF(string);
        byteArrayDataOutput.writeUTF(string2);
        byteArrayDataOutput.writeShort(byArray.length);
        byteArrayDataOutput.write(byArray);
        player.sendPluginMessage(this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
    }

    public void forwardToPlayer(String string, String string2, byte[] byArray) {
        Player player = this.getFirstPlayer();
        if (player == null) {
            return;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        byteArrayDataOutput.writeUTF("ForwardToPlayer");
        byteArrayDataOutput.writeUTF(string);
        byteArrayDataOutput.writeUTF(string2);
        byteArrayDataOutput.writeShort(byArray.length);
        byteArrayDataOutput.write(byArray);
        player.sendPluginMessage(this.plugin, "BungeeCord", byteArrayDataOutput.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPluginMessageReceived(String string, Player player, byte[] byArray) {
        if (!string.equalsIgnoreCase("BungeeCord")) {
            return;
        }
        if (byArray == null) {
            return;
        }
        ByteArrayDataInput byteArrayDataInput = ByteStreams.newDataInput((byte[])byArray);
        String string2 = null;
        try {
            string2 = byteArrayDataInput.readUTF();
        }
        catch (Throwable throwable) {
            return;
        }
        Map<String, Queue<CompletableFuture<?>>> map = this.callbackMap;
        synchronized (map) {
            block43: {
                block40: {
                    try {
                        block41: {
                            if (!string2.equals("PlayerCount") && !string2.equals("PlayerList") && !string2.equals("UUIDOther") && !string2.equals("ServerIP")) break block40;
                            String string3 = byteArrayDataInput.readUTF();
                            Queue<CompletableFuture<?>> queue = this.callbackMap.get(String.valueOf(string2) + "-" + string3);
                            if (queue == null || queue.isEmpty()) {
                                return;
                            }
                            CompletableFuture<?> completableFuture = queue.poll();
                            try {
                                block46: {
                                    block45: {
                                        block44: {
                                            String string4 = string2;
                                            switch (string4.hashCode()) {
                                                case -2095967602: {
                                                    if (string4.equals("PlayerCount")) break;
                                                    break block41;
                                                }
                                                case -205896897: {
                                                    if (!string4.equals("PlayerList")) {
                                                        break block41;
                                                    }
                                                    break block44;
                                                }
                                                case 1186775061: {
                                                    if (!string4.equals("UUIDOther")) {
                                                        break block41;
                                                    }
                                                    break block45;
                                                }
                                                case 1443747786: {
                                                    if (!string4.equals("ServerIP")) {
                                                        break block41;
                                                    }
                                                    break block46;
                                                }
                                            }
                                            completableFuture.complete(byteArrayDataInput.readInt());
                                            break block41;
                                        }
                                        completableFuture.complete(Arrays.asList(byteArrayDataInput.readUTF().split(", ")));
                                        break block41;
                                    }
                                    String string5 = byteArrayDataInput.readUTF().replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5");
                                    completableFuture.complete(string5);
                                    break block41;
                                }
                                String string6 = byteArrayDataInput.readUTF();
                                int n = byteArrayDataInput.readUnsignedShort();
                                completableFuture.complete(new InetSocketAddress(string6, n));
                            }
                            catch (Exception exception) {
                                completableFuture.completeExceptionally(exception);
                            }
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        return;
                    }
                }
                Queue<CompletableFuture<?>> queue = this.callbackMap.get(string2);
                if (queue == null) {
                    block42: {
                        try {
                            short s = byteArrayDataInput.readShort();
                            byte[] byArray2 = new byte[s];
                            byteArrayDataInput.readFully(byArray2);
                            if (this.globalForwardListener != null) {
                                this.globalForwardListener.accept(string2, player, byArray2);
                            }
                            if (this.forwardListeners == null) break block42;
                            Map<String, ForwardConsumer> map2 = this.forwardListeners;
                            synchronized (map2) {
                                ForwardConsumer forwardConsumer = this.forwardListeners.get(string2);
                                if (forwardConsumer != null) {
                                    forwardConsumer.accept(string2, player, byArray2);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return;
                }
                if (queue.isEmpty()) {
                    return;
                }
                CompletableFuture<?> completableFuture = queue.poll();
                try {
                    block47: {
                        String string7 = string2;
                        switch (string7.hashCode()) {
                            case -1500810727: {
                                if (string7.equals("GetServer")) break;
                                break block43;
                            }
                            case 2343: {
                                if (!string7.equals("IP")) {
                                    break block43;
                                }
                                break block47;
                            }
                            case 2616251: {
                                if (string7.equals("UUID")) break;
                                break block43;
                            }
                            case 719507834: {
                                if (string7.equals("GetServers")) {
                                    completableFuture.complete(Arrays.asList(byteArrayDataInput.readUTF().split(", ")));
                                }
                                break block43;
                            }
                        }
                        completableFuture.complete(byteArrayDataInput.readUTF());
                        break block43;
                    }
                    String string8 = byteArrayDataInput.readUTF();
                    int n = byteArrayDataInput.readInt();
                    completableFuture.complete(new InetSocketAddress(string8, n));
                }
                catch (Exception exception) {
                    completableFuture.completeExceptionally(exception);
                }
            }
        }
    }

    public void unregister() {
        Messenger messenger = Bukkit.getServer().getMessenger();
        messenger.unregisterIncomingPluginChannel(this.plugin, "BungeeCord", this.messageListener);
        messenger.unregisterOutgoingPluginChannel(this.plugin);
        this.callbackMap.clear();
    }

    private BiFunction<String, Queue<CompletableFuture<?>>, Queue<CompletableFuture<?>>> computeQueueValue(CompletableFuture<?> completableFuture) {
        return (string, arrayDeque) -> {
            if (arrayDeque == null) {
                arrayDeque = new ArrayDeque<CompletableFuture>();
            }
            arrayDeque.add(completableFuture);
            return arrayDeque;
        };
    }

    private Player getFirstPlayer() {
        return this.getFirstPlayer0(Bukkit.getOnlinePlayers());
    }

    private Player getFirstPlayer0(Player[] playerArray) {
        return playerArray.length > 0 ? playerArray[0] : null;
    }

    private Player getFirstPlayer0(Collection<? extends Player> collection) {
        return (Player)Iterables.getFirst(collection, null);
    }

    @FunctionalInterface
    public static interface ForwardConsumer {
        public void accept(String var1, Player var2, byte[] var3);
    }
}

