/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.DataBase;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.DataBase.DBConnection;
import com.Zrips.CMI.Modules.DataBase.DBDAO;
import com.Zrips.CMI.Modules.DataBase.DBManager;
import java.io.File;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBSQLite
extends DBDAO {
    public void initialize() {
        try {
            this.setUp();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    DBSQLite(CMI cMI, File file) {
        super(cMI, "org.sqlite.JDBC", "jdbc:sqlite:" + new File(file, "cmi.sqlite.db").getPath(), null, null, "");
        if (!file.exists()) {
            file.mkdirs();
        }
        this.setDbType(DBManager.DataBaseType.SqLite);
    }

    @Override
    public Statement prepareStatement(String string) {
        DBConnection dBConnection = this.getConnection();
        if (dBConnection == null) {
            return null;
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = dBConnection.prepareStatement(string);
        }
        catch (NumberFormatException | SQLException exception) {
            exception.printStackTrace();
        }
        return preparedStatement;
    }

    @Override
    public boolean createTable(String string) {
        Statement statement;
        block3: {
            statement = null;
            try {
                if (string != null && !string.equals("")) break block3;
                this.plugin.consoleMessage("&cCould not create table: query is empty or null.");
                return false;
            }
            catch (SQLException sQLException) {
                this.plugin.consoleMessage("&cCould not create table, SQLException: " + sQLException.getMessage());
                this.close(statement);
                return false;
            }
        }
        statement = this.getConnection().createStatement();
        statement.execute(string);
        statement.close();
        return true;
    }

    @Override
    public boolean isTable(String string) {
        ResultSet resultSet;
        block3: {
            DatabaseMetaData databaseMetaData = null;
            try {
                databaseMetaData = this.getConnection().getMetaData();
                resultSet = databaseMetaData.getTables(null, null, string, null);
                if (!resultSet.next()) break block3;
                resultSet.close();
                return true;
            }
            catch (SQLException sQLException) {
                this.plugin.consoleMessage("&cCould not check if table \"" + string + "\" exists, SQLException: " + sQLException.getMessage());
                return false;
            }
        }
        resultSet.close();
        return false;
    }

    @Override
    public boolean isCollumn(String string, String string2) {
        ResultSet resultSet;
        block3: {
            DatabaseMetaData databaseMetaData = null;
            try {
                databaseMetaData = this.getConnection().getMetaData();
                resultSet = databaseMetaData.getColumns(null, null, string, string2);
                if (!resultSet.next()) break block3;
                resultSet.close();
                return true;
            }
            catch (SQLException sQLException) {
                this.plugin.consoleMessage("&cCould not check if table \"" + string + "\" exists, SQLException: " + sQLException.getMessage());
                return false;
            }
        }
        resultSet.close();
        return false;
    }

    @Override
    public boolean addCollumn(String string, String string2, String string3) {
        Statement statement;
        try {
            statement = this.getConnection().createStatement();
        }
        catch (SQLException sQLException) {
            this.plugin.consoleMessage("&cCould not add new collumn, SQLException: " + sQLException.getMessage());
            return false;
        }
        try {
            statement.executeQuery("ALTER TABLE " + string + " ADD " + string2 + " " + string3);
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            this.close(statement);
            return false;
        }
    }

    @Override
    public boolean truncate(String string) {
        Statement statement;
        block4: {
            statement = null;
            try {
                if (this.isTable(string)) break block4;
                this.plugin.consoleMessage("&cTable \"" + string + "\" does not exist.");
                return false;
            }
            catch (SQLException sQLException) {
                if (!(sQLException.getMessage().toLowerCase().contains("locking") || sQLException.getMessage().toLowerCase().contains("locked") || sQLException.toString().contains("not return ResultSet"))) {
                    this.plugin.consoleMessage("&cError in wipeTable() query: " + sQLException);
                }
                this.close(statement);
                return false;
            }
        }
        statement = this.getConnection().createStatement();
        statement.executeQuery("DELETE FROM " + string + ";");
        statement.close();
        return true;
    }

    @Override
    public String getTableCharSet(DBDAO.DBTables dBTables) {
        return null;
    }

    @Override
    public boolean convertTableToUTF8(DBDAO.DBTables dBTables) {
        return true;
    }

    @Override
    public String getTableRowFormat(DBDAO.DBTables dBTables) {
        return null;
    }

    @Override
    public boolean convertTableRowFormat(DBDAO.DBTables dBTables) {
        return true;
    }
}

