/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.DynamicSigns;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.DynamicSigns.CMISign;
import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import com.Zrips.CMI.Modules.Portals.CuboidArea;
import com.Zrips.CMI.Modules.Worlds.CMIWorldListener;
import com.Zrips.CMI.Modules.Worlds.UpdateOnWorldLoad;
import com.Zrips.CMI.commands.list.dsign;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIList;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.GUI.CMIGui;
import net.Zrips.CMILib.GUI.CMIGuiButton;
import net.Zrips.CMILib.GUI.GUIManager;
import net.Zrips.CMILib.Items.CMIMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SignManager {
    private Set<CMISign> signs;
    protected Map<String, Map<CuboidArea.ChunkRef, Set<CMISign>>> chunkSignsRange;
    private Map<UUID, Set<CMISign>> playerNearSigns;
    private Map<CMISign, Set<UUID>> lastSignInRange;
    private int SignRangeCheckInterval = 500;
    private HashMap<CMIChatColor, CMIChatColor> colorChange = new HashMap();
    private Integer saveId = null;
    private CMI plugin;
    private int sched = -1;
    private List<String> signEditBlackList = new ArrayList<String>();
    private String fileName = "DynamicSigns.yml";
    boolean saving = false;

    public SignManager(CMI cMI) {
        this.plugin = cMI;
        this.lastSignInRange = new HashMap<CMISign, Set<UUID>>();
        this.signs = new HashSet<CMISign>();
        this.chunkSignsRange = new HashMap<String, Map<CuboidArea.ChunkRef, Set<CMISign>>>();
        this.playerNearSigns = new HashMap<UUID, Set<CMISign>>();
    }

    public void stop() {
        if (this.saveId != null) {
            Bukkit.getScheduler().cancelTask(this.saveId.intValue());
            this.saveSigns();
        }
        if (this.sched == -1) {
            return;
        }
        Bukkit.getScheduler().cancelTask(this.sched);
        this.sched = -1;
    }

    public void addSign(CMISign cMISign) {
        this.signs.add(cMISign);
        this.recalculateChunks(cMISign);
    }

    public void recalculateChunks() {
        this.chunkSignsRange.clear();
        for (CMISign cMISign : this.signs) {
            this.recalculateChunks(cMISign);
        }
    }

    public void recalculateChunks(final CMISign cMISign) {
        if (cMISign.getLoc().getWorld() == null) {
            UpdateOnWorldLoad updateOnWorldLoad = new UpdateOnWorldLoad(){

                @Override
                public void update(World world2) {
                    cMISign.getLoc().setWorld(world2);
                    SignManager.this.recalculateChunks(cMISign);
                    SignManager.this.plugin.consoleMessage("Missing (" + world2.getName() + ") world loaded. Recalculating dynamic sign position");
                }
            };
            CMIWorldListener.delayRecheck(cMISign.getLoc().getWorldName(), updateOnWorldLoad);
            return;
        }
        Map<CuboidArea.ChunkRef, Set<CMISign>> map = this.chunkSignsRange.get(cMISign.getLoc().getWorldName());
        if (map == null) {
            map = new HashMap<CuboidArea.ChunkRef, Set<CMISign>>();
        }
        for (CuboidArea.ChunkRef chunkRef : SignManager.getChunks(cMISign)) {
            HashSet<CMISign> hashSet = new HashSet<CMISign>();
            if (map.containsKey(chunkRef)) {
                hashSet.addAll((Collection)map.get(chunkRef));
            }
            hashSet.add(cMISign);
            map.put(chunkRef, hashSet);
        }
        this.chunkSignsRange.put(cMISign.getLoc().getWorldName(), map);
    }

    public CMISign getByLoc(Location location) {
        if (location == null) {
            return null;
        }
        World world2 = location.getWorld();
        if (world2 == null) {
            return null;
        }
        String string = world2.getName();
        if (string == null) {
            return null;
        }
        CuboidArea.ChunkRef chunkRef = new CuboidArea.ChunkRef(location);
        if (!this.chunkSignsRange.containsKey(string)) {
            return null;
        }
        Map<CuboidArea.ChunkRef, Set<CMISign>> map = this.chunkSignsRange.get(string);
        if (map.containsKey(chunkRef)) {
            for (CMISign cMISign : map.get(chunkRef)) {
                if (cMISign == null || !cMISign.getLoc().toString().equals(location.toString())) continue;
                return cMISign;
            }
        }
        return null;
    }

    public Set<CMISign> getAllInRangeByLoc(Location location) {
        HashSet<CMISign> hashSet = new HashSet<CMISign>();
        if (location == null) {
            return hashSet;
        }
        World world2 = location.getWorld();
        if (world2 == null) {
            return hashSet;
        }
        String string = world2.getName();
        if (string == null) {
            return hashSet;
        }
        CuboidArea.ChunkRef chunkRef = new CuboidArea.ChunkRef(location);
        if (!this.chunkSignsRange.containsKey(string)) {
            return hashSet;
        }
        Map<CuboidArea.ChunkRef, Set<CMISign>> map = this.chunkSignsRange.get(string);
        if (map.containsKey(chunkRef)) {
            for (CMISign cMISign : map.get(chunkRef)) {
                if (cMISign == null || !cMISign.getArea().containsLoc(location)) continue;
                hashSet.add(cMISign);
            }
        }
        return hashSet;
    }

    public void handleSignUpdates(Player player, Location location) {
        Set<CMISign> set = this.playerNearSigns.get(player.getUniqueId());
        Set<CMISign> set2 = this.getAllInRangeByLoc(location);
        HashSet<CMISign> hashSet = new HashSet<CMISign>();
        HashSet<CMISign> hashSet2 = new HashSet<CMISign>();
        if (set != null) {
            for (CMISign cMISign : set) {
                if (set2.contains(cMISign)) continue;
                hashSet.add(cMISign);
            }
            for (CMISign cMISign : set2) {
                if (set.contains(cMISign)) continue;
                hashSet2.add(cMISign);
            }
        } else {
            hashSet2.addAll(set2);
        }
        if (set2.isEmpty()) {
            this.playerNearSigns.remove(player.getUniqueId());
        } else {
            this.playerNearSigns.put(player.getUniqueId(), set2);
        }
        for (CMISign cMISign : hashSet) {
            this.removeLastSignInRange(cMISign, player.getUniqueId());
            this.removeNearSign(player.getUniqueId(), cMISign);
        }
        for (CMISign cMISign : hashSet2) {
            this.addLastSignInRange(cMISign, player.getUniqueId());
            this.addNearSign(player.getUniqueId(), cMISign);
        }
    }

    private static List<CuboidArea.ChunkRef> getChunks(CMISign cMISign) {
        ArrayList<CuboidArea.ChunkRef> arrayList = new ArrayList<CuboidArea.ChunkRef>();
        arrayList.addAll(cMISign.getArea().getChunks());
        return arrayList;
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Signs.CheckInterval", new String[]{"Defines in milliseconds how often to check if player entered Dynamic Sign trigger area", "Bigger numbers can help slightly lower server load", "This is not essential to keep in low numbers"});
        this.SignRangeCheckInterval = configReader.get("Signs.CheckInterval", 3000);
        configReader.addComment("Signs.editBlackList", new String[]{"Defines list sign top lines which cant be edited with shift right click", "Usually used for preventing shop sign modifications"});
        this.signEditBlackList = configReader.get("Signs.editBlackList", Arrays.asList("[Shop]"));
        CMIList.toLowerCase(this.signEditBlackList);
        CMIList.removeColors(this.signEditBlackList);
    }

    public void load() {
        Long l = System.currentTimeMillis();
        this.stop();
        this.signs.clear();
        this.chunkSignsRange.clear();
        this.lastSignInRange.clear();
        this.playerNearSigns.clear();
        this.plugin.safeRenameFile("dynamicSigns.yml", "Saves" + File.separator + this.fileName);
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Saves" + File.separator + this.fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (configReader == null) {
            return;
        }
        if (configReader.getC().getKeys(false).isEmpty()) {
            return;
        }
        Set set = configReader.getC().getKeys(false);
        for (String string : set) {
            CMISign cMISign;
            CMILocation cMILocation;
            if (!configReader.getC().isString(String.valueOf(string) + ".Loc") || (cMILocation = this.plugin.getPlayerManager().convertStringToLocation(configReader.getC().getString(String.valueOf(string) + ".Loc"))) == null || !configReader.getC().isList(String.valueOf(string) + ".Lines") || (cMISign = this.getByLoc((Location)cMILocation)) != null) continue;
            CMISign cMISign2 = new CMISign(cMILocation);
            cMISign2.setLines(configReader.getC().getStringList(String.valueOf(string) + ".Lines"));
            if (configReader.getC().isBoolean(String.valueOf(string) + ".Personal")) {
                cMISign2.setPersonal(configReader.getC().getBoolean(String.valueOf(string) + ".Personal"));
            }
            if (configReader.getC().isDouble(String.valueOf(string) + ".Interval")) {
                cMISign2.setUpdateIntervalSec(configReader.getC().getDouble(String.valueOf(string) + ".Interval"));
            } else if (configReader.getC().isInt(String.valueOf(string) + ".Interval")) {
                cMISign2.setUpdateIntervalSec(configReader.getC().getInt(String.valueOf(string) + ".Interval"));
            }
            if (configReader.getC().isInt(String.valueOf(string) + ".Range")) {
                cMISign2.setActivationRange(configReader.getC().getInt(String.valueOf(string) + ".Range"));
            }
            this.addSign(cMISign2);
        }
        this.plugin.loadMessage(this.signs.size(), "dynamic signs", System.currentTimeMillis() - l);
    }

    public void save() {
        if (this.saveId != null) {
            return;
        }
        this.saveId = Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                SignManager.this.saveSigns();
                SignManager.this.saveId = null;
            }
        }, 100L);
    }

    private void saveSigns() {
        if (this.saving) {
            return;
        }
        this.saving = true;
        try {
            ConfigReader configReader = null;
            try {
                configReader = new ConfigReader((Plugin)CMI.getInstance(), "Saves" + File.separator + this.fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (configReader == null) {
                return;
            }
            for (Map.Entry entry : configReader.getC().getValues(false).entrySet()) {
                configReader.getC().set((String)entry.getKey(), null);
            }
            int n = 0;
            for (CMISign cMISign : this.signs) {
                configReader.get(String.valueOf(++n) + ".Loc", this.plugin.getPlayerManager().convertLocToStringShort(cMISign.getLoc()));
                configReader.get(String.valueOf(n) + ".Interval", Double.valueOf(cMISign.getUpdateIntervalSec()));
                configReader.get(String.valueOf(n) + ".Range", cMISign.getActivationRange());
                configReader.get(String.valueOf(n) + ".Personal", Boolean.valueOf(cMISign.isPersonal()));
                configReader.get(String.valueOf(n) + ".Lines", cMISign.getLines());
            }
            configReader.save();
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
        }
        this.saving = false;
    }

    public void removeLastSignInRange(CMISign cMISign, UUID uUID) {
        Set<UUID> set = this.lastSignInRange.get(cMISign);
        if (set == null) {
            return;
        }
        set.remove(uUID);
        if (set.isEmpty()) {
            this.lastSignInRange.remove(cMISign);
            return;
        }
        this.lastSignInRange.put(cMISign, set);
    }

    public void addLastSignInRange(CMISign cMISign, UUID uUID) {
        Set<UUID> set = this.lastSignInRange.get(cMISign);
        if (set == null) {
            set = new HashSet<UUID>();
        }
        set.add(uUID);
        this.lastSignInRange.put(cMISign, set);
        if (this.sched == -1) {
            this.tasker();
        }
    }

    public void removeLastSignInRange(UUID uUID) {
        HashMap<CMISign, Set<UUID>> hashMap = new HashMap<CMISign, Set<UUID>>(this.lastSignInRange);
        for (Map.Entry<CMISign, Set<UUID>> entry : hashMap.entrySet()) {
            Set<UUID> set = entry.getValue();
            if (set == null) continue;
            set.remove(uUID);
            if (set.isEmpty()) {
                this.lastSignInRange.remove(entry.getKey());
                continue;
            }
            this.lastSignInRange.put(entry.getKey(), set);
        }
    }

    private void tasker() {
        if (!CMIModule.dynamicSigns.isEnabled()) {
            return;
        }
        this.sched = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (SignManager.this.playerNearSigns.isEmpty() && SignManager.this.sched != -1) {
                    Bukkit.getScheduler().cancelTask(SignManager.this.sched);
                    SignManager.this.sched = -1;
                    return;
                }
                for (Map.Entry entry : new HashMap(SignManager.this.lastSignInRange).entrySet()) {
                    SignManager.updateSign((CMISign)entry.getKey(), (Set)entry.getValue());
                }
            }
        }, 0L, 2L);
    }

    public void addPlayersNearSign(CMISign cMISign) {
        Set<UUID> set = this.lastSignInRange.get(cMISign);
        if (set == null) {
            set = new HashSet<UUID>();
        }
        set.clear();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (cMISign.getArea() == null || !cMISign.getArea().containsLoc(player.getLocation())) continue;
            set.add(player.getUniqueId());
        }
        this.lastSignInRange.put(cMISign, set);
        if (this.sched == -1) {
            this.tasker();
        }
    }

    private static void updateSign(Player player, CMISign cMISign) {
        if (!cMISign.isPersonal()) {
            cMISign.update();
        } else {
            cMISign.update(player);
        }
    }

    private void updateSign(CMISign cMISign) {
        Set<UUID> set = this.lastSignInRange.get(cMISign);
        if (set == null || set.isEmpty()) {
            return;
        }
        SignManager.updateSign(cMISign, set);
    }

    private static void updateSign(CMISign cMISign, Set<UUID> set) {
        if (set == null || set.isEmpty()) {
            return;
        }
        if (!cMISign.isTimeToUpdate()) {
            return;
        }
        if (!cMISign.isPersonal()) {
            cMISign.update();
        } else {
            for (UUID uUID : new HashSet<UUID>(set)) {
                Player player = CMIUser.getOnlinePlayer(uUID);
                cMISign.update(player);
            }
        }
        cMISign.setAsUpdated();
        cMISign.updateCurrentLine();
    }

    public Set<CMISign> getSigns() {
        return this.signs;
    }

    public List<CMISign> getSignsByDistance(Location location) {
        HashMap hashMap = new HashMap();
        ArrayList<CMISign> arrayList = new ArrayList<CMISign>();
        for (CMISign cMISign : this.signs) {
            if (!location.getWorld().equals(cMISign.getWorld())) {
                arrayList.add(cMISign);
                continue;
            }
            hashMap.put(cMISign, (int)cMISign.getArea().getMiddleLocation().distance(location));
        }
        hashMap = this.plugin.getSortingManager().sortByValueObject(hashMap);
        ArrayList<CMISign> arrayList2 = new ArrayList<CMISign>();
        for (Map.Entry entry : hashMap.entrySet()) {
            arrayList2.add((CMISign)entry.getKey());
        }
        if (!arrayList.isEmpty()) {
            arrayList2.addAll(arrayList);
        }
        return arrayList2;
    }

    public void removeSign(CMISign cMISign) {
        this.signs.remove(cMISign);
        this.lastSignInRange.remove(cMISign);
        this.recalculateChunks();
        this.save();
    }

    public int getSignCheckInterval() {
        return this.SignRangeCheckInterval;
    }

    public boolean isNearSign(UUID uUID) {
        Set<CMISign> set = this.playerNearSigns.get(uUID);
        return set != null && !set.isEmpty();
    }

    public void addNearSign(UUID uUID, CMISign cMISign) {
        Set<CMISign> set = this.playerNearSigns.get(uUID);
        if (set == null) {
            set = new HashSet<CMISign>();
        }
        set.add(cMISign);
        this.playerNearSigns.put(uUID, set);
        SignManager.updateSign(CMIUser.getOnlinePlayer(uUID), cMISign);
    }

    public void removeNearSign(UUID uUID, CMISign cMISign) {
        Set<CMISign> set = this.playerNearSigns.get(uUID);
        if (set == null) {
            return;
        }
        set.remove(cMISign);
        if (set.isEmpty()) {
            this.playerNearSigns.remove(uUID);
        }
    }

    public void removeNearSign(UUID uUID) {
        this.playerNearSigns.remove(uUID);
    }

    public void openGui(final Player player, final CMISign cMISign) {
        CMIGui cMIGui = new CMIGui(player);
        cMIGui.setTitle("Dynamic sign");
        cMIGui.setInvSize(GUIManager.GUIRows.r3);
        CMIGuiButton cMIGuiButton = new CMIGuiButton(10, cMISign.isPersonal() ? CMIMaterial.GREEN_WOOL : CMIMaterial.RED_WOOL){

            public void click(GUIManager.GUIClickType gUIClickType) {
                SignManager.changeIndividual(player, cMISign);
            }
        };
        cMIGuiButton.setName(CMILC.getIM(dsign.class, "individual", "[state]", cMISign.isPersonal()));
        cMIGuiButton.addLore(CMILC.getIML(dsign.class, "individualLore", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(12, CMIMaterial.BROWN_WOOL){

            public void click(GUIManager.GUIClickType gUIClickType) {
                SignManager.changeInterval(player, gUIClickType, cMISign);
            }
        };
        cMIGuiButton.setName(CMILC.getIM(dsign.class, "interval", "[second]", cMISign.getUpdateIntervalSec()));
        cMIGuiButton.addLore(CMILC.getIML(dsign.class, "intervalLore", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGuiButton = new CMIGuiButton(14, CMIMaterial.YELLOW_WOOL){

            public void click(GUIManager.GUIClickType gUIClickType) {
                SignManager.changeRange(player, gUIClickType, cMISign);
            }
        };
        cMIGuiButton.setName(CMILC.getIM(dsign.class, "range", "[blocks]", cMISign.getActivationRange()));
        cMIGuiButton.addLore(CMILC.getIML(dsign.class, "rangeLore", new Object[0]));
        cMIGui.addButton(cMIGuiButton);
        cMIGui.fillEmptyButtons();
        cMIGui.open();
    }

    public static void changeIndividual(Player player, CMISign cMISign) {
        cMISign.setPersonal(!cMISign.isPersonal());
        CMI.getInstance().getSignManager().openGui(player, cMISign);
        CMI.getInstance().getSignManager().save();
    }

    public static void changeRange(Player player, GUIManager.GUIClickType gUIClickType, CMISign cMISign) {
        switch (gUIClickType) {
            case Left: {
                cMISign.setActivationRange(cMISign.getActivationRange() - 1);
                break;
            }
            case LeftShift: {
                cMISign.setActivationRange(cMISign.getActivationRange() - 10);
                break;
            }
            case Right: {
                cMISign.setActivationRange(cMISign.getActivationRange() + 1);
                break;
            }
            case RightShift: {
                cMISign.setActivationRange(cMISign.getActivationRange() + 10);
                break;
            }
        }
        cMISign.setArea(null);
        CMI.getInstance().getSignManager().recalculateChunks(cMISign);
        CMI.getInstance().getSignManager().addPlayersNearSign(cMISign);
        CMI.getInstance().getSignManager().openGui(player, cMISign);
        CMI.getInstance().getSignManager().save();
        CMI.getInstance().getSelectionManager().setSelectionCuboid(player, cMISign.getArea());
        CMI.getInstance().getSelectionManager().showSelection(player);
    }

    public static void changeInterval(Player player, GUIManager.GUIClickType gUIClickType, CMISign cMISign) {
        switch (gUIClickType) {
            case Left: {
                if (cMISign.getUpdateIntervalSec() > 0.0 && cMISign.getUpdateIntervalSec() <= 1.0) {
                    cMISign.setUpdateIntervalSec((cMISign.getUpdateIntervalSec() * 10.0 - 1.0) / 10.0);
                    break;
                }
                cMISign.setUpdateIntervalSec(cMISign.getUpdateIntervalSec() - 1.0);
                break;
            }
            case LeftShift: {
                cMISign.setUpdateIntervalSec(cMISign.getUpdateIntervalSec() - 10.0);
                break;
            }
            case Right: {
                if (cMISign.getUpdateIntervalSec() >= 0.0 && cMISign.getUpdateIntervalSec() < 1.0) {
                    cMISign.setUpdateIntervalSec((cMISign.getUpdateIntervalSec() * 10.0 + 1.0) / 10.0);
                    break;
                }
                cMISign.setUpdateIntervalSec(cMISign.getUpdateIntervalSec() + 1.0);
                break;
            }
            case RightShift: {
                cMISign.setUpdateIntervalSec(cMISign.getUpdateIntervalSec() + 10.0);
                break;
            }
        }
        CMI.getInstance().getSignManager().openGui(player, cMISign);
        CMI.getInstance().getSignManager().save();
    }

    public HashMap<CMIChatColor, CMIChatColor> getColorChange() {
        return this.colorChange;
    }

    public void setColorChange(HashMap<CMIChatColor, CMIChatColor> hashMap) {
        this.colorChange = hashMap;
    }

    public List<String> getSignEditBlackList() {
        return this.signEditBlackList;
    }
}

