/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.PlayTimeRewards;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.PlayTimeRewards.PTROneTime;
import com.Zrips.CMI.Modules.PlayTimeRewards.PTRRepeat;
import com.Zrips.CMI.Modules.PlayTimeRewards.PlayTimeReward;
import com.Zrips.CMI.Modules.PlayTimeRewards.PlaytimeClaimCache;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayTimeRewardsManager {
    private CMI plugin;
    private HashMap<String, PTRRepeat> repeatableRewards = new HashMap();
    private TreeMap<Long, PTROneTime> oneTimeRewards = new TreeMap();
    private TreeMap<String, PTROneTime> oneTimeRewardsByName = new TreeMap();
    private int sched = -1;
    private int interval = 1;
    private int OneTimeAmount = 1;
    private Long RewardInform = 1000L;
    private boolean Enabled = false;
    private boolean ExcludeAfk = false;
    public static boolean RequiresPermission = false;
    private HashMap<CMIUser, Long> lastAction = new HashMap();
    HashMap<UUID, Long> informMap = new HashMap();
    private String fileName = "PlayTimeRewards.yml";
    ConcurrentHashMap<UUID, PlaytimeClaimCache> cache = new ConcurrentHashMap();

    public PlayTimeRewardsManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void stop() {
        if (this.sched == -1) {
            return;
        }
        Bukkit.getScheduler().cancelTask(this.sched);
        this.sched = -1;
    }

    public void loadConfig() {
        this.stop();
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("PlaytimeRewards.Enabled", new String[]{"Enable or disable playtime rewards.", "This is required if you want to have auto rewards"});
        this.Enabled = configReader.get("PlaytimeRewards.Enabled", Boolean.valueOf(false));
        configReader.addComment("PlaytimeRewards.ExcludeAfk", new String[]{"When enabled, while player is in afk mode, repeatable playtime rewards will not increase in playtime", "ATTENTION! this setting will not have any effect if you have Afk.StopPlayTime set to true", "When StopPlayTime set to true, afk will be expluded automatically"});
        this.ExcludeAfk = configReader.get("PlaytimeRewards.ExcludeAfk", Boolean.valueOf(false));
        configReader.addComment("PlaytimeRewards.RewardInform", new String[]{"Defines time in minutes to inform player about pending reward which needs to be claimed"});
        this.RewardInform = (long)(configReader.get("PlaytimeRewards.RewardInform", 15) * 60) * 1000L;
        configReader.addComment("PlaytimeRewards.OneTimeAmount", new String[]{"Defines how many one time rewards you want to show in list", "This will show next X amount rewards from your current playtime", "No point in listing all rewards if player is still far away"});
        this.OneTimeAmount = configReader.get("PlaytimeRewards.OneTimeAmount", 2);
        configReader.addComment("PlaytimeRewards.RequiresPermission", new String[]{"When set to true player will be required to have cmi.prewards.[name] permission node to get particular playtime reward"});
        RequiresPermission = configReader.get("PlaytimeRewards.RequiresPermission", Boolean.valueOf(false));
        if (this.plugin.isEnabled() && this.Enabled) {
            this.tasker();
        } else {
            this.stop();
        }
    }

    public void removeFromAfkAction(CMIUser cMIUser) {
        this.lastAction.remove(cMIUser);
    }

    public void updateAfkAction(CMIUser cMIUser) {
        this.lastAction.put(cMIUser, System.currentTimeMillis());
    }

    public Long getAfkAction(CMIUser cMIUser) {
        return this.lastAction.get(cMIUser);
    }

    private void tasker() {
        if (this.sched != -1) {
            return;
        }
        this.sched = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)PlayTimeRewardsManager.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        block0: for (final Player player : Bukkit.getOnlinePlayers()) {
                            PlayTimeReward playTimeReward;
                            CMIUser cMIUser = PlayTimeRewardsManager.this.plugin.getPlayerManager().getUser(player);
                            long l = cMIUser.getTotalPlayTime(false);
                            long l2 = 0L;
                            if (PlayTimeRewardsManager.this.isExcludeAfk() && cMIUser.isAfk() && !PlayTimeRewardsManager.this.plugin.getAfkManager().isStopPlayTime()) {
                                Map.Entry entry = PlayTimeRewardsManager.this.plugin.getAfkManager().getLastAction(cMIUser);
                                if (entry != null) {
                                    Long l3 = (Long)PlayTimeRewardsManager.this.lastAction.get(cMIUser);
                                    l2 = l3 != null ? System.currentTimeMillis() - l3 : System.currentTimeMillis() - (Long)((Object)entry);
                                    PlayTimeRewardsManager.this.lastAction.put(cMIUser, System.currentTimeMillis());
                                } else if (cMIUser.isAfk()) {
                                    PlayTimeRewardsManager.this.plugin.getAfkManager().updateUser(cMIUser);
                                }
                            }
                            for (Map.Entry entry : PlayTimeRewardsManager.this.repeatableRewards.entrySet()) {
                                playTimeReward = (PTRRepeat)entry.getValue();
                                Long l4 = cMIUser.getRepeatableRewardTime(playTimeReward.getName());
                                if (l4 != null && l4 > l) {
                                    cMIUser.addRepeatableReward(playTimeReward.getName(), l);
                                    l4 = l;
                                }
                                if (l4 != null && PlayTimeRewardsManager.this.isExcludeAfk() && cMIUser.isAfk() && !PlayTimeRewardsManager.this.plugin.getAfkManager().isStopPlayTime()) {
                                    if ((l4 = Long.valueOf(l4 + l2)) > l) {
                                        l4 = l;
                                    }
                                    cMIUser.addRepeatableReward(playTimeReward.getName(), l4);
                                    continue;
                                }
                                if (l4 == null) {
                                    cMIUser.addRepeatableReward(playTimeReward.getName(), l);
                                    cMIUser.addForPlayTimeRewardSave();
                                    continue;
                                }
                                long l5 = l - l4;
                                int n = (int)((double)l5 / ((PTRRepeat)playTimeReward).getPayEvery().doubleValue());
                                if (n < 1) continue;
                                if (playTimeReward.isAutoClaim() && !cMIUser.isJailed() && !cMIUser.isCuffed()) {
                                    if (player == null || !player.isOnline()) continue;
                                    long l6 = ((PTRRepeat)playTimeReward).getPayEvery() * (long)n;
                                    l6 = l4 + l6 > l ? l : l4 + l6;
                                    cMIUser.addRepeatableReward(playTimeReward.getName(), l6);
                                    cMIUser.addForPlayTimeRewardSave();
                                    if (RequiresPermission && !PermissionsManager.CMIPerm.prewards_$1.hasPermission((CommandSender)player, playTimeReward.getName().toLowerCase())) continue;
                                    Bukkit.getScheduler().runTask((Plugin)PlayTimeRewardsManager.this.plugin, new Runnable((PTRRepeat)playTimeReward){
                                        private final /* synthetic */ PTRRepeat val$reward;
                                        {
                                            this.val$reward = pTRRepeat;
                                        }

                                        @Override
                                        public void run() {
                                            if (player.isOnline()) {
                                                this.val$reward.performCommands(player);
                                            }
                                        }
                                    });
                                    continue;
                                }
                                if (player == null || !player.isOnline()) continue;
                                PlayTimeRewardsManager.this.informPlayer(player, playTimeReward.getName());
                            }
                            for (Map.Entry entry : PlayTimeRewardsManager.this.oneTimeRewards.entrySet()) {
                                if (cMIUser.isClaimedReward((PTROneTime)entry.getValue())) continue;
                                if ((Long)entry.getKey() > l) continue block0;
                                playTimeReward = (PTROneTime)entry.getValue();
                                if (playTimeReward.isAutoClaim() && !cMIUser.isJailed() && !cMIUser.isCuffed()) {
                                    if (player == null || !player.isOnline() || RequiresPermission && !PermissionsManager.CMIPerm.prewards_$1.hasPermission((CommandSender)player, playTimeReward.getName().toLowerCase())) continue;
                                    Bukkit.getScheduler().runTask((Plugin)PlayTimeRewardsManager.this.plugin, new Runnable((PTROneTime)playTimeReward){
                                        private final /* synthetic */ PTROneTime val$reward;
                                        {
                                            this.val$reward = pTROneTime;
                                        }

                                        @Override
                                        public void run() {
                                            if (player.isOnline()) {
                                                this.val$reward.performCommands(player);
                                            }
                                        }
                                    });
                                    cMIUser.addOneTimeReward(playTimeReward.getName());
                                    cMIUser.addForPlayTimeRewardSave();
                                    continue;
                                }
                                PlayTimeRewardsManager.this.informPlayer(player, ((PTROneTime)entry.getValue()).getName());
                            }
                        }
                    }
                });
            }
        }, 0L, (long)this.interval * 20L);
    }

    public void informPlayer(Player player, String string) {
        Long l = this.informMap.get(player.getUniqueId());
        if ((l == null || l < System.currentTimeMillis()) && PermissionsManager.CMIPerm.prewards_notification.hasPermission((CommandSender)player)) {
            if (!RequiresPermission || PermissionsManager.CMIPerm.prewards_$1.hasPermission((CommandSender)player, string.toLowerCase())) {
                CMILC.info("prewards", player, "inform", new Object[0]);
            }
            l = l == null ? System.currentTimeMillis() + 60000L : l + this.RewardInform;
            this.informMap.put(player.getUniqueId(), l);
        }
    }

    public void load() {
        Long l = System.currentTimeMillis();
        HashMap<String, PTRRepeat> hashMap = new HashMap<String, PTRRepeat>(this.repeatableRewards);
        HashMap<String, PTROneTime> hashMap2 = new HashMap<String, PTROneTime>(this.oneTimeRewardsByName);
        this.repeatableRewards.clear();
        this.oneTimeRewards.clear();
        this.oneTimeRewardsByName.clear();
        CMI.getInstance().safeRenameFile(this.fileName, "Settings" + File.separator + this.fileName);
        File file = new File(this.plugin.getDataFolder(), "Settings" + File.separator + this.fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        YamlConfiguration yamlConfiguration = null;
        try {
            yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        if (yamlConfiguration.getKeys(false).isEmpty()) {
            return;
        }
        Set set = yamlConfiguration.getKeys(false);
        int n = 60;
        for (String string : set) {
            try {
                PlayTimeReward playTimeReward;
                String string2 = string.replace(" ", "_");
                String string3 = yamlConfiguration.getString(String.valueOf(string) + ".DisplayName");
                if (string3 == null) {
                    string3 = yamlConfiguration.getString(String.valueOf(string) + ".displayName", string);
                }
                boolean bl = false;
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".AutoClaim")) {
                    bl = yamlConfiguration.getBoolean(String.valueOf(string) + ".AutoClaim");
                }
                List list2 = yamlConfiguration.getStringList(String.valueOf(string) + ".Description");
                List list3 = yamlConfiguration.getStringList(String.valueOf(string) + ".Commands");
                Boolean bl2 = true;
                Long l2 = null;
                Boolean bl3 = true;
                if (yamlConfiguration.isInt(String.valueOf(string) + ".PayEvery")) {
                    bl2 = true;
                    l2 = yamlConfiguration.getInt(String.valueOf(string) + ".PayEvery");
                } else if (yamlConfiguration.isInt(String.valueOf(string) + ".PayFor")) {
                    bl2 = false;
                    l2 = yamlConfiguration.getInt(String.valueOf(string) + ".PayFor");
                } else if (yamlConfiguration.isLong(String.valueOf(string) + ".PayEvery")) {
                    bl2 = true;
                    l2 = yamlConfiguration.getLong(String.valueOf(string) + ".PayEvery");
                } else if (yamlConfiguration.isLong(String.valueOf(string) + ".PayFor")) {
                    bl2 = false;
                    l2 = yamlConfiguration.getLong(String.valueOf(string) + ".PayFor");
                }
                if (yamlConfiguration.isBoolean(String.valueOf(string) + ".StackRewards")) {
                    bl3 = yamlConfiguration.getBoolean(String.valueOf(string) + ".StackRewards");
                }
                if (bl2.booleanValue()) {
                    playTimeReward = new PTRRepeat(string2);
                    if (hashMap.containsKey(string2)) {
                        playTimeReward = hashMap.get(string2);
                    }
                    playTimeReward.setAutoClaim(bl);
                    playTimeReward.setCommands(list3);
                    playTimeReward.setDescription(list2);
                    playTimeReward.setDisplayName(string3);
                    ((PTRRepeat)playTimeReward).setPayEvery(l2);
                    ((PTRRepeat)playTimeReward).setStackRewards(bl3);
                    this.repeatableRewards.put(playTimeReward.getName().toLowerCase(), (PTRRepeat)playTimeReward);
                    if (l2 == null || (long)n <= l2) continue;
                    n = l2.intValue();
                    continue;
                }
                playTimeReward = new PTROneTime(string2);
                if (hashMap2.containsKey(string2)) {
                    playTimeReward = hashMap2.get(string2);
                }
                playTimeReward.setAutoClaim(bl);
                playTimeReward.setCommands(list3);
                playTimeReward.setDescription(list2);
                playTimeReward.setDisplayName(string3);
                ((PTROneTime)playTimeReward).setPayFor(l2);
                this.oneTimeRewards.put(((PTROneTime)playTimeReward).getPayFor(), (PTROneTime)playTimeReward);
                this.oneTimeRewardsByName.put(playTimeReward.getName().toLowerCase(), (PTROneTime)playTimeReward);
            }
            catch (Exception exception) {
                this.plugin.consoleMessage("&cCould not load play time reward (&4" + string + "&c) Double check spelling");
            }
        }
        if (n > 0) {
            this.interval = n;
            if (this.interval != 60) {
                this.stop();
                if (this.plugin.isEnabled() && this.Enabled) {
                    this.tasker();
                }
            }
        }
        this.plugin.loadMessage(this.repeatableRewards.size() + this.oneTimeRewards.size(), "playtime rewards", System.currentTimeMillis() - l);
    }

    public void clearCache(UUID uUID) {
        this.cache.remove(uUID);
    }

    public int getClaimableRewardCount(CMIUser cMIUser) {
        PlaytimeClaimCache playtimeClaimCache = this.cache.getOrDefault(cMIUser.getUniqueId(), new PlaytimeClaimCache());
        if (playtimeClaimCache.getLastUpdate() + 5000L > System.currentTimeMillis()) {
            return playtimeClaimCache.getCount();
        }
        long l = cMIUser.getTotalPlayTime(false);
        long l2 = 0L;
        if (this.isExcludeAfk() && cMIUser.isAfk()) {
            Long l3 = this.plugin.getAfkManager().getLastAction(cMIUser);
            if (l3 != null) {
                Long entry = this.getAfkAction(cMIUser);
                l2 = entry != null ? System.currentTimeMillis() - entry : System.currentTimeMillis() - l3;
                this.updateAfkAction(cMIUser);
            } else if (cMIUser.isAfk()) {
                this.plugin.getAfkManager().updateUser(cMIUser);
            }
        }
        int n = 0;
        for (Map.Entry<String, PTRRepeat> entry : this.getRepeatableRewards().entrySet()) {
            PTRRepeat pTRRepeat;
            Long l3;
            Long l4 = cMIUser.getRepeatableRewardTime(entry.getKey());
            if (RequiresPermission && cMIUser.isOnline() && !PermissionsManager.CMIPerm.prewards_$1.hasPermission((CommandSender)cMIUser.getPlayer(), entry.getKey().toLowerCase())) continue;
            if (l4 == null) {
                cMIUser.getRepeatableRewards().put(entry.getValue().getName().toLowerCase(), l);
                l4 = l;
            }
            if ((l3 = cMIUser.getRepeatableRewardTime((pTRRepeat = entry.getValue()).getName())) == null) {
                cMIUser.addRepeatableReward(pTRRepeat.getName(), l);
                continue;
            }
            if (this.isExcludeAfk() && cMIUser.isAfk()) {
                if ((l3 = Long.valueOf(l3 + l2)) > l) {
                    l3 = l;
                }
                cMIUser.addRepeatableReward(pTRRepeat.getName(), l3);
            }
            int n2 = (int)((double)(l - l3) / pTRRepeat.getPayEvery().doubleValue());
            if (entry.getValue().isAutoClaim() || n2 <= 0) continue;
            n += n2;
        }
        for (Map.Entry<Object, PlayTimeReward> entry : this.getOneTimeRewards().entrySet()) {
            if (cMIUser.isClaimedReward((PTROneTime)entry.getValue()) || RequiresPermission && cMIUser.isOnline() && !PermissionsManager.CMIPerm.prewards_$1.hasPermission((CommandSender)cMIUser.getPlayer(), ((PTROneTime)entry.getValue()).getName().toLowerCase()) || (Long)entry.getKey() - l > 0L || ((PTROneTime)entry.getValue()).isAutoClaim() && (!((PTROneTime)entry.getValue()).isAutoClaim() || cMIUser.isClaimedReward((PTROneTime)entry.getValue()))) continue;
            ++n;
        }
        playtimeClaimCache.setLastUpdate(System.currentTimeMillis());
        playtimeClaimCache.setCount(n);
        this.cache.put(cMIUser.getUniqueId(), playtimeClaimCache);
        return n;
    }

    public HashMap<String, PTRRepeat> getRepeatableRewards() {
        return this.repeatableRewards;
    }

    public void setRepeatableRewards(HashMap<String, PTRRepeat> hashMap) {
        this.repeatableRewards = hashMap;
    }

    public TreeMap<Long, PTROneTime> getOneTimeRewards() {
        return this.oneTimeRewards;
    }

    public void setOneTimeRewards(TreeMap<Long, PTROneTime> treeMap) {
        this.oneTimeRewards = treeMap;
    }

    public PTROneTime getOneTimeRewardByName(String string) {
        return this.oneTimeRewardsByName.get(string.toLowerCase());
    }

    public PTRRepeat getRepeatingRewardByName(String string) {
        return this.repeatableRewards.get(string.toLowerCase());
    }

    public int getOneTimeAmount() {
        return this.OneTimeAmount;
    }

    public void setOneTimeAmount(int n) {
        this.OneTimeAmount = n;
    }

    public boolean isExcludeAfk() {
        return this.ExcludeAfk;
    }

    public boolean isEnabled() {
        return this.Enabled;
    }
}

