/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ReplaceBlock;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.itemInfo;
import com.Zrips.CMI.Modules.Region.WorldInfo;
import com.Zrips.CMI.Modules.ReplaceBlock.BRInfo;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.Zrips.CMILib.ActionBar.CMIActionBar;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Time.CMITimeManager;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ReplaceBlock {
    public Pattern regionPattern = Pattern.compile("r\\.([0-9-]+)\\.([0-9-]+)\\.mca");
    public ConcurrentHashMap<String, BRInfo> BRInfo = new ConcurrentHashMap();
    private CMI plugin;

    public ReplaceBlock(CMI cMI) {
        this.plugin = cMI;
    }

    public void start(BRInfo bRInfo) {
        if (bRInfo.getStartTime() == 0L) {
            bRInfo.setShowInfo(System.currentTimeMillis());
        }
        this.loadChunk(bRInfo);
    }

    private void loadChunk(final BRInfo bRInfo) {
        Bukkit.getServer().getScheduler().cancelTask(bRInfo.getScheduleId());
        bRInfo.setscheduleId(Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!ReplaceBlock.this.BRInfo.containsKey(bRInfo.getPlayerName())) {
                    return;
                }
                if (!bRInfo.isRunning()) {
                    return;
                }
                int n = 0;
                while (n < bRInfo.getSpeed()) {
                    boolean bl = false;
                    WorldInfo worldInfo = bRInfo.getRI();
                    Chunk chunk = worldInfo.getNextChunk(true);
                    worldInfo.addLastChecked();
                    if (worldInfo.allChecked()) {
                        bRInfo.setRunning(false);
                        Bukkit.getServer().getScheduler().cancelTask(bRInfo.getScheduleId());
                        if (bRInfo.getPlayer().isOnline()) {
                            long l = System.currentTimeMillis() - bRInfo.getStartTime();
                            bRInfo.getPlayer().sendMessage(ReplaceBlock.this.plugin.getLM().getMessage("command.replaceblock.info.finished", "[amount]", bRInfo.getReplaced(), "[time]", CMITimeManager.to24hourShort((Long)l)));
                        }
                        return;
                    }
                    if (bRInfo.isMessages() && bRInfo.getShowInfo() + 2000L < System.currentTimeMillis()) {
                        bRInfo.setShowInfo(false);
                        long l = worldInfo.getLastChecked();
                        long l2 = worldInfo.getLeftToScan();
                        long l3 = System.currentTimeMillis() - bRInfo.getStartTime();
                        double d = l3 / l;
                        double d2 = (double)l2 * d;
                        CMIActionBar.send((Player)bRInfo.getPlayer(), (String)ReplaceBlock.this.plugin.getLM().getMessage("command.replaceblock.info.infoShow", "[tps]", String.format("%.2f", ReplaceBlock.this.plugin.getLagMeter().getTPS()), "[left]", l2, "[time]", CMITimeManager.to24hourShort((Long)((long)d2)), "[speed]", bRInfo.getSpeed(), "[found]", bRInfo.getReplaced()));
                        bRInfo.setShowInfo(System.currentTimeMillis());
                        if (bRInfo.isAutoSpeed()) {
                            if (ReplaceBlock.this.plugin.getLagMeter().getTPS() > ((ReplaceBlock)ReplaceBlock.this).plugin.getConfigManager().scanSoftCap) {
                                bRInfo.setSpeed(bRInfo.getSpeed() + 1);
                            } else if (bRInfo.getSpeed() - 2 > 0) {
                                bRInfo.setSpeed(bRInfo.getSpeed() - 2);
                            }
                        }
                    }
                    if (chunk != null) {
                        Random random = new Random(System.currentTimeMillis());
                        int n2 = chunk.getX() * 16;
                        int n3 = chunk.getZ() * 16;
                        int n4 = 0;
                        while (n4 < 16) {
                            int n5 = 0;
                            while (n5 < 16) {
                                int n6 = worldInfo.getWorld().getHighestBlockYAt(n2 + n4, n3 + n5);
                                if (n6 > bRInfo.getY()) {
                                    n6 = bRInfo.getY();
                                }
                                int n7 = CMIWorld.getMinHeight((World)worldInfo.getWorld());
                                while (n7 <= n6) {
                                    Block block = chunk.getBlock(n4, n7, n5);
                                    CMIMaterial cMIMaterial = CMIMaterial.get((Block)block);
                                    if (cMIMaterial != CMIMaterial.NONE) {
                                        for (itemInfo itemInfo2 : bRInfo.getItemInfo()) {
                                            if (cMIMaterial != itemInfo2.getMat() || itemInfo2.getChance() != 100 && random.nextInt(100) >= itemInfo2.getChance()) continue;
                                            itemInfo itemInfo3 = new itemInfo(CMIMaterial.NONE);
                                            for (itemInfo itemInfo4 : bRInfo.getReplaceInfo()) {
                                                if (itemInfo4.getChance() != 100 && random.nextInt(100) >= itemInfo4.getChance()) continue;
                                                itemInfo3 = itemInfo4;
                                                break;
                                            }
                                            if (itemInfo3.getMat() != CMIMaterial.NONE) {
                                                block.setType(itemInfo3.getMat().getMaterial());
                                            } else {
                                                block.setType(Material.AIR);
                                            }
                                            bRInfo.addReplaced();
                                        }
                                    }
                                    ++n7;
                                }
                                ++n5;
                            }
                            ++n4;
                        }
                        if (!bl) {
                            chunk.unload();
                        }
                    }
                    ++n;
                }
                ReplaceBlock.this.loadChunk(bRInfo);
            }
        }, 30L));
    }
}

