/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils.file.codec;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.configutils.file.codec.FileCodec;
import org.geysermc.configutils.util.FileUtils;

public final class PathFileCodec
implements FileCodec {
    private static final PathFileCodec DEFAULT_INSTANCE = new PathFileCodec(null);
    private final Path path;

    private PathFileCodec(@Nullable Path path) {
        this.path = path;
    }

    public static PathFileCodec instance() {
        return DEFAULT_INSTANCE;
    }

    public static PathFileCodec of(Path path) {
        return new PathFileCodec(path);
    }

    public static PathFileCodec of(String path) {
        if (path != null) {
            return PathFileCodec.of(Paths.get(path, new String[0]));
        }
        return PathFileCodec.instance();
    }

    @Override
    public List<String> read(String file) {
        return FileUtils.readPath(this.path(file));
    }

    @Override
    public void write(String file, List<String> lines) {
        FileUtils.writeToPath(this.path(file), lines);
    }

    private Path path(String configName) {
        if (this.path != null) {
            return this.path.resolve(configName);
        }
        return Paths.get(configName, new String[0]);
    }
}

