/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.cumulus.response.impl;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.cumulus.response.ModalFormResponse;
import org.geysermc.cumulus.response.impl.ResponseToResultGlue;
import org.geysermc.cumulus.response.result.ResultType;
import org.geysermc.floodgate.shadow.com.google.common.base.Preconditions;

public final class ModalFormResponseImpl
extends ResponseToResultGlue
implements ModalFormResponse {
    private final int clickedButtonId;
    private final String clickedButtonText;

    private ModalFormResponseImpl(int clickedButtonId, String clickedButtonText) {
        Preconditions.checkArgument(clickedButtonId >= 0, "clickedButtonId");
        this.clickedButtonId = clickedButtonId;
        this.clickedButtonText = Objects.requireNonNull(clickedButtonText, "clickedButtonText");
    }

    @Deprecated
    public ModalFormResponseImpl(ResultType resultType) {
        super(resultType);
        this.clickedButtonId = -1;
        this.clickedButtonText = null;
    }

    public static ModalFormResponseImpl of(int clickedButtonId, String clickedButtonText) {
        return new ModalFormResponseImpl(clickedButtonId, clickedButtonText);
    }

    @Override
    public int clickedButtonId() {
        return this.clickedButtonId;
    }

    @Override
    public @NonNull String clickedButtonText() {
        return this.clickedButtonText;
    }

    @Override
    public boolean clickedFirst() {
        return this.clickedButtonId == 0;
    }

    @Override
    public int getClickedButtonId() {
        return this.clickedButtonId();
    }

    @Override
    public String getClickedButtonText() {
        return this.clickedButtonText();
    }

    @Override
    public boolean getResult() {
        return this.clickedFirst();
    }
}

