/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.debug;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.geysermc.floodgate.addon.debug.StateChangeDetector;
import org.geysermc.floodgate.api.logger.FloodgateLogger;

@ChannelHandler.Sharable
public final class ChannelInDebugHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final String direction;
    private final FloodgateLogger logger;
    private final boolean toServer;
    private final StateChangeDetector changeDetector;

    public ChannelInDebugHandler(String implementationType, boolean toServer, StateChangeDetector changeDetector, FloodgateLogger logger) {
        this.direction = (toServer ? "Server -> " : "Player -> ") + implementationType;
        this.logger = logger;
        this.toServer = toServer;
        this.changeDetector = changeDetector;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
        try {
            int index = msg.readerIndex();
            if (this.changeDetector.shouldPrintPacket(msg, !this.toServer)) {
                this.logger.info("{} {}:\n{}", new Object[]{this.direction, this.changeDetector.getCurrentState(), ByteBufUtil.prettyHexDump((ByteBuf)msg)});
                this.changeDetector.checkPacket(msg, !this.toServer);
            }
            msg.readerIndex(index);
            ctx.fireChannelRead((Object)msg.retain());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

