/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.logger;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.shadow.com.google.inject.Singleton;
import org.geysermc.floodgate.shadow.com.google.inject.name.Named;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.MessageFormatter;

@Singleton
public final class JavaUtilFloodgateLogger
implements FloodgateLogger {
    @Inject
    @Named(value="logger")
    private Logger logger;
    private LanguageManager languageManager;

    @Inject
    private void init(LanguageManager languageManager, FloodgateConfig config) {
        this.languageManager = languageManager;
        if (config.isDebug()) {
            this.logger.setLevel(Level.ALL);
        }
    }

    @Override
    public void error(String message, Object ... args) {
        this.logger.severe(MessageFormatter.format(message, args));
    }

    @Override
    public void error(String message, Throwable throwable, Object ... args) {
        this.logger.log(Level.SEVERE, MessageFormatter.format(message, args), throwable);
    }

    @Override
    public void warn(String message, Object ... args) {
        this.logger.warning(MessageFormatter.format(message, args));
    }

    @Override
    public void info(String message, Object ... args) {
        this.logger.info(MessageFormatter.format(message, args));
    }

    @Override
    public void translatedInfo(String message, Object ... args) {
        this.logger.info(this.languageManager.getLogString(message, args));
    }

    @Override
    public void debug(String message, Object ... args) {
        this.logger.fine(MessageFormatter.format(message, args));
    }

    @Override
    public void trace(String message, Object ... args) {
        this.logger.finer(MessageFormatter.format(message, args));
    }

    @Override
    public boolean isDebug() {
        return this.logger.getLevel() == Level.ALL;
    }
}

