/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.cloud.commandframework.arguments.standard;

import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.floodgate.shadow.cloud.commandframework.ArgumentDescription;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.CommandArgument;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser.ArgumentParseResult;
import org.geysermc.floodgate.shadow.cloud.commandframework.arguments.parser.ArgumentParser;
import org.geysermc.floodgate.shadow.cloud.commandframework.context.CommandContext;
import org.geysermc.floodgate.shadow.cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import org.geysermc.floodgate.shadow.cloud.commandframework.exceptions.parsing.NumberParseException;

public final class DoubleArgument<C>
extends CommandArgument<C, Double> {
    private final double min;
    private final double max;

    private DoubleArgument(boolean required, @NonNull String name, double min2, double max, String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new DoubleParser(min2, max), defaultValue, Double.class, suggestionsProvider, defaultDescription);
        this.min = min2;
        this.max = max;
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Double> of(@NonNull String name) {
        return DoubleArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Double> optional(@NonNull String name) {
        return DoubleArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Double> optional(@NonNull String name, double defaultNum) {
        return DoubleArgument.newBuilder(name).asOptionalWithDefault(defaultNum).build();
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public static final class DoubleParser<C>
    implements ArgumentParser<C, Double> {
        public static final double DEFAULT_MINIMUM = Double.NEGATIVE_INFINITY;
        public static final double DEFAULT_MAXIMUM = Double.POSITIVE_INFINITY;
        private final double min;
        private final double max;

        public DoubleParser(double min2, double max) {
            this.min = min2;
            this.max = max;
        }

        @Override
        public @NonNull ArgumentParseResult<Double> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(DoubleParser.class, commandContext));
            }
            try {
                double value = Double.parseDouble(input);
                if (value < this.min || value > this.max) {
                    return ArgumentParseResult.failure(new DoubleParseException(input, this, commandContext));
                }
                inputQueue.remove();
                return ArgumentParseResult.success(value);
            }
            catch (Exception e) {
                return ArgumentParseResult.failure(new DoubleParseException(input, this, commandContext));
            }
        }

        @Override
        public boolean isContextFree() {
            return true;
        }

        public double getMax() {
            return this.max;
        }

        public double getMin() {
            return this.min;
        }

        public boolean hasMax() {
            return this.max != Double.POSITIVE_INFINITY;
        }

        public boolean hasMin() {
            return this.min != Double.NEGATIVE_INFINITY;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Double> {
        private double min = Double.NEGATIVE_INFINITY;
        private double max = Double.POSITIVE_INFINITY;

        private Builder(@NonNull String name) {
            super(Double.class, name);
        }

        public @NonNull Builder<C> withMin(int min2) {
            this.min = min2;
            return this;
        }

        public @NonNull Builder<C> withMax(int max) {
            this.max = max;
            return this;
        }

        public @NonNull Builder<C> asOptionalWithDefault(double defaultValue) {
            return (Builder)this.asOptionalWithDefault(Double.toString(defaultValue));
        }

        public @NonNull DoubleArgument<C> build() {
            return new DoubleArgument(this.isRequired(), this.getName(), this.min, this.max, this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    public static final class DoubleParseException
    extends NumberParseException {
        private static final long serialVersionUID = 1764554911581976586L;
        private final DoubleParser<?> parser;

        @Deprecated
        public DoubleParseException(@NonNull String input, double min2, double max, @NonNull CommandContext<?> commandContext) {
            this(input, new DoubleParser(min2, max), commandContext);
        }

        public DoubleParseException(@NonNull String input, @NonNull DoubleParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input, ((DoubleParser)parser).min, ((DoubleParser)parser).max, DoubleParser.class, commandContext);
            this.parser = parser;
        }

        @Override
        public boolean hasMin() {
            return this.parser.hasMin();
        }

        @Override
        public boolean hasMax() {
            return this.parser.hasMax();
        }

        @Override
        public @NonNull String getNumberType() {
            return "double";
        }
    }
}

