/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.commands;

import java.util.List;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.util.PermissionsCache;
import org.bukkit.ChatColor;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;

public class SellGUI
extends BukkitCommand {
    private final EconomyShopGUI plugin;
    private final List<String> disabledWorlds;

    public SellGUI(EconomyShopGUI plugin, List<String> aliases, List<String> disabledWorlds) {
        super(aliases.get(0));
        this.description = "Opens the sell GUI";
        this.usageMessage = "/" + aliases.remove(0);
        this.setAliases(aliases);
        this.setPermission("EconomyShopGUI.sellgui");
        this.plugin = plugin;
        this.disabledWorlds = disabledWorlds;
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (this.plugin.badYMLParse != null) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&4This command cannot be executed now, please fix the configuration formatting first!"));
            return true;
        }
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (this.hasAccesInWorld(p) && this.isAllowedGamemode(p)) {
                if (PermissionsCache.hasPermission(p, "EconomyShopGUI.sellgui")) {
                    new me.gypopo.economyshopgui.objects.SellGUI().open(p);
                } else {
                    SendMessage.chatToPlayer(p, Lang.NO_PERMISSIONS.get());
                }
            }
        } else if (sender instanceof ConsoleCommandSender || sender instanceof BlockCommandSender) {
            Player p = this.plugin.getServer().getPlayer(args[0]);
            if (p != null) {
                new me.gypopo.economyshopgui.objects.SellGUI().open(p);
            } else {
                sender.sendMessage(Lang.PLAYER_NOT_ONLINE.get());
            }
        }
        return false;
    }

    private boolean hasAccesInWorld(Player player) {
        if (!this.disabledWorlds.contains(player.getWorld().getName())) {
            return true;
        }
        SendMessage.chatToPlayer(player, Lang.COMMAND_DISABLED_IN_WORLD.get());
        return false;
    }

    private boolean isAllowedGamemode(Player player) {
        if (this.plugin.bannedGamemodes.contains(player.getGameMode()) && !PermissionsCache.hasPermission(player, "EconomyShopGUI.bypassgamemode")) {
            SendMessage.chatToPlayer(player, Lang.CANNOT_USE_COMMAND_BANNED_GAMEMODE.get().replace("%gamemode%", player.getGameMode().name().toLowerCase()));
            return false;
        }
        return true;
    }
}

