/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.commands;

import java.util.List;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.util.ConfigUtil;
import me.gypopo.economyshopgui.util.PermissionsCache;
import org.bukkit.ChatColor;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;

public class Sreload
extends BukkitCommand {
    private final EconomyShopGUI plugin;
    private final List<String> disabledWorlds;

    public Sreload(EconomyShopGUI plugin, List<String> disabledWorlds) {
        super("sreload");
        this.description = "Reloads the plugin";
        this.usageMessage = "/sreload";
        this.setPermission("EconomyShopGUI.reload");
        this.plugin = plugin;
        this.disabledWorlds = disabledWorlds;
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.hasAccesInWorld(player)) {
                if (PermissionsCache.hasPermission(player, "EconomyShopGUI.reload")) {
                    long start = System.currentTimeMillis();
                    this.plugin.startupReload.checkIfLanguageFilesExist();
                    Lang.CONFIGS_RELOADED.reload();
                    this.plugin.getConfigManager().reload();
                    this.plugin.getConfigManager().validate();
                    if (this.plugin.badYMLParse == null) {
                        if (!this.plugin.getEcoHandler().relead()) {
                            SendMessage.chatToPlayer(player, Lang.ERROR_OCCURRED_WHILE_RELOADING.get());
                            return true;
                        }
                        this.plugin.startupReload.setupPluginVersion();
                        ConfigUtil.updateConfigs();
                        this.plugin.getSpawnerManager().init();
                        this.plugin.startupReload.checkDebugMode();
                        this.plugin.startupReload.loadInventoryTitles();
                        this.plugin.startupReload.loadItems();
                        this.plugin.reloadModifiers();
                        this.plugin.reloadPlayerData();
                        this.plugin.startupReload.updateAvailable();
                        SendMessage.chatToPlayer(player, ChatColor.GREEN + Lang.DONE.get().replace("%millis%", String.valueOf(System.currentTimeMillis() - start)));
                    } else {
                        SendMessage.chatToPlayer(player, Lang.ERROR_OCCURRED_WHILE_RELOADING.get());
                        SendMessage.errorMessage("Skipping all settings and item loading because the configuration files could not be loaded...");
                    }
                } else {
                    SendMessage.chatToPlayer(player, Lang.NO_PERMISSIONS.get());
                }
            }
        } else if (sender instanceof ConsoleCommandSender || sender instanceof BlockCommandSender || sender instanceof RemoteConsoleCommandSender) {
            long start = System.currentTimeMillis();
            this.plugin.startupReload.checkIfLanguageFilesExist();
            Lang.CONFIGS_RELOADED.reload();
            this.plugin.getConfigManager().reload();
            this.plugin.getConfigManager().validate();
            if (this.plugin.badYMLParse == null) {
                if (!this.plugin.getEcoHandler().relead()) {
                    return true;
                }
                this.plugin.startupReload.setupPluginVersion();
                ConfigUtil.updateConfigs();
                this.plugin.getSpawnerManager().init();
                this.plugin.startupReload.checkDebugMode();
                this.plugin.startupReload.loadInventoryTitles();
                this.plugin.startupReload.loadItems();
                this.plugin.reloadModifiers();
                this.plugin.reloadPlayerData();
                this.plugin.startupReload.updateAvailable();
                SendMessage.infoMessage(Lang.DONE.get().replace("%millis%", String.valueOf(System.currentTimeMillis() - start)));
            } else {
                SendMessage.errorMessage("Skipping all settings and item loading because the configuration files could not be loaded...");
            }
        }
        return true;
    }

    private boolean hasAccesInWorld(Player player) {
        if (!this.disabledWorlds.contains(player.getWorld().getName())) {
            return true;
        }
        SendMessage.chatToPlayer(player, Lang.COMMAND_DISABLED_IN_WORLD.get());
        return false;
    }
}

