/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.commands.editshop.subcommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.commands.editshop.Methods;
import me.gypopo.economyshopgui.commands.editshop.SubCommad;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.CreateItemMethodes;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.util.FireworkUtil;
import me.gypopo.economyshopgui.util.PotionTypes;
import me.gypopo.economyshopgui.util.XEnchantment;
import me.gypopo.economyshopgui.util.XMaterial;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class EditItem
extends SubCommad {
    private final Methods methods;
    private final EconomyShopGUI plugin;
    private final List<String> allKeys = this.getAllKeys();
    private final List<String> availableActions = this.getAvailableActions();
    String section;
    String itemLoc;
    String action;
    String key;
    Object value;
    private final List<String> listKeys = this.getListKeys();

    public EditItem(EconomyShopGUI plugin, Methods methods) {
        this.plugin = plugin;
        this.methods = methods;
    }

    @Override
    public String getName() {
        return "edititem";
    }

    @Override
    public String getDescription() {
        return Lang.EDITSHOP_EDIT_ITEM_SUBCOMMAND_DESC.get();
    }

    @Override
    public String getSyntax() {
        return Lang.EDITSHOP_EDIT_ITEM_SUBCOMMAND_SYNTAX.get();
    }

    @Override
    public void perform(Object logger, String[] args) {
        if (args.length > 1) {
            this.section = this.methods.getSection(logger, args[1]);
            if (this.section == null) {
                return;
            }
        } else {
            SendMessage.sendMessage(logger, this.getSyntax());
            return;
        }
        if (args.length > 2) {
            this.itemLoc = this.methods.getItemLoc(logger, this.section, args[2]);
            if (this.itemLoc == null) {
                return;
            }
        } else {
            SendMessage.sendMessage(logger, this.getSyntax());
            return;
        }
        if (args.length > 3) {
            boolean found = false;
            for (String action2 : this.availableActions) {
                if (!args[3].equalsIgnoreCase(action2)) continue;
                this.action = action2;
                found = true;
                break;
            }
            if (!found) {
                SendMessage.sendMessage(logger, Lang.NO_VALID_ACTION.get().replace("%action%", args[3]).replace("%actions%", Arrays.toString(this.availableActions.toArray())));
                return;
            }
        } else {
            SendMessage.sendMessage(logger, this.getSyntax());
            return;
        }
        if (args.length > 4) {
            this.key = args[4];
            if (this.getAvailableKeys().stream().noneMatch(this.key::equalsIgnoreCase)) {
                SendMessage.sendMessage(logger, Lang.NO_VALID_KEY.get().replace("%key%", args[4]).replace("%keys%", Arrays.toString(this.getAvailableKeys().toArray())));
                return;
            }
            if (this.action.equalsIgnoreCase("remove")) {
                if (this.listKeys.stream().noneMatch(this.key::equalsIgnoreCase)) {
                    this.value = null;
                    if (!this.validate(logger)) {
                        return;
                    }
                    this.updateOption(logger);
                    return;
                }
            }
        } else {
            SendMessage.sendMessage(logger, this.getSyntax());
            return;
        }
        if (args.length > 5) {
            if (args.length > 6) {
                StringBuilder value2 = new StringBuilder();
                for (int i = 5; i < args.length; ++i) {
                    value2.append(args[i]).append(" ");
                }
                this.value = value2.substring(0, value2.length() - 1);
            } else {
                this.value = args[5];
            }
            if (!this.validate(logger)) {
                return;
            }
        } else {
            SendMessage.sendMessage(logger, this.getSyntax());
            return;
        }
        this.updateOption(logger);
    }

    @Override
    public List<String> getTabCompletion(String[] args) {
        switch (args.length) {
            case 2: {
                if (!args[1].isEmpty()) {
                    ArrayList<String> completions = new ArrayList<String>();
                    StringUtil.copyPartialMatches((String)args[1], this.plugin.getShopSections(), completions);
                    Collections.sort(completions);
                    return completions;
                }
                return this.plugin.getShopSections();
            }
            case 3: {
                if (!this.isSection(args[1])) {
                    return null;
                }
                if (!args[2].isEmpty()) {
                    ArrayList<String> completions = new ArrayList<String>();
                    StringUtil.copyPartialMatches((String)args[2], this.plugin.getSection((String)args[1]).itemLocs, completions);
                    Collections.sort(completions);
                    return completions;
                }
                return this.plugin.getSection((String)args[1]).itemLocs;
            }
            case 4: {
                if (!args[3].isEmpty()) {
                    ArrayList<String> completions = new ArrayList<String>();
                    StringUtil.copyPartialMatches((String)args[3], this.getAvailableActions(), completions);
                    Collections.sort(completions);
                    return completions;
                }
                return this.getAvailableActions();
            }
            case 5: {
                if (!(this.isSection(args[1]) && this.isItemLoc(args[2]) && this.isAction(args[3]))) {
                    return null;
                }
                if (!args[4].isEmpty()) {
                    ArrayList<String> completions = new ArrayList<String>();
                    StringUtil.copyPartialMatches((String)args[4], this.getAvailableKeys(), completions);
                    Collections.sort(completions);
                    return completions;
                }
                return this.getAvailableKeys();
            }
            case 6: {
                if (!this.isKey(args[4])) {
                    return null;
                }
                if (!args[5].isEmpty()) {
                    ArrayList<String> completions = new ArrayList<String>();
                    StringUtil.copyPartialMatches((String)args[5], this.getTabcompletionForValue(args[1], args[2], args[3], args[4]), completions);
                    Collections.sort(completions);
                    return completions;
                }
                return this.getTabcompletionForValue(args[1], args[2], args[3], args[4]);
            }
        }
        return null;
    }

    private boolean isSection(String section2) {
        if (this.plugin.getShopSections().contains(section2)) {
            this.section = section2;
            return true;
        }
        return false;
    }

    private boolean isItemLoc(String itemLoc2) {
        if (this.plugin.getSection((String)this.section).itemLocs.contains(itemLoc2)) {
            this.itemLoc = itemLoc2;
            return true;
        }
        return false;
    }

    private boolean isAction(String action2) {
        if (this.availableActions.contains(action2)) {
            this.action = action2;
            return true;
        }
        return false;
    }

    private boolean isKey(String key2) {
        if (this.getAvailableKeys().contains(key2)) {
            this.key = key2;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validate(Object logger) {
        if (this.action.equalsIgnoreCase("add")) {
            if (!this.getAvailableKeys().contains(this.key)) {
                SendMessage.sendMessage(logger, Lang.KEY_ALREADY_DEFINED.get().replace("%key%", this.key));
                return false;
            }
        } else if (this.action.equalsIgnoreCase("remove") && !this.getAvailableKeys().contains(this.key)) {
            SendMessage.sendMessage(logger, Lang.KEY_IS_NOT_FOUND.get().replace("%key%", this.key));
            return false;
        }
        if ((this.action.equalsIgnoreCase("remove") || this.action.equalsIgnoreCase("add")) && !this.listKeys.contains(this.key) && this.key.equalsIgnoreCase("material")) {
            SendMessage.sendMessage(logger, Lang.ACTION_NOT_VALID_ON_KEY.get().replace("%action%", this.action).replace("%key%", this.key));
            return false;
        }
        if (this.value == null) return true;
        String materialName = ConfigManager.getShop(this.section).getString("pages." + this.itemLoc + ".material");
        if (materialName != null || !materialName.isEmpty()) {
            Optional<XMaterial> xMaterial = XMaterial.matchXMaterial(materialName);
            if (xMaterial.isPresent() && xMaterial.get().parseItem() != null) {
                Material mat = xMaterial.get().parseItem().getType();
                switch (this.key) {
                    case "material": {
                        if (this.action.equalsIgnoreCase("remove") || this.action.equalsIgnoreCase("add")) {
                            SendMessage.sendMessage(logger, Lang.ACTION_NOT_VALID_ON_KEY.get().replace("%action%", this.action).replace("%key%", this.key));
                            return false;
                        }
                        if (this.methods.getMaterial(logger, this.value.toString()) == null) return false;
                        return true;
                    }
                    case "displayname": 
                    case "name": 
                    case "lore": 
                    case "displaylore": {
                        return true;
                    }
                    case "buy": 
                    case "sell": {
                        this.value = this.methods.getPrice(logger, this.value);
                        if (this.value == null) return false;
                        return true;
                    }
                    case "slot": {
                        try {
                            int slot = Integer.parseInt(this.value.toString());
                            if (this.plugin.maxShopSize * 45 < slot) throw new NumberFormatException();
                            if (1 > slot) {
                                throw new NumberFormatException();
                            }
                            this.value = slot;
                            return true;
                        }
                        catch (NumberFormatException e) {
                            SendMessage.sendMessage(logger, Lang.NO_VALID_SLOT_FOR_ITEM.get().replace("%slot%", this.value.toString()).replace("%maxShopSize%", String.valueOf(this.plugin.maxShopSize * 45)));
                            return false;
                        }
                    }
                    case "enchantments": {
                        String enchantmentName = this.value.toString().contains(":") ? this.value.toString().split(":")[0] : this.value.toString();
                        Optional<XEnchantment> ench = XEnchantment.matchXEnchantment(enchantmentName);
                        if (!ench.isPresent()) {
                            SendMessage.sendMessage(logger, ChatColor.RED + Lang.ITEM_ENCHANTMENT_NULL.get());
                            return false;
                        }
                        if (ench.get().parseEnchantment() == null) {
                            SendMessage.sendMessage(logger, ChatColor.RED + Lang.ITEM_ENCHANTMENT_NOT_SUPPORTED.get());
                            return false;
                        }
                        try {
                            if (!this.value.toString().contains(":")) return true;
                            Integer.parseInt(this.value.toString().split(":")[1]);
                            return true;
                        }
                        catch (NumberFormatException e) {
                            SendMessage.sendMessage(logger, ChatColor.RED + Lang.ITEM_ENCHANTMENT_STRENGTH_NULL.get());
                            return false;
                        }
                    }
                    case "enchantment-glint": 
                    case "hidePricingLore": 
                    case "hidden": 
                    case "prior-lore": 
                    case "close-menu": {
                        this.value = Boolean.valueOf(this.value.toString());
                        return true;
                    }
                    case "flicker": 
                    case "trail": {
                        if (ConfigManager.getShop(this.section).getStringList("pages." + this.itemLoc + ".colors").isEmpty()) {
                            SendMessage.sendMessage(logger, ChatColor.RED + "To apply a flicker, trail or firework shape you need to give the firework at least one color using the 'colors' option");
                            return false;
                        }
                        this.value = Boolean.valueOf(this.value.toString());
                        return true;
                    }
                    case "potiontypes": {
                        if (!PotionTypes.canHaveEffects(mat)) {
                            SendMessage.sendMessage(logger, ChatColor.RED + Lang.MATERIAL_NEEDS_TO_BE_POTION.get());
                            return false;
                        }
                        Optional<PotionTypes> pot = PotionTypes.matchPotionType(this.value.toString());
                        if (!pot.isPresent()) {
                            SendMessage.sendMessage(logger, ChatColor.RED + Lang.ITEM_POTIONTYPE_NULL.get());
                            return false;
                        }
                        if (pot.get().isSupported()) return true;
                        SendMessage.sendMessage(logger, ChatColor.RED + Lang.POTIONTYPE_NOT_SUPPORTED.get());
                        return false;
                    }
                    case "spawnertype": {
                        if (mat != XMaterial.SPAWNER.parseMaterial()) {
                            SendMessage.sendMessage(logger, ChatColor.RED + Lang.MATERIAL_NEEDS_TO_BE_SPAWNER.get());
                            return false;
                        }
                        for (EntityType entity : EntityType.values()) {
                            if (!this.value.toString().equalsIgnoreCase(entity.toString())) continue;
                            return true;
                        }
                        SendMessage.sendMessage(logger, ChatColor.RED + Lang.ITEM_SPAWNERTYPE_NULL.get());
                        return false;
                    }
                    case "armorcolor": {
                        try {
                            Color.fromRGB((int)Integer.parseInt(this.value.toString()));
                            return true;
                        }
                        catch (IllegalArgumentException e) {
                            SendMessage.sendMessage(logger, ChatColor.RED + Lang.RGB_COLOR_FORMATTED_WRONG.get().replace("%path%", this.section + "." + this.itemLoc + "." + this.key));
                        }
                        return true;
                    }
                    case "recipes": {
                        if (mat != XMaterial.KNOWLEDGE_BOOK.parseMaterial()) {
                            SendMessage.sendMessage(logger, ChatColor.RED + Lang.MATERIAL_NEEDS_TO_BE_BOOK.get());
                            return false;
                        }
                        if (XMaterial.matchXMaterial(this.value.toString()).isPresent()) {
                            if (XMaterial.matchXMaterial(this.value.toString()).get().parseMaterial() != null) return true;
                        }
                        SendMessage.sendMessage(logger, ChatColor.RED + Lang.CANNOT_GET_RECIPE_MATERIAL.get());
                        return false;
                    }
                    case "skullowner": {
                        if (mat == XMaterial.PLAYER_HEAD.parseMaterial()) return true;
                        SendMessage.sendMessage(logger, ChatColor.RED + Lang.MATERIAL_NEEDS_TO_BE_SKULL.get());
                        return false;
                    }
                    case "colors": 
                    case "fade-colors": {
                        if (Arrays.stream(FireworkUtil.FireworkColor.values()).map(color -> color.name()).collect(Collectors.toList()).contains(this.value.toString().toUpperCase(Locale.ENGLISH))) return true;
                        SendMessage.sendMessage(logger, ChatColor.RED + "Could not get the color '" + this.value.toString() + "'");
                        return false;
                    }
                    case "shape": {
                        if (ConfigManager.getShop(this.section).getStringList("pages." + this.itemLoc + ".colors").isEmpty()) {
                            SendMessage.sendMessage(logger, ChatColor.RED + "To apply a flicker, trail or firework shape you need to give the firework at least one color using the 'colors' option");
                            return false;
                        }
                        try {
                            FireworkEffect.Type.valueOf((String)this.value.toString().toUpperCase(Locale.ENGLISH));
                            return true;
                        }
                        catch (IllegalArgumentException ignored) {
                            SendMessage.sendMessage(logger, ChatColor.RED + "Could not get the firework shape '" + this.value.toString() + "'");
                            return false;
                        }
                    }
                    case "duration": {
                        try {
                            Integer.parseInt(this.value.toString());
                            return true;
                        }
                        catch (NumberFormatException e) {
                            SendMessage.sendMessage(logger, ChatColor.RED + Lang.NO_VALID_AMOUNT.get());
                            return false;
                        }
                    }
                    case "stack-size": 
                    case "max-buy": 
                    case "max-sell": {
                        try {
                            this.value = Integer.parseInt(this.value.toString());
                        }
                        catch (NumberFormatException e) {
                            SendMessage.sendMessage(logger, ChatColor.RED + Lang.NO_VALID_AMOUNT.get());
                            return false;
                        }
                        if (!this.key.equalsIgnoreCase("stack-size")) return true;
                        if (this.plugin.allowIllegalStacks) return true;
                        if ((Integer)this.value >= mat.getMaxStackSize()) return true;
                        SendMessage.sendMessage(logger, ChatColor.RED + "Cannot set the stack size of item %material% to %stack-size% because it would exceed the vanilla max stack size.".replace("%material%", mat.toString()).replace("%stack-size%", this.value.toString()));
                        return true;
                    }
                    case "instrument": {
                        if (mat != XMaterial.GOAT_HORN.parseMaterial()) {
                            SendMessage.sendMessage(logger, ChatColor.RED + "To apply a horn sound type, the material needs to be a goat horn");
                            return false;
                        }
                        try {
                            CreateItemMethodes.Horn.getFromString(this.value.toString());
                            return true;
                        }
                        catch (IllegalArgumentException e) {
                            SendMessage.warnMessage(ChatColor.RED + "Could not find a goat horn instrument like '" + this.value.toString() + "', valid values are:\n" + ChatColor.RED + Arrays.stream(CreateItemMethodes.Horn.values()).map(Enum::name).collect(Collectors.toList()));
                            return false;
                        }
                    }
                    case "section": {
                        return this.plugin.getShopSections().contains(this.value.toString());
                    }
                    case "stew-effect": {
                        if (mat != XMaterial.MUSHROOM_STEW.parseMaterial()) {
                            SendMessage.sendMessage(logger, ChatColor.RED + "To add a stew effect to an item, the material needs to be a 'SUSPICIOUS_STEW'.");
                            return false;
                        }
                        CreateItemMethodes.Stew stew = CreateItemMethodes.Stew.get(this.value.toString());
                        if (stew != null) return true;
                        SendMessage.warnMessage(ChatColor.RED + "Could not find a stew effect like '" + this.value.toString() + "', valid values are:\n" + ChatColor.RED + Arrays.stream(CreateItemMethodes.Stew.values()).map(Enum::name).collect(Collectors.toList()));
                        return false;
                    }
                }
                return true;
            }
            SendMessage.sendMessage(logger, Lang.EDIT_ITEM_MATERIAL_INVALID.get().replace("%material%", materialName));
            return false;
        }
        SendMessage.sendMessage(logger, Lang.EDIT_ITEM_MATERIAL_INVALID.get().replace("%material%", materialName));
        return false;
    }

    private List<String> getTabcompletionForValue(String section, String itemLoc, String action, String key) {
        if (!(this.isSection(section) && this.isItemLoc(itemLoc) && this.isAction(action))) {
            return new ArrayList<String>();
        }
        if (action.equalsIgnoreCase("remove") && this.listKeys.contains(key)) {
            return ConfigManager.getShop(this.section).getConfigurationSection("pages." + itemLoc).getStringList(key);
        }
        if (action.equalsIgnoreCase("remove")) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(ConfigManager.getShop(this.section).get("pages." + itemLoc + "." + key, "").toString());
            return values;
        }
        switch (key) {
            case "material": 
            case "recipes": {
                return this.plugin.getSupportedMatNames();
            }
            case "displayname": 
            case "name": 
            case "lore": 
            case "displaylore": {
                return this.methods.getExampleItemNames();
            }
            case "buy": 
            case "sell": {
                return this.plugin.getExamplePrices();
            }
            case "enchantments": {
                return XEnchantment.getNames();
            }
            case "potiontypes": {
                return PotionTypes.getNames();
            }
            case "armorcolor": {
                return this.methods.getExampleRGBColors();
            }
            case "spawnertype": {
                return this.getEntityNames();
            }
            case "skullowner": {
                return this.getExamplePlayerNames();
            }
            case "hidePricingLore": 
            case "enchantment-glint": 
            case "flicker": 
            case "trail": 
            case "hidden": {
                return Arrays.asList("true", "false");
            }
            case "slot": {
                return Arrays.asList("1", "9", "73", "108");
            }
            case "max-buy": 
            case "max-sell": {
                return Arrays.asList("1", "2", "8", "16", "32", "64", "128");
            }
            case "colors": 
            case "fade-colors": {
                return Arrays.stream(FireworkUtil.FireworkColor.values()).map(color -> color.name()).collect(Collectors.toList());
            }
            case "shape": {
                return Arrays.stream(FireworkEffect.Type.values()).map(type -> type.name()).collect(Collectors.toList());
            }
            case "duration": {
                return Arrays.asList("1", "2", "3");
            }
            case "stack-size": {
                ArrayList<String> array = new ArrayList<String>();
                for (int i = 1; i < 64; ++i) {
                    array.add(String.valueOf(i));
                }
                return array;
            }
            case "instrument": {
                return Arrays.stream(CreateItemMethodes.Horn.values()).map(Enum::name).collect(Collectors.toList());
            }
            case "section": {
                return this.plugin.getShopSections();
            }
            case "stew-effect": {
                return Arrays.stream(CreateItemMethodes.Stew.values()).map(Enum::name).collect(Collectors.toList());
            }
        }
        return new ArrayList<String>();
    }

    private List<String> getAvailableKeys() {
        try {
            ArrayList<String> availableKeys = new ArrayList<String>();
            availableKeys.addAll(this.allKeys);
            ArrayList<String> definedKeys = new ArrayList<String>(ConfigManager.getShop(this.section).getConfigurationSection("pages." + this.itemLoc).getKeys(false));
            if (this.action.equalsIgnoreCase("add")) {
                availableKeys.removeAll(definedKeys);
                availableKeys.addAll(this.listKeys);
                return availableKeys;
            }
            if (this.action.equalsIgnoreCase("remove")) {
                return definedKeys;
            }
            if (this.action.equalsIgnoreCase("set")) {
                ArrayList<String> l = new ArrayList<String>(this.allKeys);
                l.addAll(this.listKeys);
                return l;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new ArrayList<String>();
    }

    private List<String> getAllKeys() {
        ArrayList<String> allKeys = new ArrayList<String>();
        allKeys.add("material");
        allKeys.add("buy");
        allKeys.add("sell");
        allKeys.add("name");
        allKeys.add("displayname");
        allKeys.add("hidePricingLore");
        allKeys.add("slot");
        allKeys.add("stack-size");
        allKeys.add("enchantment-glint");
        allKeys.add("spawnertype");
        allKeys.add("skullowner");
        allKeys.add("armorcolor");
        allKeys.add("duration");
        allKeys.add("flicker");
        allKeys.add("trail");
        allKeys.add("shape");
        allKeys.add("instrument");
        allKeys.add("section");
        allKeys.add("stew-effect");
        allKeys.add("hidden");
        allKeys.add("max-buy");
        allKeys.add("max-sell");
        allKeys.add("prior-lore");
        allKeys.add("close-menu");
        return allKeys;
    }

    private List<String> getListKeys() {
        ArrayList<String> listKeys = new ArrayList<String>();
        listKeys.add("enchantments");
        listKeys.add("potiontypes");
        listKeys.add("lore");
        listKeys.add("displaylore");
        listKeys.add("recipes");
        listKeys.add("colors");
        listKeys.add("fade-colors");
        return listKeys;
    }

    private List<String> getAvailableActions() {
        ArrayList<String> actions = new ArrayList<String>();
        actions.add("add");
        actions.add("set");
        actions.add("remove");
        return actions;
    }

    private List<String> getExamplePlayerNames() {
        ArrayList<String> playerNames = new ArrayList<String>();
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            playerNames.add(player.getName());
        }
        return playerNames;
    }

    private List<String> getEntityNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (EntityType entity : EntityType.values()) {
            if (!entity.isAlive()) continue;
            try {
                EntityType.valueOf((String)entity.name());
                names.add(entity.name());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return names;
    }

    private List<String> getValues(String section, String itemLoc, String key) {
        return ConfigManager.getShop(section).getStringList("pages." + itemLoc + "." + key);
    }

    private void updateOption(Object logger) {
        SendMessage.sendMessage(logger, Lang.EDITSHOP_EDITING_ITEM.get());
        String locateItem = "pages." + this.itemLoc;
        if (this.listKeys.contains(this.key)) {
            if (this.action.equalsIgnoreCase("add")) {
                List<String> values = this.getValues(this.section, this.itemLoc, this.key);
                values.add(this.value.toString());
                ConfigManager.getShop(this.section).set(locateItem + "." + this.key, values);
            } else if (this.action.equalsIgnoreCase("set")) {
                ConfigManager.getShop(this.section).set(locateItem + "." + this.key, Collections.singletonList(this.value.toString()));
            } else if (this.action.equalsIgnoreCase("remove")) {
                List<String> values = this.getValues(this.section, this.itemLoc, this.key);
                if (values.size() == 1) {
                    ConfigManager.getShop(this.section).set(locateItem + "." + this.key, null);
                } else if (values.size() >= 1) {
                    values.remove(this.value.toString());
                    ConfigManager.getShop(this.section).set(locateItem + "." + this.key, values);
                }
            }
        } else {
            ConfigManager.getShop(this.section).set(locateItem + "." + this.key, this.value);
        }
        ConfigManager.saveShop(this.section);
        SendMessage.sendMessage(logger, Lang.EDITSHOP_EDIT_ITEM_SUCCESSFUL.get().replace("%itemPath%", locateItem));
        SendMessage.sendMessage(logger, Lang.EDITSHOP_RELOAD_SHOP_TO_SEE_CHANGES.get());
    }
}

