/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.commands.editshop.subcommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.commands.editshop.Methods;
import me.gypopo.economyshopgui.commands.editshop.SubCommad;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.EconomyType;
import me.gypopo.economyshopgui.util.XMaterial;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.util.StringUtil;

public class EditSection
extends SubCommad {
    private final Methods methods;
    private final EconomyShopGUI plugin;
    private final List<String> allKeys = Arrays.asList("enable", "item.material", "item.name", "slot", "item.enchantment-glint", "item.skullowner", "item.armorcolor", "hidden", "title", "sub-section", "item.potion-glow", "economy", "display-item");
    private final List<String> listKeys = Arrays.asList("item.lore");
    private final List<String> actions = Arrays.asList("add", "set", "remove");
    private String section;
    private String action;
    private String key;
    private Object value;

    public EditSection(EconomyShopGUI plugin, Methods methods) {
        this.plugin = plugin;
        this.methods = methods;
    }

    @Override
    public String getName() {
        return "editsection";
    }

    @Override
    public String getDescription() {
        return Lang.EDITSHOP_EDIT_SECTION_SUBCOMMAND_DESC.get();
    }

    @Override
    public String getSyntax() {
        return Lang.EDITSHOP_EDIT_SECTION_SUBCOMMAND_SYNTAX.get();
    }

    @Override
    public void perform(Object logger, String[] args) {
        if (args.length > 1) {
            this.section = this.methods.getSection(logger, args[1]);
            if (this.section == null) {
                return;
            }
        } else {
            SendMessage.sendMessage(logger, this.getSyntax());
            return;
        }
        if (args.length > 2) {
            this.action = args[2].toLowerCase(Locale.ENGLISH);
            if (!this.actions.contains(this.action)) {
                SendMessage.sendMessage(logger, Lang.NO_VALID_ACTION.get().replace("%action%", args[2]).replace("%actions%", Arrays.toString(this.actions.toArray())));
                return;
            }
        } else {
            SendMessage.sendMessage(logger, this.getSyntax());
            return;
        }
        if (args.length > 3) {
            this.key = args[3];
            if (this.getAvailableKeys().stream().noneMatch(this.key::equalsIgnoreCase)) {
                SendMessage.sendMessage(logger, Lang.NO_VALID_KEY.get().replace("%key%", args[3]).replace("%keys%", Arrays.toString(this.getAvailableKeys().toArray())));
                return;
            }
            if (this.action.equalsIgnoreCase("remove")) {
                if (this.listKeys.stream().noneMatch(this.key::equalsIgnoreCase)) {
                    this.value = null;
                    if (!this.validate(logger)) {
                        return;
                    }
                    this.updateOption(logger);
                    return;
                }
            }
        } else {
            SendMessage.sendMessage(logger, this.getSyntax());
            return;
        }
        if (args.length > 4) {
            StringBuilder value2 = new StringBuilder();
            for (int i = 4; i < args.length; ++i) {
                value2.append(args[i]).append(" ");
            }
            this.value = value2.substring(0, value2.length() - 1);
            if (!this.validate(logger)) {
                return;
            }
        } else {
            SendMessage.sendMessage(logger, this.getSyntax());
            return;
        }
        this.updateOption(logger);
    }

    @Override
    public List<String> getTabCompletion(String[] args) {
        switch (args.length) {
            case 2: {
                if (!args[1].isEmpty()) {
                    ArrayList<String> completions = new ArrayList<String>();
                    StringUtil.copyPartialMatches((String)args[1], this.plugin.getShopSections(), completions);
                    Collections.sort(completions);
                    return completions;
                }
                return this.plugin.getShopSections();
            }
            case 3: {
                if (!args[2].isEmpty()) {
                    ArrayList<String> completions = new ArrayList<String>();
                    StringUtil.copyPartialMatches((String)args[2], this.actions, completions);
                    Collections.sort(completions);
                    return completions;
                }
                return this.actions;
            }
            case 4: {
                if (!this.isSection(args[1]) || !this.isAction(args[2])) {
                    return null;
                }
                if (!args[3].isEmpty()) {
                    ArrayList<String> completions = new ArrayList<String>();
                    StringUtil.copyPartialMatches((String)args[3], this.getAvailableKeys(), completions);
                    Collections.sort(completions);
                    return completions;
                }
                return this.getAvailableKeys();
            }
            case 5: {
                if (!args[4].isEmpty()) {
                    ArrayList<String> completions = new ArrayList<String>();
                    StringUtil.copyPartialMatches((String)args[4], this.getTabcompletionForValue(args[1], args[2], args[3]), completions);
                    Collections.sort(completions);
                    return completions;
                }
                return this.getTabcompletionForValue(args[1], args[2], args[3]);
            }
        }
        return null;
    }

    private boolean isSection(String section) {
        if (this.plugin.getShopSections().contains(section)) {
            this.section = section;
            return true;
        }
        return false;
    }

    private boolean isAction(String action) {
        if (this.actions.contains(action)) {
            this.action = action;
            return true;
        }
        return false;
    }

    private boolean isKey(String key) {
        if (this.getAvailableKeys().contains(key)) {
            this.key = key;
            return true;
        }
        return false;
    }

    private List<String> getExamplePlayerNames() {
        ArrayList<String> playerNames = new ArrayList<String>();
        this.plugin.getServer().getOnlinePlayers().forEach(p -> playerNames.add(p.getName()));
        return playerNames;
    }

    private List<String> getTabcompletionForValue(String section, String action, String key) {
        if (!(this.isSection(section) && this.isAction(action) && this.isKey(key))) {
            return new ArrayList<String>();
        }
        if (action.equals("remove") && this.listKeys.contains(key)) {
            if (this.listKeys.contains(key)) {
                return this.getValues(section, key);
            }
            return Collections.singletonList(ConfigManager.getSection(section).get(key, "").toString());
        }
        switch (key) {
            case "item.material": {
                return this.plugin.getSupportedMatNames();
            }
            case "item.name": 
            case "item.lore": 
            case "title": {
                return Arrays.asList("#A1672D&lWood", "&1&lArmor", "#1B22E8&lF#1BAAE8&li#1BE8E1&lr#1BE896&le#1BE829&lw#E8DA1B&lo#E88F1B&lr#EB0909&lk#EB09DC&ls", "&7&lStones", "#09EBDC&lCustom#89EB09&lItems");
            }
            case "item.armorcolor": {
                return this.methods.getExampleRGBColors();
            }
            case "item.skullowner": {
                return this.getExamplePlayerNames();
            }
            case "item.enchantment-glint": 
            case "item.potion-glow": 
            case "sub-section": 
            case "display-item": {
                return Arrays.asList("true", "false");
            }
            case "economy": {
                return Arrays.asList("ULTRA_ECONOMY:Gems", "ULTRA_ECONOMY:Crystals", "VAULT", "GEMS_ECONOMY:Sticks", "PLAYER_POINTS");
            }
            case "slot": {
                return this.methods.getAvailableMainMenuSlots();
            }
        }
        return new ArrayList<String>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validate(Object logger) {
        if (this.action.equalsIgnoreCase("remove") && !this.listKeys.contains(this.key) && (this.key.equalsIgnoreCase("item.material") || this.key.equalsIgnoreCase("enable"))) {
            SendMessage.sendMessage(logger, Lang.ACTION_NOT_VALID_ON_KEY.get().replace("%action%", this.action).replace("%key%", this.key));
            return false;
        }
        if (this.value == null) return true;
        String materialName = ConfigManager.getSection(this.section).getString("item.material");
        if (materialName != null || !materialName.isEmpty()) {
            Optional<XMaterial> xMaterial = XMaterial.matchXMaterial(materialName);
            if (xMaterial.isPresent() && xMaterial.get().parseItem() != null) {
                Material mat = xMaterial.get().parseItem().getType();
                switch (this.key) {
                    case "item.material": {
                        if (this.methods.getMaterial(logger, this.value.toString()) == null) return false;
                        return true;
                    }
                    case "item.name": 
                    case "item.lore": 
                    case "title": {
                        return true;
                    }
                    case "slot": {
                        this.value = this.methods.getMainMenuSlot(logger, this.value.toString());
                        if (this.value == null) return false;
                        return true;
                    }
                    case "item.enchantment-glint": 
                    case "item.potion-glow": 
                    case "item.sub-section": 
                    case "display-item": 
                    case "hidden": 
                    case "economy": {
                        EcoType type = EconomyType.getFromString(this.value.toString());
                        if (type != null) return true;
                        SendMessage.warnMessage(ChatColor.RED + "Could not find a economy type such as '" + this.value.toString() + "', valid values are: " + Arrays.stream(EconomyType.values()).filter(t -> t != EconomyType.ITEM && t != EconomyType.LEVELS).map(Enum::name).collect(Collectors.joining(",")), logger);
                        return false;
                    }
                    case "enable": {
                        this.value = Boolean.valueOf(this.value.toString());
                        return true;
                    }
                    case "item.armorcolor": {
                        try {
                            Color.fromRGB((int)Integer.parseInt(this.value.toString()));
                            return true;
                        }
                        catch (IllegalArgumentException e) {
                            SendMessage.sendMessage(logger, ChatColor.RED + Lang.RGB_COLOR_FORMATTED_WRONG.get().replace("%path%", "ShopSections." + this.section + "." + this.key));
                            return false;
                        }
                    }
                    case "item.skullowner": {
                        if (mat == XMaterial.PLAYER_HEAD.parseMaterial()) return true;
                        SendMessage.sendMessage(logger, ChatColor.RED + Lang.MATERIAL_NEEDS_TO_BE_SKULL.get());
                        return false;
                    }
                }
                return true;
            }
            SendMessage.sendMessage(logger, Lang.EDIT_ITEM_MATERIAL_INVALID.get().replace("%material%", materialName));
            return false;
        }
        SendMessage.sendMessage(logger, Lang.EDIT_ITEM_MATERIAL_INVALID.get().replace("%material%", materialName));
        return false;
    }

    private List<String> getAvailableKeys() {
        try {
            ArrayList<String> availableKeys = new ArrayList<String>(this.allKeys);
            ArrayList<String> definedKeys = new ArrayList<String>(ConfigManager.getSection(this.section).getKeys(false));
            if (this.action.equalsIgnoreCase("add")) {
                availableKeys.removeAll(definedKeys);
                availableKeys.addAll(this.listKeys);
                return availableKeys;
            }
            if (this.action.equalsIgnoreCase("remove")) {
                return definedKeys;
            }
            if (this.action.equalsIgnoreCase("set")) {
                ArrayList<String> l = new ArrayList<String>(this.allKeys);
                l.addAll(this.listKeys);
                return l;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new ArrayList<String>();
    }

    private List<String> getValues(String section, String key) {
        return ConfigManager.getSection(section).getStringList(key);
    }

    private void updateOption(Object logger) {
        SendMessage.sendMessage(logger, Lang.EDITSHOP_EDITING_SECTION.get());
        if (this.listKeys.contains(this.key)) {
            if (this.action.equals("add")) {
                List<String> values = this.getValues(this.section, this.key);
                values.add(this.value.toString());
                ConfigManager.getSection(this.section).set(this.key, values);
            } else if (this.action.equalsIgnoreCase("set")) {
                ConfigManager.getSection(this.section).set(this.key, Collections.singletonList(this.value.toString()));
            } else if (this.action.equalsIgnoreCase("remove")) {
                List<String> values = this.getValues(this.section, this.key);
                if (values.size() == 1) {
                    ConfigManager.getSection(this.section).set(this.key, null);
                } else if (values.size() >= 1) {
                    values.remove(this.value.toString());
                    ConfigManager.getSection(this.section).set(this.key, values);
                }
            }
        } else {
            ConfigManager.getSection(this.section).set(this.key, this.value);
        }
        ConfigManager.saveSection(this.section);
        SendMessage.sendMessage(logger, Lang.EDITSHOP_EDIT_ITEM_SUCCESSFUL.get().replace("%itemPath%", this.section));
        SendMessage.sendMessage(logger, Lang.EDITSHOP_RELOAD_SHOP_TO_SEE_CHANGES.get());
    }
}

