/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.methodes;

import github.scarsz.discordsrv.DiscordSRV;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.providers.DiscordSRVProvider;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.Transaction;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class SendMessage {
    private static EconomyShopGUI plugin;
    private static DiscordSRVProvider discordSRV;
    private static ConsoleCommandSender logger;
    private static boolean logPlayerTransactions;
    private static boolean logTransactions;
    private static boolean onScreenTitle;
    private static String prefix;

    public SendMessage(EconomyShopGUI plugin) {
        logger = plugin.getServer().getConsoleSender();
        prefix = "\u00a78[\u00a73EconomyShopGUI\u00a78]\u00a7r";
        SendMessage.plugin = plugin;
    }

    public static void init() {
        if (ConfigManager.getConfig().getBoolean("log-player-transactions")) {
            logPlayerTransactions = true;
        }
        if (ConfigManager.getConfig().getBoolean("transaction-log") && plugin.getTransactionLog().setup()) {
            logTransactions = true;
        }
        if (ConfigManager.getConfig().getBoolean("on-screen-title")) {
            onScreenTitle = true;
        }
        if (ConfigManager.getConfig().getBoolean("enable-discordsrv-hook") && plugin.getServer().getPluginManager().getPlugin("DiscordSRV") != null) {
            if (DiscordSRV.isReady) {
                discordSRV = new DiscordSRVProvider(plugin, ConfigManager.getConfig().getConfigurationSection("discordsrv-transactions"));
            } else {
                discordSRV = new DiscordSRVProvider(plugin);
                DiscordSRV.api.subscribe((Object)discordSRV);
                SendMessage.infoMessage("Waiting for DiscordSRV to initialize...");
            }
        }
    }

    public static void sendTransactionMessage(Player player, int amount, double price, ShopItem shopItem, Transaction.Mode mode, Transaction.Type type) {
        SendMessage.chatToPlayer(player, (mode == Transaction.Mode.BUY ? Lang.PAY_CONFIRMATION.get() : Lang.SELL_CONFIRMATION.get()).replace("%amount%", String.valueOf(amount)).replace("%material%", shopItem instanceof ShopItem.Shulker ? shopItem.getDisplayname() + ChatColor.GRAY + ((ShopItem.Shulker)shopItem).getContents().entrySet().stream().map(entry -> entry.getValue() + "x " + ((ShopItem)entry.getKey()).getDisplayname() + ChatColor.GRAY).collect(Collectors.toList()) : shopItem.getDisplayname()).replace("%amounttopay%", EconomyShopGUI.getInstance().formatPrice(shopItem.getEcoType(), price)));
        SendMessage.logPlayerTransaction(Lang.PLAYER_MADE_TRANSACTION.get().replace("%playername%", player.getName()).replace("%player_displayname%", ChatColor.stripColor((String)plugin.getDisplayName(player))).replace("%bought/sold%", mode.getName()).replace("%amount%", String.valueOf(amount)).replace("%material%", shopItem instanceof ShopItem.Shulker ? ChatColor.stripColor((String)shopItem.getDisplayname()) + "(" + shopItem.getItemPath() + ")" + ((ShopItem.Shulker)shopItem).getContents().entrySet().stream().map(entry -> entry.getValue() + "x " + ChatColor.stripColor((String)((ShopItem)entry.getKey()).getDisplayname()) + "(" + ((ShopItem)entry.getKey()).getItemPath() + ")").collect(Collectors.toList()) : ChatColor.stripColor((String)shopItem.getDisplayname()) + "(" + shopItem.getItemPath() + ")").replace("%amountofmoney%", EconomyShopGUI.getInstance().formatPrice(shopItem.getEcoType(), price)).replace("%buy/sell-method%", type.getName()));
        if (discordSRV != null && SendMessage.discordSRV.enabled) {
            plugin.runTaskAsync(() -> discordSRV.logTransaction(player, amount, mode.getName(), shopItem.getDisplayname(), plugin.formatPrice(shopItem.getEcoType(), price)));
        }
        if (onScreenTitle && (type == Transaction.Type.SELL_ALL_COMMAND || type == Transaction.Type.SELL_GUI_SCREEN || shopItem.isCloseMenu())) {
            SendMessage.sendTitle(player, mode, Collections.singletonMap(shopItem.getEcoType(), price));
        }
    }

    public static void sendTransactionMessage(Player player, int amount, Map<EcoType, Double> prices, Map<ShopItem, Integer> items, Transaction.Type type) {
        String message = Lang.SELL_CONFIRMATION_MULTIPLE_ITEMS.get().replace("%amount%", String.valueOf(amount)).replace("%amounttopay%", SendMessage.getCurrencyDisplay(prices, false));
        TextComponent main = new TextComponent(TextComponent.fromLegacyText((String)message));
        main.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)(ChatColor.GRAY + SendMessage.getItemDisplay(items, false)))));
        if (SendMessage.plugin.spigot) {
            SendMessage.chatToPlayer(player, main);
        } else {
            SendMessage.chatToPlayer(player, message);
        }
        SendMessage.logPlayerTransaction(Lang.PLAYER_MADE_TRANSACTION_MULTIPLE_ITEMS.get().replace("%playername%", ChatColor.stripColor((String)player.getDisplayName())).replace("%player_displayname%", ChatColor.stripColor((String)plugin.getDisplayName(player))).replace("%bought/sold%", Lang.SOLD.get()).replace("%items%", SendMessage.getItemDisplay(items, true)).replace("%amountofmoney%", SendMessage.getCurrencyDisplay(prices, true)).replace("%buy/sell-method%", type.getName()));
        if (discordSRV != null && SendMessage.discordSRV.enabled) {
            plugin.runTaskAsync(() -> discordSRV.logTransaction(player, amount, Lang.SOLD.get(), SendMessage.getItemDisplay(items, true), SendMessage.getCurrencyDisplay(prices, true)));
        }
        if (onScreenTitle) {
            SendMessage.sendTitle(player, prices);
        }
    }

    private static String getItemDisplay(Map<ShopItem, Integer> items, boolean c) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry<ShopItem, Integer> entry : items.entrySet()) {
            if (entry.getKey() instanceof ShopItem.Shulker) {
                Map<ShopItem, Integer> contents = ((ShopItem.Shulker)entry.getKey()).getContents();
                sb.append(entry.getValue()).append("x ").append(entry.getKey().getDisplayname()).append(ChatColor.GRAY);
                sb.append(contents.entrySet().stream().map(e -> e.getValue() + "x " + ((ShopItem)e.getKey()).getDisplayname() + ChatColor.GRAY).collect(Collectors.toList()));
            } else {
                sb.append(entry.getValue()).append("x ").append(entry.getKey().getDisplayname()).append(ChatColor.GRAY);
            }
            if (c) {
                sb.append("(").append(entry.getKey().getItemPath()).append(")");
            }
            if (i != items.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    private static String getCurrencyDisplay(Map<EcoType, Double> prices, boolean c) {
        return SendMessage.getCurrencyDisplay(Lang.SELL_CONFIRMATION_MULTIPLE_ITEMS.get().split("%amountofmoney%")[0], prices, c);
    }

    private static String getCurrencyDisplay(String message, Map<EcoType, Double> prices, boolean c) {
        String color = ChatColor.getLastColors((String)message);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry<EcoType, Double> entry : prices.entrySet()) {
            sb.append(plugin.formatPrice(entry.getKey(), entry.getValue()));
            sb.append("\u00a7r");
            if (!c) {
                sb.append(color);
            }
            if (i != prices.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    private static void sendTitle(Player player, Map<EcoType, Double> prices) {
        SendMessage.sendTitle(player, null, prices);
    }

    private static void sendTitle(Player player, Transaction.Mode mode, Map<EcoType, Double> prices) {
        String message = mode == null || mode == Transaction.Mode.SELL ? Lang.ON_SCREEN_TITLE_SOLD.get() : Lang.ON_SCREEN_TITLE_BOUGHT.get();
        player.sendTitle(message.replace("%price%", SendMessage.getCurrencyDisplay(message.split("%price%")[0], prices, false)), "", 10, 40, 20);
    }

    public static void sendMessage(Object logger, String message) {
        if (logger instanceof Player) {
            SendMessage.chatToPlayer((Player)logger, message);
        } else if (logger instanceof CommandSender) {
            ((CommandSender)logger).sendMessage(message);
        }
    }

    public static void chatToPlayer(Player p, String message) {
        p.sendMessage(Lang.SHOP_PREFIX.get() + ChatColor.RESET + message);
    }

    public static void chatToPlayer(Player p, TextComponent message) {
        TextComponent text = new TextComponent(TextComponent.fromLegacyText((String)Lang.SHOP_PREFIX.get()));
        text.addExtra((BaseComponent)message);
        p.spigot().sendMessage((BaseComponent)text);
    }

    public static void logDebugMessage(String message) {
        if (ConfigManager.getConfig().getBoolean("debug")) {
            logger.sendMessage(prefix + " \u00a78[\u00a76DEBUG\u00a78]\u00a7r: " + message);
        }
    }

    public static void logDebugMessage(Exception e) {
        if (ConfigManager.getConfig().getBoolean("debug")) {
            logger.sendMessage(prefix + " \u00a78[\u00a76DEBUG\u00a78]\u00a7r: " + e.getMessage());
            logger.sendMessage(prefix + " \u00a78[\u00a76DEBUG\u00a78]\u00a7r: " + e);
        }
    }

    public static void logPlayerTransaction(String message) {
        if (logPlayerTransactions) {
            logger.sendMessage(Lang.SHOP_PREFIX.get() + "\u00a7r" + message);
        }
        if (logTransactions) {
            plugin.getTransactionLog().log(ChatColor.stripColor((String)message));
        }
    }

    public static void infoMessage(String message) {
        logger.sendMessage(prefix + " \u00a78[\u00a77INFO\u00a78]\u00a7r: " + message);
    }

    public static void infoMessage(String message, Object logger) {
        if (logger instanceof Player) {
            SendMessage.chatToPlayer((Player)logger, ChatColor.GREEN + message);
        } else if (logger instanceof CommandSender) {
            ((CommandSender)logger).sendMessage(prefix + " \u00a78[\u00a77INFO\u00a78]\u00a7r: " + message);
        }
    }

    public static void warnMessage(String message) {
        logger.sendMessage(prefix + " \u00a78[\u00a7cWARN\u00a78]\u00a7r: " + message);
    }

    public static void warnMessage(String message, Object logger) {
        if (logger instanceof Player) {
            SendMessage.chatToPlayer((Player)logger, ChatColor.RED + message);
        } else if (logger instanceof CommandSender) {
            ((CommandSender)logger).sendMessage(prefix + " \u00a78[\u00a7cWARN\u00a78]\u00a7r: " + message);
        }
    }

    public static void errorMessage(String message) {
        logger.sendMessage(prefix + " \u00a78[\u00a74ERROR\u00a78]\u00a7r: " + message);
    }

    public static void errorMessage(String message, Object logger) {
        if (logger instanceof Player) {
            SendMessage.chatToPlayer((Player)logger, ChatColor.RED + message);
        } else if (logger instanceof CommandSender) {
            ((CommandSender)logger).sendMessage(prefix + " \u00a78[\u00a74ERROR\u00a78]\u00a7r: " + message);
        }
    }

    public static void errorItemShops(String itemPath) {
        SendMessage.warnMessage(Lang.ITEMS_PATH_IN_SHOPS_CONFIG.get().replace("%location%", itemPath));
    }

    public static void errorShops(String section, String path) {
        SendMessage.warnMessage(Lang.ITEMS_LOCATION_IN_SHOPS.get().replace("%section%", section).replace("%location%", path));
    }

    public static void errorItemConfig(String path) {
        SendMessage.warnMessage(Lang.ITEMS_PATH_IN_CONFIG.get().replace("%location%", path));
    }

    public static void errorItemSections(String itemPath) {
        SendMessage.warnMessage(Lang.ITEMS_PATH_IN_SECTIONS_CONFIG.get().replace("%location%", itemPath));
    }

    public static void errorSections(String section, String path) {
        SendMessage.warnMessage(Lang.ITEMS_LOCATION_IN_SECTIONS.get().replace("%section%", section).replace("%location%", path));
    }
}

