/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.objects;

import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.CalculateAmount;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.providers.priceModifiers.ModifierType;
import me.gypopo.economyshopgui.providers.priceModifiers.Modifiers;
import me.gypopo.economyshopgui.providers.priceModifiers.PriceModifier;
import me.gypopo.economyshopgui.providers.priceModifiers.seasons.SeasonModifier;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.SkullUtil;
import me.gypopo.economyshopgui.util.XMaterial;
import me.gypopo.economyshopgui.util.exceptions.ItemLoadException;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ShopItem {
    private ItemStack shopItem;
    private ItemStack itemToGive;
    private boolean error = false;
    private final EcoType economy;
    private boolean decorationLore;
    private boolean displayItem;
    private boolean priorLore;
    private boolean disablePricingLore;
    private boolean buyLore = true;
    private boolean sellLore = true;
    private final boolean hidden;
    private final boolean closeMenu;
    private final Modifiers modifiers = new Modifiers();
    private int stackSize;
    private double buyPrice;
    private double sellPrice;
    private int loreLine = 0;
    private DynamicLore lore;
    private String displayname;
    private String name;
    private int maxBuy;
    private int maxSell;
    private final String subSection;
    private final String itemPath;
    public final String section;
    public final String itemLoc;

    public ShopItem(String section, String itemLoc) {
        this.section = section;
        this.itemLoc = itemLoc;
        this.itemPath = this.section + "." + this.itemLoc;
        this.hidden = ConfigManager.getShop(this.section).getBoolean("pages." + this.itemLoc + ".hidden");
        this.subSection = ConfigManager.getShop(this.section).getString("pages." + this.itemLoc + ".section");
        if (this.subSection != null) {
            this.displayItem = true;
        }
        this.priorLore = ConfigManager.getShop(this.section).getBoolean(this.itemPath + ".prior-lore", EconomyShopGUI.getInstance().prioritizeItemLore);
        this.economy = EconomyShopGUI.getInstance().getEcoHandler().getEcon(this.section).getType();
        this.closeMenu = ConfigManager.getShop(this.section).getBoolean(this.itemPath + ".close-menu");
        try {
            this.shopItem = EconomyShopGUI.getInstance().createItem.loadShopSectionItem(this);
            if (this.shopItem == null) {
                this.shopItem = EconomyShopGUI.getInstance().createItem.getInvalidShopItem(this.section, this.itemLoc);
                this.loreLine = 0;
                this.error = true;
            } else if (this.shopItem.getType() != Material.AIR) {
                this.itemToGive = EconomyShopGUI.getInstance().createItem.loadItemToGive(this);
                this.stackSize = this.itemToGive.getAmount();
                this.maxBuy = ConfigManager.getShop(this.section).getInt("pages." + this.itemLoc + ".max-buy") * this.stackSize;
                this.maxSell = ConfigManager.getShop(this.section).getInt("pages." + this.itemLoc + ".max-sell") * this.stackSize;
                Double buyPrice = EconomyShopGUI.getInstance().createItem.getBaseBuyPrice(this.itemPath);
                Double sellPrice = EconomyShopGUI.getInstance().createItem.getBaseSellPrice(this.itemPath);
                if (buyPrice != null || sellPrice != null) {
                    this.buyPrice = buyPrice != null ? buyPrice / (double)this.stackSize : -1.0;
                    this.sellPrice = sellPrice != null ? sellPrice / (double)this.stackSize : -1.0;
                } else {
                    this.displayItem = true;
                }
                String string = EconomyShopGUI.getInstance().useItemName ? (this.itemToGive.getItemMeta().hasDisplayName() ? this.itemToGive.getItemMeta().getDisplayName() : EconomyShopGUI.getInstance().getMaterialName(this.itemToGive.getType().name())) : (this.name = EconomyShopGUI.getInstance().getMaterialName(this.itemToGive.getType().name()));
                this.displayname = EconomyShopGUI.getInstance().useItemName ? (this.shopItem.getItemMeta().hasDisplayName() ? this.shopItem.getItemMeta().getDisplayName() : EconomyShopGUI.getInstance().getMaterialName(this.shopItem.getType().name())) : EconomyShopGUI.getInstance().getMaterialName(this.shopItem.getType().name());
                List list = this.shopItem.hasItemMeta() ? this.shopItem.getItemMeta().getLore() : null;
                this.lore = new DynamicLore(list);
                this.loreLine = 2 + (EconomyShopGUI.getInstance().MMB && !Lang.MIDDLE_CLICK_SELL_ALL.get().isEmpty() && sellPrice != null && !(this.sellPrice < 0.0) ? 1 : 0);
                if (ConfigManager.getShop(this.section).getBoolean("pages." + this.itemLoc + ".hidePricingLore", false)) {
                    this.disablePricingLore = true;
                    this.loreLine -= 2;
                } else {
                    if (sellPrice == null || this.sellPrice >= 0.0 && Lang.RIGHT_CLICK_SELL.get().isEmpty() || this.sellPrice < 0.0 && Lang.ITEM_CANNOT_BE_SOLD.get().isEmpty()) {
                        this.sellLore = false;
                        --this.loreLine;
                    }
                    if (buyPrice == null || this.buyPrice >= 0.0 && Lang.LEFT_CLICK_BUY.get().isEmpty() || this.buyPrice < 0.0 && Lang.ITEM_CANNOT_BE_BOUGHT.get().isEmpty()) {
                        this.buyLore = false;
                        --this.loreLine;
                    }
                }
                if (!this.isLinked() && (this.buyPrice >= 0.0 || this.sellPrice >= 0.0)) {
                    this.decorationLore = true;
                }
            } else {
                this.displayItem = true;
            }
        }
        catch (ItemLoadException e) {
            this.shopItem = EconomyShopGUI.getInstance().createItem.getInvalidShopItem(this.section, this.itemLoc, e);
            this.loreLine = CalculateAmount.splitLongString(e.getMessage()).size() - 1;
            this.error = true;
            SendMessage.warnMessage(e.getMessage());
            SendMessage.errorShops(section, itemLoc);
        }
        catch (Exception e) {
            this.shopItem = EconomyShopGUI.getInstance().createItem.getInvalidShopItem(this.section, this.itemLoc);
            this.loreLine = 0;
            this.error = true;
            SendMessage.warnMessage("A error occurred while loading item '" + itemLoc + "' from section " + section);
            e.printStackTrace();
        }
    }

    public ShopItem(ShopItem shopItem) {
        this.itemPath = shopItem.itemPath;
        this.subSection = shopItem.subSection;
        this.section = shopItem.section;
        this.itemLoc = shopItem.itemLoc;
        this.hidden = shopItem.hidden;
        this.economy = shopItem.economy;
        this.closeMenu = shopItem.closeMenu;
        this.maxBuy = shopItem.maxBuy;
        this.maxSell = shopItem.maxSell;
        this.shopItem = shopItem.shopItem;
        this.itemToGive = shopItem.itemToGive;
        this.buyPrice = shopItem.buyPrice;
        this.sellPrice = shopItem.sellPrice;
        this.name = shopItem.name;
        this.displayname = shopItem.displayname;
        this.loreLine = shopItem.loreLine;
        this.buyLore = shopItem.buyLore;
        this.sellLore = shopItem.sellLore;
        this.priorLore = shopItem.priorLore;
        this.disablePricingLore = shopItem.disablePricingLore;
        this.error = shopItem.error;
        this.stackSize = shopItem.stackSize;
        this.displayItem = shopItem.displayItem;
    }

    public DynamicLore getLore() {
        return this.lore;
    }

    public String getItemPath() {
        return this.itemPath;
    }

    public ItemStack getShopItem() {
        return this.shopItem;
    }

    public ItemStack getItemToGive() {
        return this.itemToGive;
    }

    public boolean isLinked() {
        return this.subSection != null;
    }

    public String getSubSection() {
        return this.subSection;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public double getBuyPrice() {
        return this.buyPrice;
    }

    public double getBuyPrice(Player player) {
        return this.getPlayerBuyPrice(player, this.buyPrice);
    }

    private double getPlayerBuyPrice(Player player, double price) {
        for (PriceModifier modifier : this.modifiers) {
            price = modifier.modify(player, price);
        }
        if (EconomyShopGUI.getInstance().discountsActive && EconomyShopGUI.getInstance().hasDiscount(this.section)) {
            price = CalculateAmount.calculateDiscount(player, this.section, this.buyPrice);
        }
        return price;
    }

    public double getSellPrice() {
        return this.sellPrice;
    }

    public double getSellPrice(ItemStack itemToSell) {
        return itemToSell.getType().equals((Object)XMaterial.SPAWNER.parseMaterial()) ? EconomyShopGUI.getInstance().getSpawnerManager().getProvider().getSpawnerSellPrice(itemToSell, this.sellPrice) * (double)itemToSell.getAmount() : this.sellPrice * (double)itemToSell.getAmount();
    }

    public double getSellPrice(Player player) {
        return this.getPlayerSellPrice(player, this.sellPrice);
    }

    public double getSellPrice(Player player, ItemStack itemToSell) {
        double base = itemToSell.getType().equals((Object)XMaterial.SPAWNER.parseMaterial()) ? EconomyShopGUI.getInstance().getSpawnerManager().getProvider().getSpawnerSellPrice(itemToSell, this.sellPrice) * (double)itemToSell.getAmount() : this.sellPrice * (double)itemToSell.getAmount();
        return this.getPlayerSellPrice(player, base);
    }

    public double getSellPrice(Player player, ItemStack itemToSell, int amount) {
        double base = itemToSell.getType().equals((Object)XMaterial.SPAWNER.parseMaterial()) ? EconomyShopGUI.getInstance().getSpawnerManager().getProvider().getSpawnerSellPrice(itemToSell, this.sellPrice) * (double)amount : this.sellPrice * (double)amount;
        return this.getPlayerSellPrice(player, base);
    }

    private double getPlayerSellPrice(Player player, double price) {
        for (PriceModifier modifier : this.modifiers) {
            price = modifier.modify(player, price);
        }
        if (EconomyShopGUI.getInstance().multipliers && EconomyShopGUI.getInstance().hasMultiplier(this.section)) {
            price = CalculateAmount.calculateMultiplier(player, this.section, price);
        }
        return price;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDisplayItem() {
        return this.displayItem;
    }

    public boolean isDynamicPricing() {
        return false;
    }

    public int getLevelRequired() {
        return 0;
    }

    public int getLimitedStockMode() {
        return 0;
    }

    public boolean isRefillStock() {
        return false;
    }

    public int getLimitedSellMode() {
        return 0;
    }

    public boolean hasItemError() {
        return this.error;
    }

    public int getMaxBuy() {
        return this.maxBuy;
    }

    public boolean isMaxBuy(int amount) {
        return this.maxBuy != 0 && this.maxBuy < amount;
    }

    public int getMaxSell() {
        return this.maxSell;
    }

    public boolean isMaxSell(int amount) {
        return this.maxSell != 0 && this.maxSell < amount;
    }

    public int getLoreLine() {
        return this.loreLine;
    }

    public boolean isBuyLore() {
        return this.buyLore;
    }

    public boolean isSellLore() {
        return this.sellLore;
    }

    public boolean isDecorationLore() {
        return this.decorationLore;
    }

    public boolean isPriorLore() {
        return this.priorLore;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isCloseMenu() {
        return this.closeMenu;
    }

    public boolean isHidePricingLore() {
        return this.disablePricingLore;
    }

    public EcoType getEcoType() {
        return this.economy;
    }

    public void addPriceModifier(PriceModifier modifier) {
        this.modifiers.add(modifier);
    }

    public void addPriceModifiers(Collection<? extends PriceModifier> modifiers) {
        this.modifiers.addAll(modifiers);
    }

    public boolean hasPriceModifier(ModifierType type) {
        return this.modifiers.hasType(type);
    }

    public boolean hasSeasonModifier(String world) {
        return this.modifiers.hasSeasonModifier(world);
    }

    public void removePriceModifier(SeasonModifier modifier) {
        this.modifiers.remove(modifier);
    }

    public void removePriceModifiers(Collection<? extends PriceModifier> modifiers) {
        this.modifiers.removeAll(modifiers);
    }

    public void updateSkullTexture(GameProfile profile, boolean itg) {
        SkullMeta meta = (SkullMeta)(itg ? this.itemToGive : this.shopItem).getItemMeta();
        SkullUtil.applySkullProfile(profile, meta);
        (itg ? this.itemToGive : this.shopItem).setItemMeta((ItemMeta)meta);
    }

    public boolean match(ItemStack item) {
        if (!item.getType().equals((Object)this.itemToGive.getType())) {
            return false;
        }
        if (item.getType().equals((Object)XMaterial.SPAWNER.parseMaterial())) {
            return EconomyShopGUI.getInstance().getSpawnerManager().getProvider().isShopSpawner(item, this.itemToGive);
        }
        return EconomyShopGUI.getInstance().isSimilar(item, this.itemToGive);
    }

    public final class DynamicLore {
        private final String[] lore;
        private final String[] fastLore;

        public DynamicLore(List<String> list) {
            this.lore = list == null || list.isEmpty() ? new String[]{} : (String[])list.stream().map(s -> EconomyShopGUI.getInstance().formatColors(this.translateLocalPlaceholders((String)s))).toArray(String[]::new);
            this.fastLore = (String[])Arrays.stream(this.lore).map(s -> EconomyShopGUI.getInstance().versionHandler.toNBT(this.translateLocalPlaceholders((String)s))).toArray(String[]::new);
        }

        private String translateLocalPlaceholders(String s) {
            if (s.contains("%buyPrice%") && ShopItem.this.buyPrice >= 0.0) {
                s = s.replace("%buyPrice%", EconomyShopGUI.getInstance().formatPrice(ShopItem.this.getEcoType(), ShopItem.this.getBuyPrice()));
            }
            if (s.contains("%sellPrice%") && ShopItem.this.sellPrice >= 0.0) {
                s = s.replace("%sellPrice%", EconomyShopGUI.getInstance().formatPrice(ShopItem.this.getEcoType(), ShopItem.this.getSellPrice()));
            }
            return s;
        }

        public String[] get(boolean fast) {
            return fast ? this.fastLore : this.lore;
        }
    }

    public static class Shulker
    extends ShopItem {
        private final Map<ShopItem, Integer> contents;
        private final ItemStack box;

        public Shulker(ShopItem shopItem, ItemStack box, Map<ShopItem, Integer> contents) {
            super(shopItem);
            this.box = box;
            this.contents = contents;
        }

        public Map<ShopItem, Integer> getContents() {
            return this.contents;
        }

        public ItemStack getBox() {
            return this.box;
        }
    }
}

