/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jline.internal.Nullable;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.CalculateAmount;
import me.gypopo.economyshopgui.methodes.CreateItem;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.objects.ShopPage;
import me.gypopo.economyshopgui.objects.ShopPageItems;
import me.gypopo.economyshopgui.objects.User;
import me.gypopo.economyshopgui.providers.UserManager;
import me.gypopo.economyshopgui.util.PermissionsCache;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ShopSection
extends CreateItem {
    private final String section;
    private final String title;
    private final boolean subSection;
    private final boolean navBar;
    private ItemStack fillItem;
    private final List<String> pages;
    private final Map<Integer, ShopPageItems> shopPages = new HashMap<Integer, ShopPageItems>();
    private final Map<String, ShopItem> shopItems = new HashMap<String, ShopItem>();
    private final EconomyShopGUI plugin;
    private final boolean nms;
    private final String itemSeasonalBuyPriceNBT;
    private final String itemSeasonalSellPriceNBT;
    private final String itemMultipliedPriceNBT;
    private final String itemDiscountedPriceNBT;
    private final String itemIndexLoreNBT;
    private final String itemSeasonalPricesNBT;
    public final List<String> itemLocs;

    public ShopSection(EconomyShopGUI plugin, String section) {
        super(plugin);
        this.nms = EconomyShopGUI.getInstance().versionHandler != null && EconomyShopGUI.getInstance().version >= 113 && ConfigManager.getConfig().getBoolean("use-nms", true) && Bukkit.getPluginManager().getPlugin("EcoEnchants") == null;
        this.itemLocs = new ArrayList<String>();
        this.plugin = plugin;
        this.section = section;
        this.title = EconomyShopGUI.getInstance().getSectionTitle(section);
        this.navBar = this.plugin.navBar.isEnabled(this.section);
        this.itemLocs.addAll(this.plugin.getConfigManager().getItemsRaw(this.section));
        this.subSection = ConfigManager.getSection(section).getBoolean("sub-section");
        this.pages = this.plugin.getConfigManager().getPages(this.section);
        this.itemMultipliedPriceNBT = plugin.versionHandler.toNBT(Lang.MULTIPLIED_SELL_PRICE.get());
        this.itemSeasonalSellPriceNBT = plugin.versionHandler.toNBT(Lang.SEASONAL_SELL_PRICE.get());
        this.itemDiscountedPriceNBT = plugin.versionHandler.toNBT(Lang.DISCOUNTED_BUY_PRICE.get());
        this.itemSeasonalBuyPriceNBT = plugin.versionHandler.toNBT(Lang.SEASONAL_BUY_PRICE.get());
        this.itemIndexLoreNBT = plugin.versionHandler.toNBT(Lang.ITEM_LOCATION_IN_SHOP.get());
        this.itemSeasonalPricesNBT = plugin.versionHandler.toNBT(Lang.ITEM_SEASONAL_PRICE.get());
        this.loadShopItems();
    }

    public Collection<ShopItem> getShopItems() {
        return this.shopItems.values();
    }

    public ShopItem getShopItem(String itemPath) {
        return this.shopItems.get(itemPath);
    }

    public String getSection() {
        return this.section;
    }

    public ShopPageItems getShopPageItems(int page) {
        return this.shopPages.get(page);
    }

    public List<ShopPageItems> getShopPageItems() {
        return new ArrayList<ShopPageItems>(this.shopPages.values());
    }

    public int getPages() {
        return this.pages.size();
    }

    public Set<String> getValidItemPaths() {
        return this.shopItems.keySet();
    }

    public boolean isSubSection() {
        return this.subSection;
    }

    public int getPageForShopItem(String location) {
        return this.pages.indexOf(location.split("\\.")[0]) + 1;
    }

    private void loadShopItems() {
        try {
            for (String itemLoc : this.itemLocs) {
                this.shopItems.put(this.section + "." + itemLoc, new ShopItem(this.section, itemLoc));
            }
            this.loadPages();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        if (ConfigManager.getSection(this.section).get("fill-item") != null) {
            this.loadFillItem();
        }
    }

    private void loadFillItem() {
        this.fillItem = this.plugin.createItem.createFillItem(this.section, ConfigManager.getSection(this.section).getConfigurationSection("fill-item"));
    }

    private void loadPages() {
        try {
            int pageN = 1;
            for (String page : this.pages) {
                int size = this.getPageSize(page);
                List<String> displayItems = this.plugin.calculateAmount.loadItemsInOrder(this.section, page, this.plugin.navBar.isEnabled(this.section) ? size - 9 : size);
                ArrayList<String> itemLocs = new ArrayList<String>();
                LinkedHashMap<Integer, ItemStack> items = new LinkedHashMap<Integer, ItemStack>();
                for (int i = 0; i < displayItems.size(); ++i) {
                    String itemLoc = displayItems.get(i);
                    if (itemLoc != null) {
                        items.put(i, this.shopItems.get(this.section + "." + itemLoc).getShopItem());
                    }
                    itemLocs.add(itemLoc);
                }
                this.shopPages.put(pageN, new ShopPageItems(items, itemLocs, this.section, size));
                ++pageN;
            }
        }
        catch (Exception e) {
            SendMessage.warnMessage("Error occurred while loading shop items for section " + this.section);
            e.printStackTrace();
        }
    }

    private int getPageSize(String page) {
        if (!ConfigManager.getShop(this.section).contains("pages." + page + ".gui-rows")) {
            int size = ConfigManager.getShop(this.section).getConfigurationSection("pages." + page + ".items").getKeys(false).size();
            return size <= 45 && size >= 1 ? CalculateAmount.getSlots(size) : 45;
        }
        try {
            int size = Integer.parseInt(ConfigManager.getShop(this.section).getString("pages." + page + ".gui-rows"));
            if (size >= 1 && size <= 6) {
                return size * 9;
            }
            SendMessage.warnMessage("Inventory size for page '" + page + "' from shop '" + this.section + "' has to be in range from 1-6, using default...");
        }
        catch (NumberFormatException e) {
            SendMessage.warnMessage("Invalid inventory size for page '" + page + "' from shop '" + this.section + "', using default...");
        }
        return 45;
    }

    public void openShopSection(Player p, boolean disabledBackButton) {
        this.openShopSection(p, 1, disabledBackButton);
    }

    public void openShopSection(Player p, boolean disabledBackButton, String rootSection) {
        this.openShopSection(p, 1, disabledBackButton, rootSection);
    }

    public void openShopSection(Player p, int page, boolean disabledBackButton) {
        this.openShopSection(p, page, disabledBackButton, null);
    }

    public void openShopSection(Player p, int page, boolean disabledBackButton, @Nullable String rootSection) {
        Map<Integer, ItemStack> items = this.shopPages.get(page).getItems();
        User user = UserManager.getUser(p);
        boolean itemIndex = PermissionsCache.hasPermission(p, "EconomyShopGUI.itemindexes");
        boolean discounts = this.plugin.discountsActive && this.plugin.hasDiscount(this.section);
        boolean multipliers = this.plugin.multipliers && this.plugin.hasMultiplier(this.section);
        this.updateLore(items, p, user.isBedrock() || user.isPr(), itemIndex, discounts, multipliers, page);
        p.openInventory(new ShopPage(items, this.fillItem, p, this.getTitle(page), this.section, page, this.pages.size(), disabledBackButton, this.navBar, this.plugin.resizeGUI && user.isBedrock() ? 54 : this.shopPages.get(page).getSize(), rootSection).getInventory());
    }

    private void updateLore(Map<Integer, ItemStack> items, Player p, boolean pr, boolean itemIndex, boolean discounts, boolean multipliers, int page) {
        boolean fast = this.nms && !pr;
        items.replaceAll((slot, item) -> {
            if (item.getType().equals((Object)Material.AIR)) {
                return item;
            }
            ShopItem shopItem = this.shopItems.get(this.section + "." + this.shopPages.get(page).getItemOrder().get((int)slot));
            return this.updateLore(shopItem, new ItemStack(item), p, fast, discounts, multipliers, itemIndex, this.plugin.seasonalLore && shopItem.hasSeasonModifier(p.getWorld().getName()));
        });
    }

    private ItemStack updateLore(ShopItem shopItem, ItemStack item, Player p, boolean fast, boolean discounts, boolean multipliers, boolean itemIndex, boolean seasonal) {
        try {
            return this.plugin.getLoreFormatter().format(shopItem, item, p, this.section, fast, discounts, multipliers, itemIndex, seasonal);
        }
        catch (Exception e) {
            SendMessage.warnMessage("Error occurred while updating shop lore of item '" + shopItem.getItemPath() + "'");
            e.printStackTrace();
            return item;
        }
    }

    private String getTitle(int page) {
        return this.title.replace("%page%", String.valueOf(page)).replace("%pages%", String.valueOf(this.pages));
    }

    public ItemStack updateItem(Player p, ShopItem shopItem) {
        ItemStack item = new ItemStack(shopItem.getShopItem());
        boolean nbt = this.nms && !UserManager.getUser(p).isBedrock() && !UserManager.getUser(p).isPr();
        boolean itemIndex = PermissionsCache.hasPermission(p, "EconomyShopGUI.itemindexes");
        boolean discounts = this.plugin.discountsActive && this.plugin.hasDiscount(this.section);
        boolean multipliers = this.plugin.multipliers && this.plugin.hasMultiplier(this.section);
        return this.updateLore(shopItem, item, p, nbt, discounts, multipliers, itemIndex, this.plugin.seasonalLore && shopItem.hasSeasonModifier(p.getWorld().getName()));
    }
}

