/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.objects;

import java.util.List;
import java.util.stream.Collectors;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.methodes.CreateItem;
import me.gypopo.economyshopgui.objects.TransactionItem;
import me.gypopo.economyshopgui.objects.TransactionScreen;
import me.gypopo.economyshopgui.util.Transaction;

public class TransactionMenus {
    private static TransactionScreen buyScreen;
    private static TransactionScreen sellScreen;
    private static TransactionScreen buyStacksScreen;

    public static void load(EconomyShopGUI plugin) {
        buyScreen = plugin.createItem.getTransactionScreen(Transaction.Type.BUY_SCREEN);
        sellScreen = plugin.createItem.getTransactionScreen(Transaction.Type.SELL_SCREEN);
        buyStacksScreen = plugin.createItem.getTransactionScreen(Transaction.Type.BUY_STACKS_SCREEN);
    }

    public static List<TransactionItem> getItems(Transaction.Type type) {
        return type == Transaction.Type.BUY_STACKS_SCREEN ? buyStacksScreen.getItems() : (type == Transaction.Type.BUY_SCREEN ? buyScreen.getItems() : sellScreen.getItems());
    }

    public static CreateItem.TransactionItemAction getActionFromSlot(Transaction.Type type, int slot) {
        try {
            TransactionItem item = TransactionMenus.getItems(type).stream().filter(i -> i.getSlots().contains(slot) && i.getAction() != CreateItem.TransactionItemAction.NONE).findFirst().orElse(null);
            if (item != null) {
                return item.getAction();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return CreateItem.TransactionItemAction.NONE;
    }

    public static TransactionItem getItemFromSlot(Transaction.Type type, int slot) {
        return TransactionMenus.getItems(type).stream().filter(item -> item.getSlots().contains(slot)).findFirst().orElse(null);
    }

    public static TransactionItem getItemByType(Transaction.Type type, CreateItem.TransactionItemType itemType) {
        return TransactionMenus.getItems(type).stream().filter(i -> i.getType() == itemType).findFirst().orElse(null);
    }

    public static List<TransactionItem> getItemsByType(Transaction.Type type, CreateItem.TransactionItemType itemType) {
        return TransactionMenus.getItems(type).stream().filter(i -> i.getType() == itemType).collect(Collectors.toList());
    }

    public static int getSize(Transaction.Type type) {
        return type == Transaction.Type.BUY_STACKS_SCREEN ? buyStacksScreen.getSize() : (type == Transaction.Type.BUY_SCREEN ? buyScreen.getSize() : sellScreen.getSize());
    }
}

