/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.objects.inventorys;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.ShopInventory;
import me.gypopo.economyshopgui.objects.layouts.SimpleCard;
import org.bukkit.ChatColor;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.ConversationPrefix;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CustomizeLayout
extends ShopInventory {
    private ConversationFactory factory;
    private Conversation conv;
    private final SimpleCard card = new SimpleCard();
    private final Pattern namePattern = Pattern.compile("[a-zA-Z0-9]+");
    private final EconomyShopGUI plugin = EconomyShopGUI.getInstance();
    private final ArrayList<String> files = new ArrayList();
    private final Player player;
    private final Consumer<SimpleCard> onComplete;
    private final Prompt prompt = new StringPrompt(){

        public String getPromptText(ConversationContext c) {
            switch (Input.valueOf((String)c.getSessionData((Object)"input"))) {
                case TITLE: {
                    CustomizeLayout.this.player.sendTitle("\u00a7bEnter layout title", "", 5, 80, 5);
                    return "\u00a7aEnter a title for this layout.\n\u00a7aExample: ModernLayout";
                }
                case DESC: {
                    CustomizeLayout.this.player.sendTitle("\u00a7bEnter description", "", 5, 80, 5);
                    return "\u00a7aEnter a description for this layout.\n\u00a7aExample: Modern shop layout with almost every in-game item.";
                }
                case TAGS: {
                    CustomizeLayout.this.player.sendTitle("\u00a7bEnter tags", "", 5, 80, 5);
                    return "\u00a7aTags can be used to easily identify this layout, use the format of \u00a7f#<tag>\u00a7a, use commas(',') to specify multiple tags.\n\u00a7aExample: #modern, #allItems, #cheap\n\u00a7cEnter 'skip' in chat to skip this step.";
                }
            }
            return null;
        }

        public Prompt acceptInput(ConversationContext c, String s) {
            c.setSessionData((Object)"result", (Object)s);
            return Prompt.END_OF_CONVERSATION;
        }
    };

    public CustomizeLayout(Player p, Consumer<SimpleCard> onComplete) {
        this.onComplete = onComplete;
        this.player = p;
        this.startConversation(p, Input.TITLE);
    }

    private void startConversation(Player p, Input input) {
        this.factory = new ConversationFactory((Plugin)EconomyShopGUI.getInstance());
        this.conv = this.factory.withFirstPrompt(this.prompt).addConversationAbandonedListener((ConversationAbandonedListener)new ConvAbandon()).withEscapeSequence("exit").withLocalEcho(false).withTimeout(60).withPrefix((ConversationPrefix)new ConvPrefix()).buildConversation((Conversable)p);
        this.conv.getContext().setSessionData((Object)"input", (Object)input.name());
        this.conv.begin();
    }

    private static enum Input {
        TITLE,
        DESC,
        TAGS;

    }

    private final class ConvAbandon
    implements ConversationAbandonedListener {
        private ConvAbandon() {
        }

        public void conversationAbandoned(ConversationAbandonedEvent event) {
            Player p = (Player)event.getContext().getForWhom();
            if (event.gracefulExit()) {
                String result = (String)event.getContext().getSessionData((Object)"result");
                switch (Input.valueOf((String)event.getContext().getSessionData((Object)"input"))) {
                    case TITLE: {
                        if (result.length() > 32) {
                            SendMessage.chatToPlayer(p, "\u00a7cInvalid title, title cannot be longer as 32 characters");
                            CustomizeLayout.this.startConversation(p, Input.TITLE);
                        } else {
                            CustomizeLayout.this.card.setTitle(result);
                            CustomizeLayout.this.startConversation(p, Input.DESC);
                        }
                        return;
                    }
                    case DESC: {
                        CustomizeLayout.this.card.setDescription(result);
                        CustomizeLayout.this.startConversation(p, Input.TAGS);
                        return;
                    }
                    case TAGS: {
                        ArrayList<String> tags = new ArrayList<String>();
                        if (!result.equalsIgnoreCase("skip")) {
                            for (String tag : result.replace(" ", "").split(",")) {
                                if (tag.startsWith("#")) {
                                    tag = tag.substring(1);
                                }
                                if (!CustomizeLayout.this.namePattern.matcher(tag).matches()) {
                                    SendMessage.chatToPlayer(p, "\u00a7c\u00a7lInvalid tag for " + tag + ", contains invalid characters");
                                    CustomizeLayout.this.startConversation(p, Input.TAGS);
                                    return;
                                }
                                if (tag.length() > 10) {
                                    SendMessage.chatToPlayer(p, "\u00a7c\u00a7lInvalid tag for " + tag + ", tag cannot be longer as 10 characters");
                                    CustomizeLayout.this.startConversation(p, Input.TAGS);
                                    return;
                                }
                                tags.add(tag);
                            }
                        }
                        CustomizeLayout.this.card.setTags(tags);
                    }
                }
                CustomizeLayout.this.onComplete.accept(CustomizeLayout.this.card);
            } else {
                SendMessage.chatToPlayer(p, "\u00a7cExited the conversation.");
            }
        }
    }

    private final class ConvPrefix
    implements ConversationPrefix {
        private ConvPrefix() {
        }

        public String getPrefix(ConversationContext context) {
            return Lang.SHOP_PREFIX.get() + ChatColor.RESET + " ";
        }
    }
}

