/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.providers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.ViaAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.User;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.geysermc.floodgate.api.FloodgateApi;
import protocolsupport.api.ProtocolSupportAPI;
import protocolsupport.api.ProtocolVersion;

public class UserManager {
    private final EconomyShopGUI plugin;
    private static final ArrayList<Integer> versions = new ArrayList();
    private static ViaAPI vv;
    private static FloodgateApi fAPI;
    private static String prefix;
    private static boolean ps;
    private static final LoadingCache<UUID, User> USER_MAP;

    public UserManager(EconomyShopGUI plugin) {
        this.plugin = plugin;
    }

    public void init() {
        if (this.plugin.getServer().getPluginManager().getPlugin("ViaVersion") != null) {
            vv = Via.getAPI();
            this.plugin.scheduleSyncDelayedTask(() -> versions.addAll((Collection<Integer>)vv.getServerVersion().supportedVersions()), 5L);
        }
        if (this.plugin.getServer().getPluginManager().getPlugin("ProtocolSupport") != null) {
            versions.addAll(Arrays.stream(ProtocolVersion.getAllSupported()).map(ProtocolVersion::getId).collect(Collectors.toList()));
            ps = true;
        }
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("floodgate")) {
            fAPI = FloodgateApi.getInstance();
            prefix = this.getPrefix();
        }
    }

    private String getPrefix() {
        File conf = new File(EconomyShopGUI.getInstance().getDataFolder().getParent() + "/floodgate/config.yml");
        if (!conf.exists()) {
            SendMessage.logDebugMessage("Failed to find player prefix for floodgate players, using default of '.'...");
            return ".";
        }
        YamlConfiguration config = EconomyShopGUI.getInstance().loadConfiguration(conf, "floodgate config.yml");
        if (config == null) {
            return ".";
        }
        return config.getString("username-prefix", ".");
    }

    public static User getUser(Player p) {
        try {
            return (User)USER_MAP.get((Object)p.getUniqueId());
        }
        catch (ExecutionException e) {
            return UserManager.loadUser(p);
        }
    }

    public static User loadUser(Player p) {
        User user = new User(p);
        if (UserManager.isPrPlayer(p)) {
            user.setPr(true);
        }
        if (UserManager.isFloodgatePlayer(p)) {
            user.setBedrock(true);
        }
        return user;
    }

    private static boolean isPrPlayer(Player p) {
        if (vv != null) {
            return !versions.contains(vv.getPlayerVersion(p.getUniqueId()));
        }
        if (ps) {
            return versions.contains(ProtocolSupportAPI.getConnection((Player)p).getVersion().getId());
        }
        return false;
    }

    private static boolean isFloodgatePlayer(Player p) {
        if (fAPI != null) {
            return fAPI.isFloodgatePlayer(p.getUniqueId());
        }
        return p.getName().startsWith(prefix);
    }

    public void reloadPlayerData() {
        this.plugin.getServer().getOnlinePlayers().forEach(p -> USER_MAP.refresh((Object)p.getUniqueId()));
    }

    static {
        prefix = ".";
        ps = false;
        USER_MAP = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<UUID, User>(){

            public User load(UUID uuid) throws Exception {
                return UserManager.loadUser(Bukkit.getPlayer((UUID)uuid));
            }
        });
    }
}

