/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.providers.economys;

import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.providers.EconomyProvider;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.EconomyType;
import me.gypopo.economyshopgui.util.exceptions.EconomyLoadException;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.PlayerPointsAPI;
import org.bukkit.OfflinePlayer;

public class PlayerPointsEconomy
implements EconomyProvider {
    private PlayerPointsAPI pp;
    private String friendly;
    private String singular;
    private String plural;
    private final boolean decimal = false;

    @Override
    public void setup(EconomyShopGUI plugin) throws EconomyLoadException {
        if (plugin.getServer().getPluginManager().isPluginEnabled("PlayerPoints")) {
            this.pp = PlayerPoints.getInstance().getAPI();
            if (this.pp == null) {
                throw new EconomyLoadException("Failed to hook into PlayerPoints economy");
            }
        } else {
            throw new EconomyLoadException("Could not find PlayerPoints");
        }
        SendMessage.infoMessage("Successfully hooked into PlayerPoints");
        this.formatSingular();
        this.formatPlural();
        this.friendly = ConfigManager.getConfig().getString("currency-formats.player-points.friendly", "Points");
    }

    @Override
    public double getBalance(OfflinePlayer p) {
        return this.pp.look(p.getUniqueId());
    }

    @Override
    public void depositBalance(OfflinePlayer p, double amount) {
        this.pp.give(p.getUniqueId(), (int)Math.round(amount));
    }

    @Override
    public void withdrawBalance(OfflinePlayer p, double amount) {
        this.pp.take(p.getUniqueId(), (int)Math.round(amount));
    }

    @Override
    public EcoType getType() {
        return new EcoType(EconomyType.PLAYER_POINTS);
    }

    @Override
    public String getPlural() {
        return this.plural;
    }

    @Override
    public String getSingular() {
        return this.singular;
    }

    @Override
    public String getFriendly() {
        return this.friendly;
    }

    @Override
    public boolean isDecimal() {
        return this.decimal;
    }

    private void formatSingular() {
        String singular = ConfigManager.getConfig().getString("currency-formats.player-points.singular", "Point");
        this.singular = this.isSymbol(singular) ? Lang.SYMBOL_PRICING_FORMAT.get().replace("%symbol%", singular) : Lang.NAMED_PRICING_FORMAT.get().replace("%currency-format%", singular);
    }

    private void formatPlural() {
        String plural = ConfigManager.getConfig().getString("currency-formats.player-points.plural", "Points");
        this.plural = this.isSymbol(plural) ? Lang.SYMBOL_PRICING_FORMAT.get().replace("%symbol%", plural) : Lang.NAMED_PRICING_FORMAT.get().replace("%currency-format%", plural);
    }

    private boolean isSymbol(String format) {
        return format.chars().count() == 1L;
    }
}

