/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.providers.priceModifiers.seasons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import me.casperge.realisticseasons.api.SeasonChangeEvent;
import me.casperge.realisticseasons.api.SeasonsAPI;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.ConfigManager;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.objects.ShopSection;
import me.gypopo.economyshopgui.providers.priceModifiers.seasons.Season;
import me.gypopo.economyshopgui.providers.priceModifiers.seasons.SeasonModifier;
import me.gypopo.economyshopgui.providers.priceModifiers.seasons.SeasonType;
import me.gypopo.economyshopgui.util.exceptions.ModifierLoadException;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class SeasonProvider
implements Listener {
    private final EconomyShopGUI plugin;
    private final Map<String, SeasonModifiers> LOADED_MODIFIERS = new HashMap<String, SeasonModifiers>();
    private static final Map<String, Season> LOADED_SEASONS = new HashMap<String, Season>();
    private boolean ready = false;
    private SeasonsAPI api;

    public SeasonProvider(EconomyShopGUI plugin) throws ModifierLoadException {
        this.plugin = plugin;
        if (plugin.getServer().getPluginManager().getPlugin("RealisticSeasons") != null) {
            try {
                this.api = SeasonsAPI.getInstance();
                this.loadModifiers(plugin);
                SendMessage.infoMessage(Lang.ENABLED_PLUGIN_HOOK.get().replace("%plugin%", "RealisticSeasons"));
                this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            }
            catch (NullPointerException e) {
                SendMessage.infoMessage("RealisticSeasons found, waiting...");
                Consumer<SeasonsAPI> result = api -> {
                    if (api == null) {
                        SendMessage.warnMessage(Lang.FAILED_PLUGIN_INTEGRATION.get().replace("%plugin%", "RealisticSeasons"));
                        return;
                    }
                    SendMessage.infoMessage(Lang.ENABLED_PLUGIN_HOOK.get().replace("%plugin%", "RealisticSeasons"));
                    this.api = api;
                    this.loadModifiers(plugin);
                    this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
                };
                plugin.scheduleSyncDelayedTask(() -> result.accept(SeasonsAPI.getInstance()), 1L);
            }
        } else {
            throw new ModifierLoadException("Failed to find RealisticSeasons");
        }
    }

    public static Season getSeason(String world) {
        return LOADED_SEASONS.get(world);
    }

    private void loadSeason(SeasonType type, String world) {
        Season season = this.getSeason(type);
        LOADED_SEASONS.put(world, season);
    }

    private Season getSeason(SeasonType type) {
        String season = this.matchConfig(type);
        if (season == null) {
            return new Season("null", "null", type);
        }
        String icon = ConfigManager.getConfig().getString("seasonal-lore." + season + ".icon", "null");
        String name = ConfigManager.getConfig().getString("seasonal-lore." + season + ".name", "null");
        return new Season(this.plugin.formatColors(icon), this.plugin.formatColors(name), type);
    }

    private void loadModifiers(EconomyShopGUI plugin) {
        SendMessage.infoMessage(Lang.LOADING_SEASON_MODIFIERS.get());
        for (World world : plugin.getServer().getWorlds()) {
            String season;
            SeasonType sType;
            int i = 0;
            if (world.getEnvironment() == World.Environment.NETHER || world.getEnvironment() == World.Environment.THE_END || (sType = SeasonType.get(this.api.getSeason(world))) == null || sType == SeasonType.DISABLED || (season = this.matchConfig(sType)) == null) continue;
            for (String shop : ConfigManager.getConfig().getConfigurationSection("season-price-modifiers." + season).getKeys(false)) {
                if (ConfigManager.getConfig().getConfigurationSection("season-price-modifiers." + season + "." + shop) != null) {
                    for (String item : ConfigManager.getConfig().getConfigurationSection("season-price-modifiers." + season + "." + shop).getKeys(false)) {
                        int modifier;
                        String path = shop + "." + item.replace(":", ".");
                        if (!this.existsSoft(path) || (modifier = this.getModifier("season-price-modifiers." + season + "." + shop + "." + item)) == 0) continue;
                        ++i;
                        this.LOADED_MODIFIERS.put(path, this.LOADED_MODIFIERS.getOrDefault(path, new SeasonModifiers()).append(new SeasonModifier(world.getName(), modifier)));
                        this.loadSeason(sType, world.getName());
                    }
                    continue;
                }
                SendMessage.warnMessage("Failed to load season modifier %path%".replace("%path%", season + "." + shop));
            }
            if (i != 0) {
                SendMessage.infoMessage(Lang.LOADED_SEASON_MODIFIERS.get().replace("%total%", String.valueOf(i)).replace("%season%", sType.name()).replace("%world%", world.getName()));
                continue;
            }
            SendMessage.warnMessage(Lang.NO_SEASON_MODIFIERS_FOUND.get().replace("%season%", sType.name()));
        }
        this.enableModifiers();
        this.ready = true;
    }

    private void enableModifiers() {
        for (String path : this.LOADED_MODIFIERS.keySet()) {
            try {
                SeasonModifiers modifiers = this.LOADED_MODIFIERS.get(path);
                if (path.split("\\.").length == 4) {
                    this.plugin.getSection(path.split("\\.")[0]).getShopItem(path).addPriceModifiers(modifiers);
                    continue;
                }
                if (path.split("\\.")[1].equalsIgnoreCase("all")) {
                    ShopSection section = this.plugin.getSection(path.split("\\.")[0]);
                    section.getShopItems().forEach(i -> i.addPriceModifiers(modifiers));
                    continue;
                }
                throw new NullPointerException();
            }
            catch (NullPointerException e) {
                SendMessage.warnMessage(Lang.CANNOT_LOAD_SEASON_MODIFIER.get().replace("%path%", path));
            }
        }
    }

    private void disableModifiers(Map<String, SeasonModifier> modifiers) {
        for (String path : modifiers.keySet()) {
            try {
                SeasonModifier modifier = modifiers.get(path);
                if (path.split("\\.").length == 4) {
                    this.plugin.getSection(path.split("\\.")[0]).getShopItem(path).removePriceModifier(modifier);
                    LOADED_SEASONS.remove(path);
                    continue;
                }
                ShopSection section = this.plugin.getSection(path.split("\\.")[0]);
                section.getShopItems().forEach(i -> i.removePriceModifier(modifier));
                LOADED_SEASONS.remove(modifier.getWorld());
            }
            catch (NullPointerException e) {
                SendMessage.warnMessage("Failed to disable season modifier for '" + path + "' because there was no loaded section/item found.");
            }
        }
    }

    public boolean hasModifier(String itemPath) {
        if (!this.ready) {
            return false;
        }
        for (String season : ConfigManager.getConfig().getConfigurationSection("season-price-modifiers").getKeys(false)) {
            SeasonType sType = SeasonType.getFromString(season);
            if (sType != null) continue;
            for (String item : ConfigManager.getConfig().getConfigurationSection("season-price-modifiers." + season).getKeys(false)) {
                if (item.contains("\\.")) {
                    if (!item.equals(itemPath)) continue;
                } else if (!item.equals(itemPath.split("\\.")[0])) continue;
                int modifier = this.getModifier("season-price-modifiers." + season + "." + item);
                if (modifier == 0) continue;
                return true;
            }
        }
        return false;
    }

    private String matchConfig(SeasonType sType) {
        for (String season : ConfigManager.getConfig().getConfigurationSection("season-price-modifiers").getKeys(false)) {
            if (!sType.name().equalsIgnoreCase(season)) continue;
            return season;
        }
        return null;
    }

    private int getModifier(String path) {
        String modifier = ConfigManager.getConfig().getString(path, null);
        if (modifier == null) {
            SendMessage.errorMessage(Lang.INVALID_SEASON_MODIFIER.get().replace("%path%", path).replace("%current%", ConfigManager.getConfig().get(path) + ""));
            return 0;
        }
        modifier = modifier.replace("%", "");
        try {
            int m = Integer.parseInt(modifier);
            if (m <= 100 && m >= -100) {
                return m;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        SendMessage.errorMessage(Lang.INVALID_SEASON_MODIFIER.get().replace("%path%", path).replace("%current%", ConfigManager.getConfig().get(path) + ""));
        return 0;
    }

    private boolean exists(String path) {
        if (this.plugin.getShopSections().contains(path.split("\\.")[0]) && (path.split("\\.").length == 4 ? this.plugin.getSection(path.split("\\.")[1]).getShopItem(path) != null : path.split("\\.")[1].equalsIgnoreCase("all"))) {
            return true;
        }
        SendMessage.warnMessage(Lang.CANNOT_LOAD_SEASON_MODIFIER.get().replace("%path%", path));
        return false;
    }

    private boolean existsSoft(String path) {
        if (this.plugin.getShopSections().contains(path.split("\\.")[0]) && (path.split("\\.").length == 4 ? this.plugin.getConfigManager().getItemsRaw(path.split("\\.")[0]).contains(path.split("\\.")[1] + "." + path.split("\\.")[2] + "." + path.split("\\.")[3]) : path.split("\\.")[1].equalsIgnoreCase("all"))) {
            return true;
        }
        SendMessage.warnMessage(Lang.CANNOT_LOAD_SEASON_MODIFIER.get().replace("%path%", path));
        return false;
    }

    private void loadNewSeasonModifiers(World world, SeasonType sType) {
        String season = this.matchConfig(sType);
        if (season == null) {
            return;
        }
        int i = 0;
        for (String shop : ConfigManager.getConfig().getConfigurationSection("season-price-modifiers." + season).getKeys(false)) {
            for (String item : ConfigManager.getConfig().getConfigurationSection("season-price-modifiers." + season + "." + shop).getKeys(false)) {
                int modifier;
                String path = shop + "." + item.replace(":", ".");
                if (!this.exists(path) || (modifier = this.getModifier("season-price-modifiers." + season + "." + shop + "." + item)) == 0) continue;
                ++i;
                SeasonModifier sModifier = new SeasonModifier(world.getName(), modifier);
                this.LOADED_MODIFIERS.put(path, this.LOADED_MODIFIERS.getOrDefault(path, new SeasonModifiers()).append(sModifier));
                this.loadSeason(sType, world.getName());
            }
        }
        if (i != 0) {
            SendMessage.infoMessage(Lang.LOADED_SEASON_MODIFIERS.get().replace("%total%", String.valueOf(i)).replace("%season%", sType.name()).replace("%world%", world.getName()));
        } else {
            SendMessage.warnMessage(Lang.NO_SEASON_MODIFIERS_FOUND.get().replace("%season%", sType.name()));
        }
    }

    public void reloadModifiers() {
        this.LOADED_MODIFIERS.clear();
        LOADED_SEASONS.clear();
        this.loadModifiers(this.plugin);
    }

    @EventHandler
    public void onSeasonChange(SeasonChangeEvent e) {
        if (e.isCancelled()) {
            return;
        }
        World world = e.getWorld();
        SeasonType sType = SeasonType.get(e.getNewSeason());
        SendMessage.infoMessage(Lang.SEASON_CHANGE.get().replace("%world%", world.getName()).replace("%season%", e.getNewSeason().name()));
        this.loadSeason(sType, world.getName());
        HashMap<String, SeasonModifier> list = new HashMap<String, SeasonModifier>();
        for (Map.Entry<String, SeasonModifiers> entry2 : this.LOADED_MODIFIERS.entrySet()) {
            SeasonModifier modifier = entry2.getValue().getByWorld(world.getName());
            if (modifier == null) continue;
            list.put(entry2.getKey(), modifier);
        }
        this.disableModifiers(list);
        list.entrySet().forEach(entry -> this.LOADED_MODIFIERS.get(entry.getKey()).removeByWorld(((SeasonModifier)entry.getValue()).getWorld()));
        if (sType == SeasonType.DISABLED) {
            return;
        }
        this.loadNewSeasonModifiers(world, sType);
        this.enableModifiers();
    }

    private class SeasonModifiers
    extends ArrayList<SeasonModifier> {
        public SeasonModifiers append(SeasonModifier modifier) {
            this.add(modifier);
            return this;
        }

        public SeasonModifier getByWorld(String world) {
            for (SeasonModifier modifier : this) {
                if (!modifier.getWorld().equals(world)) continue;
                return modifier;
            }
            return null;
        }

        public boolean removeByWorld(String world) {
            for (SeasonModifier modifier : this) {
                if (!modifier.getWorld().equals(world)) continue;
                return this.remove(modifier);
            }
            return false;
        }
    }
}

