/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.util;

import me.gypopo.economyshopgui.util.EcoType;

public enum EconomyType {
    EXP("EXP"),
    ITEM("Item"),
    VAULT("Vault"),
    LEVELS("Levels"),
    ECOBITS("EcoBits"),
    COINS_ENGINE("CoinsEngine"),
    PLAYER_POINTS("PlayerPoints"),
    GEMS_ECONOMY("GemsEconomy"),
    ULTRA_ECONOMY("UltraEconomy");

    private final String name;

    private EconomyType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static EcoType getFromString(String type) {
        EcoType economyType;
        if (type == null) {
            return null;
        }
        switch (type.split(":")[0]) {
            case "PLAYER_POINTS": {
                economyType = new EcoType(PLAYER_POINTS);
                break;
            }
            case "VAULT": {
                economyType = new EcoType(VAULT);
                break;
            }
            case "COINS_ENGINE": {
                if (type.contains(":")) {
                    economyType = new EcoType(COINS_ENGINE, type.split(":")[1]);
                    break;
                }
                economyType = new EcoType(COINS_ENGINE);
                break;
            }
            case "GEMS_ECONOMY": {
                if (type.contains(":")) {
                    economyType = new EcoType(GEMS_ECONOMY, type.split(":")[1]);
                    break;
                }
                economyType = new EcoType(GEMS_ECONOMY);
                break;
            }
            case "ULTRA_ECONOMY": {
                if (type.contains(":")) {
                    economyType = new EcoType(ULTRA_ECONOMY, type.split(":")[1]);
                    break;
                }
                economyType = new EcoType(ULTRA_ECONOMY);
                break;
            }
            case "EXP": {
                economyType = new EcoType(EXP);
                break;
            }
            default: {
                economyType = null;
            }
        }
        return economyType;
    }
}

