/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.gypopo.economyshopgui.files.Lang;
import me.gypopo.economyshopgui.util.SkullUtil;
import me.gypopo.economyshopgui.util.XMaterial;
import me.gypopo.economyshopgui.util.exceptions.ItemLoadException;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilder {
    private ItemStack item;
    private ItemMeta meta;

    public ItemBuilder(ItemStack item) {
        this.item = new ItemStack(item);
        this.meta = item.getItemMeta();
    }

    public ItemBuilder(Material mat) {
        this.item = new ItemStack(mat);
        this.meta = this.item.getItemMeta();
    }

    public void setDisplayName(String s) {
        this.meta.setDisplayName(s);
    }

    public ItemBuilder withDisplayName(String s) {
        this.meta.setDisplayName(s);
        return this;
    }

    public ItemBuilder withLore(List<String> lore) {
        this.meta.setLore(lore);
        return this;
    }

    public void setLore(List<String> lore) {
        this.meta.setLore(lore);
    }

    public ItemBuilder addLore(List<String> lore) {
        List<String> list = this.meta.hasLore() ? this.meta.getLore() : new ArrayList();
        list.addAll(lore);
        this.meta.setLore(list);
        return this;
    }

    public ItemBuilder withLore(String ... lore) {
        this.meta.setLore(Arrays.asList(lore));
        return this;
    }

    public ItemBuilder removeLore() {
        this.meta.setLore(Collections.EMPTY_LIST);
        return this;
    }

    public ItemBuilder withEnchantGlint() {
        this.meta.addEnchant(Enchantment.WATER_WORKER, 1, false);
        return this.hideFlags();
    }

    public ItemBuilder removeEnchants() {
        for (Enchantment ench : this.meta.getEnchants().keySet()) {
            this.meta.removeEnchant(ench);
        }
        return this;
    }

    public ItemBuilder replaceText(String old, String value) {
        if (this.meta.hasDisplayName()) {
            this.meta.setDisplayName(this.meta.getDisplayName().replace(old, value));
        }
        if (this.meta.hasLore()) {
            this.meta.setLore(this.meta.getLore().stream().map(s -> s.replace(old, value)).collect(Collectors.toList()));
        }
        return this;
    }

    public ItemBuilder replaceName(String old, String value) {
        if (!this.meta.hasDisplayName()) {
            return this;
        }
        this.meta.setDisplayName(this.meta.getDisplayName().replace(old, value));
        return this;
    }

    public ItemBuilder replaceLore(String old, String value) {
        if (!this.meta.hasLore()) {
            return this;
        }
        this.meta.setLore(this.meta.getLore().stream().map(s -> s.replace(old, value)).collect(Collectors.toList()));
        return this;
    }

    public void setOwner(String owner) throws ItemLoadException {
        if (!this.item.getType().equals((Object)XMaterial.PLAYER_HEAD.parseMaterial())) {
            throw new ItemLoadException(Lang.MATERIAL_NEEDS_TO_BE_SKULL.get());
        }
        SkullUtil.setSkullTexture(this.item, (SkullMeta)this.meta, owner, false);
    }

    public void setTexture(String texture) throws ItemLoadException {
        if (!this.item.getType().equals((Object)XMaterial.PLAYER_HEAD.parseMaterial())) {
            throw new ItemLoadException(Lang.MATERIAL_NEEDS_TO_BE_SKULL.get());
        }
        SkullUtil.setSkullTextureFromHash((SkullMeta)this.meta, texture);
    }

    public ItemBuilder withSkullOwner(String owner) {
        SkullUtil.setSkullTexture(this.item, (SkullMeta)this.meta, owner, false);
        return this;
    }

    public ItemBuilder withSkullTexture(String texture) {
        SkullUtil.setSkullTextureFromHash((SkullMeta)this.meta, texture);
        return this;
    }

    public ItemBuilder setAmount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public ItemBuilder withAmount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public ItemBuilder hideFlags() {
        this.meta.addItemFlags(ItemFlag.values());
        return this;
    }

    public ItemBuilder setArmorColor(Color color) {
        LeatherArmorMeta meta = (LeatherArmorMeta)this.meta;
        meta.setColor(color);
        this.meta = meta;
        return this;
    }

    public ItemStack build() {
        this.item.setItemMeta(this.meta);
        return this.item;
    }
}

