/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.economyshopgui.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.gypopo.economyshopgui.EconomyShopGUI;
import me.gypopo.economyshopgui.files.SkullCache;
import me.gypopo.economyshopgui.methodes.SendMessage;
import me.gypopo.economyshopgui.util.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class SkullUtil {
    private static final String VALUE_PROPERTY = "{\"textures\":{\"SKIN\":";
    private static EconomyShopGUI plugin;
    private static SkullCache SKULL_CACHE;
    private static Method PROFILE_SETTER;
    private static Field PROFILE;
    private static Field VALUE;
    private static Field VAL;
    private static Field SIG;

    public SkullUtil(EconomyShopGUI plugin) {
        SKULL_CACHE = new SkullCache(plugin);
        SkullUtil.plugin = plugin;
    }

    public void saveCache() {
        SKULL_CACHE.write();
    }

    private static void getSkull(String name) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        OfflinePlayer p = Bukkit.getOfflinePlayer((String)name);
        GameProfile profile = new GameProfile(p.getUniqueId(), p.getName());
        SkullUtil.applySkullProfile(profile, meta);
        item.setItemMeta((ItemMeta)meta);
    }

    private static String getPost(String url) throws Exception {
        URL link = new URL(url);
        BufferedReader in = new BufferedReader(new InputStreamReader(link.openStream()));
        StringBuilder builder = new StringBuilder();
        for (String s : in.lines().collect(Collectors.toList())) {
            builder.append(s);
        }
        in.close();
        return builder.toString().replaceAll(" ", "");
    }

    private static void cache(Consumer<String> onComplete, ItemStack item, String name) {
        try {
            String result = SkullUtil.getPost("https://api.mojang.com/users/profiles/minecraft/" + name);
            String uuid = (String)((JSONObject)new JSONParser().parse(result)).get((Object)"id");
            String s = SkullUtil.getPost("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
            JSONObject property = (JSONObject)((JSONArray)((JSONObject)new JSONParser().parse(s)).get((Object)"properties")).get(0);
            onComplete.accept(SkullUtil.getTextureURL((String)property.get((Object)"value")));
        }
        catch (FileNotFoundException e) {
            onComplete.accept(" ");
        }
        catch (SocketException e) {
            SendMessage.logDebugMessage("Socket exception occurred while trying to retrieve skull texture for player '" + name + "', trying again in 5 seconds...");
            plugin.runTaskLaterAsync(() -> SkullUtil.cache(onComplete, item, name), 100L);
        }
        catch (UnknownHostException e) {
        }
        catch (Exception e) {
            SendMessage.warnMessage("Failed to retrieve skull texture for player '" + name + "'");
            e.printStackTrace();
        }
    }

    public static String getPlayerSkullTexture(Object data) {
        try {
            String v = new String(Base64.getDecoder().decode((String)VALUE.get(data)));
            JsonObject json = ((JsonObject)new Gson().fromJson(v, JsonObject.class)).get("textures").getAsJsonObject();
            json.get("SKIN").getAsJsonObject().remove("metadata");
            return Base64.getEncoder().encodeToString(("{\"textures\":" + json + "}").getBytes());
        }
        catch (Exception e) {
            SendMessage.errorMessage("Failed to get skull texture from item");
            e.printStackTrace();
            return null;
        }
    }

    private static GameProfile getSkullProfile(SkullMeta meta) {
        try {
            return (GameProfile)PROFILE.get(meta);
        }
        catch (Exception e) {
            SendMessage.errorMessage("Failed to get skull texture from item");
            e.printStackTrace();
            return null;
        }
    }

    public static String getSkullTexture(SkullMeta meta) {
        try {
            GameProfile profile = (GameProfile)PROFILE.get(meta);
            return SkullUtil.getSkullTexture(profile);
        }
        catch (Exception e) {
            SendMessage.errorMessage("Failed to get skull texture from item");
            e.printStackTrace();
            return null;
        }
    }

    private static String getSkullTexture(GameProfile profile) throws Exception {
        if (profile != null && !profile.getProperties().get((Object)"textures").isEmpty()) {
            for (Property property : profile.getProperties().get((Object)"textures")) {
                String value = SkullUtil.getValue(property);
                if (value.isEmpty()) continue;
                return value;
            }
        }
        return null;
    }

    public static String getTextureURL(String raw) {
        try {
            JSONObject data = (JSONObject)new JSONParser().parse(new String(Base64.getDecoder().decode(raw)));
            String url = ((JSONObject)data.get((Object)"textures")).get((Object)"SKIN").toString().replace("\\", "").replace("https://", "http://");
            return SkullUtil.encodeTexture(url);
        }
        catch (Exception e) {
            SendMessage.errorMessage("Failed to get skull texture from item");
            e.printStackTrace();
            return null;
        }
    }

    private static String encodeTexture(String url) {
        return Base64.getEncoder().encodeToString((VALUE_PROPERTY + url + "}}").getBytes());
    }

    public static boolean hasSkullOwner(SkullMeta meta) {
        try {
            GameProfile profile = (GameProfile)PROFILE.get(meta);
            if (profile != null && !profile.getProperties().get((Object)"textures").isEmpty()) {
                for (Property property : profile.getProperties().get((Object)"textures")) {
                    String signature = SkullUtil.getSignature(property);
                    if (signature == null || signature.isEmpty()) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            SendMessage.errorMessage("Failed to get skull owner from item " + meta.toString());
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isSimilarSkull(ItemStack item1, ItemStack item2) {
        return SkullUtil.getSkullTexture((SkullMeta)item1.getItemMeta()).equals(SkullUtil.getSkullTexture((SkullMeta)item2.getItemMeta()));
    }

    public static void setSkullTextureFromHash(SkullMeta sm, String base64) {
        GameProfile pr = new GameProfile(UUID.nameUUIDFromBytes(base64.getBytes(StandardCharsets.UTF_8)), sm.hasOwner() ? SkullUtil.getSkullProfile(sm).getName() : null);
        pr.getProperties().put((Object)"textures", (Object)new Property("textures", base64));
        SkullUtil.applySkullProfile(pr, sm);
    }

    public static void setSkullTexture(ItemStack stack, SkullMeta meta, String name, boolean async) {
        String texture = SKULL_CACHE.getSkull(name);
        if (texture == null) {
            Consumer<String> onComplete = s -> {
                SKULL_CACHE.cacheSkull(name, (String)s);
                plugin.scheduleSyncDelayedTask(() -> {
                    SkullMeta sm = (SkullMeta)stack.getItemMeta();
                    SkullUtil.setSkullTexture(sm, name, s);
                    stack.setItemMeta((ItemMeta)sm);
                }, 1L);
            };
            if (async) {
                plugin.runTaskLaterAsync(() -> SkullUtil.cache(onComplete, stack, name), 1L);
            } else {
                SkullUtil.cache(onComplete, stack, name);
            }
        } else if (meta == null) {
            SkullMeta sm = (SkullMeta)stack.getItemMeta();
            SkullUtil.setSkullTexture(sm, name, texture);
            stack.setItemMeta((ItemMeta)sm);
        } else {
            SkullUtil.setSkullTexture(meta, name, texture);
        }
    }

    public static void setSkullTexture(Consumer<GameProfile> onComplete, ItemStack stack, SkullMeta meta, String name) {
        String texture = SKULL_CACHE.getSkull(name);
        if (texture == null) {
            plugin.runTaskLaterAsync(() -> SkullUtil.cache(s -> {
                SKULL_CACHE.cacheSkull(name, (String)s);
                onComplete.accept(SkullUtil.getProfile(name, s));
            }, stack, name), 1L);
        } else if (meta == null) {
            SkullMeta sm = (SkullMeta)stack.getItemMeta();
            SkullUtil.setSkullTexture(sm, name, texture);
            stack.setItemMeta((ItemMeta)sm);
        } else {
            SkullUtil.setSkullTexture(meta, name, texture);
        }
    }

    private static void setSkullTexture(SkullMeta meta, String name, String texture) {
        SkullUtil.applySkullProfile(SkullUtil.getProfile(name, texture), meta);
    }

    private static GameProfile getProfile(String name, String texture) {
        GameProfile profile = new GameProfile(UUID.nameUUIDFromBytes(texture.getBytes(StandardCharsets.UTF_8)), name);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
        return profile;
    }

    private static GameProfile getProfile(String name) {
        OfflinePlayer owner = Bukkit.getOfflinePlayer((String)name);
        return new GameProfile(owner.getUniqueId(), owner.getName());
    }

    public static void setSkullTexture(GameProfile owner, SkullMeta meta, String base64) {
        owner.getProperties().put((Object)"textures", (Object)new Property("textures", base64));
        SkullUtil.applySkullProfile(owner, meta);
    }

    public static void applySkullProfile(GameProfile profile, SkullMeta sm) {
        try {
            if (PROFILE_SETTER != null) {
                PROFILE_SETTER.invoke((Object)sm, profile);
            } else {
                PROFILE.set(sm, profile);
            }
        }
        catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            SendMessage.logDebugMessage("Failed to create skull texture");
            e.printStackTrace();
        }
    }

    public static void updateTexture(Player p) {
        String texture = null;
        try {
            Method m = p.getClass().getDeclaredMethod(SkullUtil.plugin.version > 117 ? "getPlayerProfile" : "getProfile", new Class[0]);
            m.setAccessible(true);
            if (SkullUtil.plugin.version > 117) {
                String url = ((PlayerProfile)m.invoke((Object)p, new Object[0])).getTextures().getSkin().toString();
                if (url == null) {
                    return;
                }
                texture = SkullUtil.encodeTexture("{\"url\":\"" + url + "\"}");
            } else {
                texture = SkullUtil.getSkullTexture((GameProfile)m.invoke((Object)p, new Object[0]));
                if (texture == null) {
                    return;
                }
                texture = SkullUtil.getTextureURL(texture);
            }
        }
        catch (Exception m) {
            // empty catch block
        }
        if (texture == null) {
            return;
        }
        SkullCache.PlayerTexture cached = SKULL_CACHE.getTexture(p.getName());
        if (cached == null) {
            SKULL_CACHE.cacheSkull(p.getName(), texture);
            return;
        }
        try {
            if (!texture.equalsIgnoreCase(cached.getTexture())) {
                SendMessage.logDebugMessage("Detected skin change of " + p.getName() + ", updating cached skin...");
                SKULL_CACHE.cacheSkull(p.getName(), texture);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private static String getValue(Property prop) {
        try {
            return (String)VAL.get(prop);
        }
        catch (IllegalAccessException e) {
            SendMessage.warnMessage("A error occurred while reading skull");
            e.printStackTrace();
            return "";
        }
    }

    private static String getSignature(Property prop) {
        try {
            return (String)SIG.get(prop);
        }
        catch (IllegalAccessException e) {
            SendMessage.warnMessage("A error occurred while reading skull");
            e.printStackTrace();
            return null;
        }
    }

    static {
        PROFILE_SETTER = null;
        SkullMeta meta = (SkullMeta)new ItemStack(XMaterial.PLAYER_HEAD.parseMaterial()).getItemMeta();
        try {
            PROFILE_SETTER = meta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
            PROFILE_SETTER.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        Property property = new Property("", "");
        try {
            VAL = property.getClass().getDeclaredField("value");
            VAL.setAccessible(true);
            SIG = property.getClass().getDeclaredField("signature");
            SIG.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException ex) {
            ex.printStackTrace();
        }
        try {
            PROFILE = meta.getClass().getDeclaredField("profile");
            PROFILE.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException ex) {
            ex.printStackTrace();
        }
    }
}

