/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.command.function;

import cn.handyplus.warp.PlayerWarp;
import cn.handyplus.warp.enter.WarpPlayer;
import cn.handyplus.warp.lib.command.IHandyCommandEvent;
import cn.handyplus.warp.lib.util.AssertUtil;
import cn.handyplus.warp.lib.util.BaseUtil;
import cn.handyplus.warp.lib.util.ItemStackUtil;
import cn.handyplus.warp.lib.util.MessageUtil;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.util.ConfigUtil;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SetLogoCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "setLogo";
    }

    @Override
    public String permission() {
        return "playerWarp.setLogo";
    }

    @Override
    public void onCommand(final CommandSender sender, Command cmd, String label, String[] args) {
        ItemMeta itemMeta;
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getLangMsg("paramFailureMsg"));
        final Integer id = AssertUtil.isNumericToInt(args[1], sender, BaseUtil.getLangMsg("amountFailureMsg"));
        final Player player = AssertUtil.notPlayer(sender, BaseUtil.getLangMsg("noPlayerFailureMsg"));
        ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(player.getInventory());
        if ((itemInMainHand == null || Material.AIR.equals((Object)itemInMainHand.getType())) && (itemMeta = (itemInMainHand = new ItemStack(ItemStackUtil.getMaterial("PLAYER_HEAD"))).getItemMeta()) instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)itemMeta;
            skullMeta.setOwner(player.getName());
            itemInMainHand.setItemMeta((ItemMeta)skullMeta);
        }
        ItemStack clone = itemInMainHand.clone();
        clone.setAmount(1);
        final String logoName = ItemStackUtil.itemStackSerialize(clone);
        new BukkitRunnable(){

            public void run() {
                Optional<WarpPlayer> warpPlayerOptional = WarpPlayerService.getInstance().findById(id);
                if (!warpPlayerOptional.isPresent()) {
                    return;
                }
                WarpPlayer warpPlayer = warpPlayerOptional.get();
                if (!warpPlayer.getCreator().equals(player.getName())) {
                    MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("failureMsg"));
                    return;
                }
                warpPlayer.setLogoName(logoName);
                WarpPlayerService.getInstance().update(warpPlayer);
                MessageUtil.sendMessage(player, ConfigUtil.ADMIN_CONFIG.getString("okLogoButton"));
            }
        }.runTaskAsynchronously((Plugin)PlayerWarp.getInstance());
    }
}

