/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.inventory;

import cn.handyplus.warp.constants.GuiTypeEnum;
import cn.handyplus.warp.constants.WarpTypeEnum;
import cn.handyplus.warp.enter.WarpPlayer;
import cn.handyplus.warp.hook.PlaceholderApiUtil;
import cn.handyplus.warp.hook.VaultUtil;
import cn.handyplus.warp.lib.core.MapUtil;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.inventory.HandyInventoryUtil;
import cn.handyplus.warp.param.OpenParam;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.util.ConfigUtil;
import cn.handyplus.warp.util.WarpUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class AdminGui {
    private static final AdminGui INSTANCE = new AdminGui();

    private AdminGui() {
    }

    public static AdminGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id, OpenParam openParam) {
        String title = ConfigUtil.ADMIN_CONFIG.getString("title");
        int size = ConfigUtil.ADMIN_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.ADMIN.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        handyInventory.setObj(openParam);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.ADMIN.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Optional<WarpPlayer> warpPlayerOptional = WarpPlayerService.getInstance().findById(handyInventory.getId());
        if (!warpPlayerOptional.isPresent()) {
            return;
        }
        WarpPlayer warpPlayer = warpPlayerOptional.get();
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_CONFIG, inventory, "delete");
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_CONFIG, inventory, "logo", this.getReplaceMap(warpPlayer, player, "logo"));
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_CONFIG, inventory, "location", this.getReplaceMap(warpPlayer, player, "location"));
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_CONFIG, inventory, "name", this.getReplaceMap(warpPlayer, player, "name"));
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_CONFIG, inventory, "description", this.getReplaceMap(warpPlayer, player, "description"), WarpUtil.getDescriptionMap(warpPlayer.getDescription()));
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_CONFIG, inventory, "price", this.getReplaceMap(warpPlayer, player, "price"));
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_CONFIG, inventory, "type", this.getReplaceMap(warpPlayer, player, "type"));
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_CONFIG, inventory, "display", this.getReplaceMap(warpPlayer, player, "display"));
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_CONFIG, inventory, "tp");
        HandyInventoryUtil.setButton(ConfigUtil.ADMIN_CONFIG, inventory, "pane");
    }

    private Map<String, String> getReplaceMap(WarpPlayer warpPlayer, Player player, String type) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(9);
        map.put("name", PlaceholderApiUtil.set(player, warpPlayer.getName()));
        int price = ConfigUtil.ADMIN_CONFIG.getInt(type + ".price", 0);
        map.put("price", String.valueOf(price));
        double playerVault = VaultUtil.getPlayerVault(player);
        map.put("myPrice", String.valueOf((int)playerVault));
        String button = ConfigUtil.ADMIN_CONFIG.getString(playerVault >= (double)price ? "yesButton" : "noButton");
        map.put("button", button);
        map.put("location", WarpUtil.getLocationDesc(warpPlayer.getWarpLocation()));
        map.put("warpPrice", warpPlayer.getPrice().toString());
        map.put("type", WarpTypeEnum.getDesc(warpPlayer.getType()));
        map.put("display", ConfigUtil.ADMIN_CONFIG.getString(warpPlayer.getDisplay() != false ? "yesDisplay" : "noDisplay"));
        map.put("nextType", WarpTypeEnum.getDesc(WarpTypeEnum.getNotAllNextEnum(warpPlayer.getType())));
        return map;
    }
}

