/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib.inventory;

import cn.handyplus.warp.lib.InitApi;
import cn.handyplus.warp.lib.core.CollUtil;
import cn.handyplus.warp.lib.core.LockUtil;
import cn.handyplus.warp.lib.exception.HandyException;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.inventory.HandyInventoryListener;
import cn.handyplus.warp.lib.inventory.HandyInventoryUtil;
import cn.handyplus.warp.lib.inventory.IHandyClickEvent;
import cn.handyplus.warp.lib.param.InventoryCheckParam;
import cn.handyplus.warp.lib.util.BaseUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HandyClickFactory {
    private static final HandyClickFactory INSTANCE = new HandyClickFactory();
    private static final Map<String, IHandyClickEvent> HANDY_CLICK_EVENT_MAP = new HashMap<String, IHandyClickEvent>();

    private HandyClickFactory() {
    }

    public static HandyClickFactory getInstance() {
        return INSTANCE;
    }

    public void init(List<IHandyClickEvent> handyClickEvents) {
        if (CollUtil.isEmpty(handyClickEvents)) {
            return;
        }
        for (IHandyClickEvent handyClickEvent : handyClickEvents) {
            HANDY_CLICK_EVENT_MAP.put(handyClickEvent.guiType(), handyClickEvent);
        }
        InitApi.PLUGIN.getServer().getPluginManager().registerEvents((Listener)new HandyInventoryListener(), (Plugin)InitApi.PLUGIN);
    }

    public InventoryCheckParam inventoryCheck(InventoryClickEvent event) {
        InventoryCheckParam inventoryCheckParam = new InventoryCheckParam();
        inventoryCheckParam.setCheck(false);
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof HandyInventory)) {
            return inventoryCheckParam;
        }
        HandyInventory handyInventory = (HandyInventory)holder;
        Optional<Player> optionalPlayer = HandyInventoryUtil.getPlayer(event);
        if (!optionalPlayer.isPresent()) {
            return inventoryCheckParam;
        }
        if (event.getClick().isShiftClick() || event.getClick().isKeyboardClick()) {
            event.setCancelled(handyInventory.isToCancel());
            return inventoryCheckParam;
        }
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null || Material.AIR.equals((Object)currentItem.getType())) {
            event.setCancelled(handyInventory.isToCancel());
            return inventoryCheckParam;
        }
        if (event.isCancelled()) {
            return inventoryCheckParam;
        }
        handyInventory.setPlayer(optionalPlayer.get());
        inventoryCheckParam.setCheck(true);
        inventoryCheckParam.setHandyInventory(handyInventory);
        return inventoryCheckParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        IHandyClickEvent handyClickEvent = HANDY_CLICK_EVENT_MAP.get(handyInventory.getGuiType());
        if (handyClickEvent == null) {
            return;
        }
        UUID uniqueId = handyInventory.getPlayer().getUniqueId();
        try {
            AtomicInteger lock = LockUtil.lock(uniqueId);
            if (lock.get() != 1) {
                return;
            }
            boolean timeLock = LockUtil.timeLock(uniqueId);
            if (!timeLock) {
                return;
            }
            handyClickEvent.rawSlotClick(handyInventory, event);
        }
        catch (HandyException exception) {
            if (event.getWhoClicked() instanceof Player) {
                HumanEntity whoClicked = event.getWhoClicked();
                whoClicked.sendMessage(BaseUtil.replaceChatColor(exception.getMessage()));
            }
        }
        finally {
            LockUtil.unLock(uniqueId);
        }
    }
}

