/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib.util;

import java.util.Random;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;

public class FireworkEffectUtil {
    private final FireworkEffect.Builder fb = FireworkEffect.builder();
    private final Random r = new Random();
    private FireworkEffect f;

    public static void spawnFireworkToPlayer(Player player) {
        new FireworkEffectUtil().setType().setColor().isRandomWithFade(3).isRandomWithFlicker(3).isRandomWithTrail(3).spawnEntity(player);
    }

    public static void spawnFireworkToLocation(Location location) {
        new FireworkEffectUtil().setType().setColor().isRandomWithFade(3).isRandomWithFlicker(3).isRandomWithTrail(3).spawnEntity(location);
    }

    public FireworkEffectUtil setColor() {
        this.fb.withColor(Color.fromRGB((int)this.r.nextInt(255), (int)this.r.nextInt(255), (int)this.r.nextInt(255)));
        return this;
    }

    public FireworkEffectUtil setColor(Color color) {
        this.fb.withColor(color);
        return this;
    }

    public FireworkEffectUtil setType() {
        FireworkEffect.Type[] types = FireworkEffect.Type.values();
        this.fb.with(types[this.r.nextInt(types.length)]);
        return this;
    }

    public FireworkEffectUtil setType(FireworkEffect.Type type) {
        this.fb.with(type);
        return this;
    }

    public FireworkEffectUtil isWithTrail() {
        this.fb.withTrail();
        return this;
    }

    public FireworkEffectUtil isRandomWithTrail(int random) {
        if (this.r.nextInt(random) == 0) {
            this.fb.withTrail();
        }
        return this;
    }

    public FireworkEffectUtil isWithFade() {
        this.fb.withFade(Color.fromRGB((int)this.r.nextInt(255), (int)this.r.nextInt(255), (int)this.r.nextInt(255)));
        return this;
    }

    public FireworkEffectUtil isRandomWithFade(int random) {
        if (this.r.nextInt(random) == 0) {
            this.fb.withFade(Color.fromRGB((int)this.r.nextInt(255), (int)this.r.nextInt(255), (int)this.r.nextInt(255)));
        }
        return this;
    }

    public FireworkEffectUtil isRandomWithFade(int random, Color color) {
        if (this.r.nextInt(random) == 0) {
            this.fb.withFade(color);
        }
        return this;
    }

    public FireworkEffectUtil isWithFlicker() {
        this.fb.withFlicker();
        return this;
    }

    public FireworkEffectUtil isRandomWithFlicker(int random) {
        if (this.r.nextInt(random) == 0) {
            this.fb.withFlicker();
        }
        return this;
    }

    public FireworkEffectUtil builder() {
        this.f = this.fb.build();
        return this;
    }

    public void spawnEntity(Player player) {
        this.spawnEntity(player.getLocation());
    }

    public void spawnEntity(Location location) {
        if (location.getWorld() == null) {
            return;
        }
        Firework fw = (Firework)location.getWorld().spawnEntity(location, EntityType.FIREWORK);
        FireworkMeta fwm = fw.getFireworkMeta();
        fwm.clearEffects();
        fwm.addEffect(this.f);
        fwm.setPower(0);
        fw.setFireworkMeta(fwm);
        fw.setVelocity(location.getDirection().multiply(0.5));
    }
}

