/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.listener.gui;

import cn.handyplus.warp.PlayerWarp;
import cn.handyplus.warp.constants.GuiTypeEnum;
import cn.handyplus.warp.enter.WarpLikePlayer;
import cn.handyplus.warp.hook.PlayerPointsUtil;
import cn.handyplus.warp.hook.VaultUtil;
import cn.handyplus.warp.inventory.LikeGui;
import cn.handyplus.warp.inventory.OpenGui;
import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.inventory.HandyInventoryUtil;
import cn.handyplus.warp.lib.inventory.IHandyClickEvent;
import cn.handyplus.warp.lib.util.MessageUtil;
import cn.handyplus.warp.param.OpenParam;
import cn.handyplus.warp.service.WarpCollectionService;
import cn.handyplus.warp.service.WarpLikePlayerService;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.util.ConfigUtil;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WarpLikeClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.LIKE.getType();
    }

    @Override
    public void rawSlotClick(final HandyInventory handyInventory, InventoryClickEvent event) {
        final int rawSlot = event.getRawSlot();
        final Player player = handyInventory.getPlayer();
        final Integer id = handyInventory.getId();
        final OpenParam openParam = (OpenParam)handyInventory.getObj();
        new BukkitRunnable(){

            public void run() {
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIKE_CONFIG, "back")) {
                    Inventory inventory = OpenGui.getInstance().createGui(player, openParam);
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                    return;
                }
                Map<Integer, String> custom = HandyInventoryUtil.getCustomButton(ConfigUtil.LIKE_CONFIG, "custom");
                String command = custom.get(rawSlot);
                if (StrUtil.isNotEmpty(command)) {
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.chat("/" + command.trim()));
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIKE_CONFIG, "collection")) {
                    WarpCollectionService.getInstance().collection(player, id);
                    Inventory inventory = LikeGui.getInstance().createGui(player, id, openParam);
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIKE_CONFIG, "top")) {
                    WarpLikeClickEvent.this.top(handyInventory, "top");
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIKE_CONFIG, "stepOn")) {
                    WarpLikeClickEvent.this.top(handyInventory, "stepOn");
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIKE_CONFIG, "pointTop")) {
                    WarpLikeClickEvent.this.top(handyInventory, "pointTop");
                    return;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIKE_CONFIG, "pointStepOn")) {
                    WarpLikeClickEvent.this.top(handyInventory, "pointStepOn");
                    return;
                }
                WarpLikePlayer warpLikePlayer = new WarpLikePlayer();
                warpLikePlayer.setWarpPlayerId(id);
                warpLikePlayer.setPlayerName(player.getName());
                warpLikePlayer.setPlayerUuid(player.getUniqueId().toString());
                int like = 0;
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIKE_CONFIG, "one")) {
                    like = 1;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIKE_CONFIG, "two")) {
                    like = 2;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIKE_CONFIG, "three")) {
                    like = 3;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIKE_CONFIG, "four")) {
                    like = 4;
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIKE_CONFIG, "five")) {
                    like = 5;
                }
                if (like < 1) {
                    return;
                }
                warpLikePlayer.setLike(like);
                WarpLikePlayerService.getInstance().add(warpLikePlayer);
                MessageUtil.sendMessage(player, ConfigUtil.LIKE_CONFIG.getString("likeSucceedMsg"));
                Inventory inventory = OpenGui.getInstance().createGui(player, openParam);
                Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
            }
        }.runTaskAsynchronously((Plugin)PlayerWarp.getInstance());
    }

    private void top(HandyInventory handyInventory, String type) {
        Player player = handyInventory.getPlayer();
        Integer id = handyInventory.getId();
        OpenParam openParam = (OpenParam)handyInventory.getObj();
        int price = ConfigUtil.LIKE_CONFIG.getInt(type + ".price", 0);
        boolean rst = false;
        rst = "pointTop".equals(type) || "pointStepOn".equals(type) ? PlayerPointsUtil.buy(player, price) : VaultUtil.buy(player, price);
        if (!rst) {
            MessageUtil.sendMessage(player, ConfigUtil.LIKE_CONFIG.getString("noButton"));
            return;
        }
        if ("top".equals(type) || "pointTop".equals(type)) {
            WarpPlayerService.getInstance().addThermalValue(id, 1);
        } else {
            WarpPlayerService.getInstance().subtractThermalValue(id, 1);
        }
        Inventory inventory = LikeGui.getInstance().createGui(player, id, openParam);
        Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
    }
}

