/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.service;

import cn.handyplus.warp.enter.WarpChannel;
import cn.handyplus.warp.lib.db.Db;
import java.util.List;
import java.util.Optional;

public class WarpChannelService {
    private WarpChannelService() {
    }

    public static WarpChannelService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(WarpChannel warpChannel) {
        return Db.use(WarpChannel.class).execution().insert(warpChannel);
    }

    public void delById(Integer id) {
        Db.use(WarpChannel.class).execution().deleteById(id);
    }

    public Optional<WarpChannel> findByPlayerNameAndServerName(String playerName, String serverName) {
        Db<WarpChannel> db = Db.use(WarpChannel.class);
        db.where().eq(WarpChannel::getPlayerName, playerName).eq(WarpChannel::getServerName, serverName);
        return db.execution().selectOne();
    }

    public List<WarpChannel> findAll() {
        return Db.use(WarpChannel.class).execution().list();
    }

    private static class SingletonHolder {
        private static final WarpChannelService INSTANCE = new WarpChannelService();

        private SingletonHolder() {
        }
    }
}

