/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.command.admin;

import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.constants.RarityEnum;
import com.handy.playertask.constants.RewardTypeEnum;
import com.handy.playertask.constants.TaskTypeEnum;
import com.handy.playertask.inventory.ViewDemandGui;
import com.handy.playertask.inventory.ViewListGui;
import com.handy.playertask.inventory.ViewNpcGui;
import com.handy.playertask.inventory.ViewRewardsGui;
import com.handy.playertask.inventory.ViewShopGui;
import com.handy.playertask.lib.command.IHandyCommandEvent;
import com.handy.playertask.lib.util.AssertUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.MessageUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class ViewCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "view";
    }

    @Override
    public String permission() {
        return "playerTask.view";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Inventory inventory;
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        switch (args[1].toLowerCase()) {
            case "list": {
                inventory = ViewListGui.getInstance().createGui(player, TaskTypeEnum.ALL.getType(), RarityEnum.ALL.getType());
                break;
            }
            case "demand": {
                inventory = ViewDemandGui.getInstance().createGui(player, DemandTypeEnum.ALL.getType());
                break;
            }
            case "reward": {
                inventory = ViewRewardsGui.getInstance().createGui(player, RewardTypeEnum.ALL.getType());
                break;
            }
            case "npc": {
                inventory = ViewNpcGui.getInstance().createGui(player);
                break;
            }
            case "shop": {
                inventory = ViewShopGui.getInstance().createGui(player);
                break;
            }
            default: {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                return;
            }
        }
        player.openInventory(inventory);
    }
}

