/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.constants;

import com.handy.playertask.lib.util.BaseUtil;
import java.util.ArrayList;
import java.util.List;

public enum RewardTypeEnum {
    ALL("all", 0),
    VAULT("vault", 1),
    PLAYER_POINTS("playerPoints", 2),
    COIN("coin", 3),
    ITEM_STACK("itemStack", 4),
    COMMAND("command", 5);

    private final String type;
    private final Integer typeId;

    public static RewardTypeEnum getEnumThrow(String type) {
        for (RewardTypeEnum rewardTypeEnum : RewardTypeEnum.values()) {
            if (!rewardTypeEnum.getType().equalsIgnoreCase(type)) continue;
            return rewardTypeEnum;
        }
        throw new RuntimeException("\u9519\u8bef\u7684\u5956\u52b1\u7c7b\u578b(error Reward Type):" + type);
    }

    public static List<String> getEnumNotAll() {
        ArrayList<String> enumList = new ArrayList<String>();
        for (RewardTypeEnum rewardTypeEnum : RewardTypeEnum.values()) {
            if (ALL.equals((Object)rewardTypeEnum)) continue;
            enumList.add(rewardTypeEnum.getType());
        }
        return enumList;
    }

    public static String getTypeName(String type) {
        for (RewardTypeEnum rewardTypeEnum : RewardTypeEnum.values()) {
            if (!rewardTypeEnum.getType().equals(type)) continue;
            return BaseUtil.getMsgNotColor("reward." + type);
        }
        return null;
    }

    public static RewardTypeEnum getNextEnum(String name) {
        RewardTypeEnum anEnum = RewardTypeEnum.getEnumThrow(name);
        int num = anEnum.getTypeId() + 1;
        if (num > RewardTypeEnum.COMMAND.typeId) {
            num = 0;
        }
        for (RewardTypeEnum rewardTypeEnum : RewardTypeEnum.values()) {
            if (rewardTypeEnum.getTypeId() != num) continue;
            return rewardTypeEnum;
        }
        return ALL;
    }

    public String getType() {
        return this.type;
    }

    public Integer getTypeId() {
        return this.typeId;
    }

    private RewardTypeEnum(String type, Integer typeId) {
        this.type = type;
        this.typeId = typeId;
    }
}

