/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.hook;

import com.handy.playertask.PlayerTask;
import com.handy.playertask.lib.core.DateUtil;
import com.handy.playertask.service.TaskCoinService;
import com.handy.playertask.service.TaskPlayerService;
import com.handy.playertask.util.ConfigUtil;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;

public class PlaceholderUtil
extends PlaceholderExpansion {
    private final PlayerTask plugin;

    public PlaceholderUtil(PlayerTask plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "playerTask";
    }

    public String onRequest(OfflinePlayer player, String placeholder) {
        if (player == null) {
            return "";
        }
        if ("num".equals(placeholder)) {
            return ConfigUtil.CONFIG.getString("todayTaskNum", "10");
        }
        if ("complete_num".equals(placeholder)) {
            Integer completeCount = TaskPlayerService.getInstance().findCount(player.getUniqueId(), DateUtil.getToday(), true);
            return completeCount != null ? completeCount.toString() : "0";
        }
        if ("coin".equals(placeholder)) {
            return TaskCoinService.getInstance().findCoinByPlayer(player.getUniqueId()).toString();
        }
        return null;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }
}

