/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.inventory;

import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.constants.RarityEnum;
import com.handy.playertask.entity.TaskList;
import com.handy.playertask.entity.TaskNpc;
import com.handy.playertask.entity.TaskNpcPlayer;
import com.handy.playertask.hook.PlaceholderApiUtil;
import com.handy.playertask.lib.core.MapUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.db.enter.Page;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.service.TaskListService;
import com.handy.playertask.service.TaskNpcPlayerService;
import com.handy.playertask.service.TaskNpcService;
import com.handy.playertask.util.ConfigUtil;
import com.handy.playertask.util.TaskUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class TaskNpcGui {
    private static final TaskNpcGui INSTANCE = new TaskNpcGui();

    private TaskNpcGui() {
    }

    public static TaskNpcGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, int npcId) {
        String title = ConfigUtil.NPC_CONFIG.getString("title", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.NPC_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.TASK_NPC.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(npcId);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.TASK_NPC.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Integer npcId = handyInventory.getId();
        Player player = handyInventory.getPlayer();
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.NPC_CONFIG.getString("npc.index"));
        handyInventory.setPageSize(indexList.size());
        Page<TaskNpc> page = TaskNpcService.getInstance().pageByNpcId(npcId, handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        List<TaskNpc> taskNpcList = page.getRecords();
        List<Integer> taskIdList = taskNpcList.stream().map(TaskNpc::getTaskId).collect(Collectors.toList());
        List<TaskList> taskListList = TaskListService.getInstance().findDataByIds(taskIdList);
        Map<Integer, TaskList> taskListMap = taskListList.stream().collect(Collectors.toMap(TaskList::getId, v -> v));
        List<Integer> taskNpcIdList = taskNpcList.stream().map(TaskNpc::getId).collect(Collectors.toList());
        List<TaskNpcPlayer> taskNpcPlayerList = TaskNpcPlayerService.getInstance().findByPlayerAndTaskNpcId(player.getUniqueId(), taskNpcIdList);
        Map<Integer, TaskNpcPlayer> taskNpcPlayerMap = taskNpcPlayerList.stream().collect(Collectors.toMap(TaskNpcPlayer::getTaskNpcId, v -> v));
        int i = 0;
        String name = ConfigUtil.NPC_CONFIG.getString("npc.name", "");
        String material = ConfigUtil.NPC_CONFIG.getString("npc.material", "PAPER");
        String havaMaterial = ConfigUtil.NPC_CONFIG.getString("npc.havaMaterial", "BOOK");
        String doneMaterial = ConfigUtil.NPC_CONFIG.getString("npc.doneMaterial", "ENCHANTED_BOOK");
        String cdMaterial = ConfigUtil.NPC_CONFIG.getString("npc.cdMaterial", "HOPPER");
        List npcLore = ConfigUtil.NPC_CONFIG.getStringList("npc.lore");
        List scheduleLore = ConfigUtil.NPC_CONFIG.getStringList("npc.scheduleLore");
        int customModelData = ConfigUtil.NPC_CONFIG.getInt("npc.custom-model-data", 0);
        int havaCustomModelData = ConfigUtil.NPC_CONFIG.getInt("npc.hava-custom-model-data", 0);
        int doneCustomModelData = ConfigUtil.NPC_CONFIG.getInt("npc.done-custom-model-data", 0);
        int cdCustomModelData = ConfigUtil.NPC_CONFIG.getInt("npc.cd-custom-model-data", 0);
        for (TaskNpc taskNpc : taskNpcList) {
            TaskList taskList = taskListMap.get(taskNpc.getTaskId());
            TaskNpcPlayer taskNpcPlayer = taskNpcPlayerMap.get(taskNpc.getId());
            String itemName = StrUtil.replace(name, "taskName", taskList.getTaskName());
            List<Object> loreList = new ArrayList();
            String itemMaterial = material;
            int itemCustomModelData = customModelData;
            boolean isEnchant = false;
            if (taskNpcPlayer == null) {
                loreList = this.getTaskLore(player, npcLore, taskNpc, taskList);
            } else {
                boolean next = true;
                if (!taskNpcPlayer.getStatus().booleanValue()) {
                    itemMaterial = havaMaterial;
                    itemCustomModelData = havaCustomModelData;
                    loreList = ItemStackUtil.loreBatchReplaceMap(scheduleLore, this.getScheduleReplaceMap(taskNpcPlayer, player), "");
                    next = false;
                }
                if (next && taskNpc.getIsEver() != 1 && taskNpcPlayer.getNumber() >= taskNpc.getNumber()) {
                    itemMaterial = doneMaterial;
                    itemCustomModelData = doneCustomModelData;
                    String taskFinish = BaseUtil.getMsgNotColor("taskFinish");
                    loreList = ItemStackUtil.loreBatchReplaceMap(npcLore, this.getReplaceMap(taskList, taskNpc, taskNpc.getNumber(), player, taskFinish), "");
                    next = false;
                }
                long time = (long)taskNpc.getCd().intValue() - (System.currentTimeMillis() - taskNpcPlayer.getTaskDate().getTime()) / 1000L;
                if (next && taskNpcPlayer.getStatus().booleanValue() && time > 0L) {
                    itemMaterial = cdMaterial;
                    itemCustomModelData = cdCustomModelData;
                    String timeMsg = BaseUtil.getMsgNotColor("timeMsg");
                    timeMsg = StrUtil.replace(timeMsg, "time", String.valueOf(time));
                    loreList = ItemStackUtil.loreBatchReplaceMap(npcLore, this.getReplaceMap(taskList, taskNpc, taskNpcPlayer.getNumber(), player, timeMsg), "");
                    next = false;
                }
                if (next) {
                    loreList = this.getTaskLore(player, npcLore, taskNpc, taskList);
                }
            }
            ItemStack itemStack = ItemStackUtil.getItemStack(itemMaterial, itemName, loreList, isEnchant, itemCustomModelData);
            Integer index = indexList.get(i++);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, taskNpc.getId());
        }
    }

    private List<String> getTaskLore(Player player, List<String> npcLore, TaskNpc taskNpc, TaskList taskList) {
        Optional<TaskList> taskListOptional;
        Optional<TaskNpcPlayer> taskNpcPlayerOptional;
        String button = BaseUtil.getMsgNotColor("getTask");
        if (taskNpc.getParentId() != null && taskNpc.getParentId() != 0 && !(taskNpcPlayerOptional = TaskNpcPlayerService.getInstance().existTask(player.getUniqueId(), taskNpc.getParentId())).isPresent() && (taskListOptional = TaskListService.getInstance().findById(taskNpc.getParentId())).isPresent()) {
            String parentTaskMsg = BaseUtil.getMsgNotColor("parentTaskMsg");
            button = StrUtil.replace(parentTaskMsg, "task", taskListOptional.get().getTaskName());
        }
        return ItemStackUtil.loreBatchReplaceMap(npcLore, this.getReplaceMap(taskList, taskNpc, 0, player, button), "");
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.NPC_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.NPC_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setCustomButton(ConfigUtil.NPC_CONFIG, handyInventory, "custom");
    }

    private Map<String, List<String>> getReplaceMap(TaskList taskList, TaskNpc taskNpc, Integer number, Player player, String button) {
        HashMap<String, List<String>> map = MapUtil.newHashMapWithExpectedSize(6);
        map.put("taskTarget", TaskUtil.taskTargetReplaceMap(taskList.getTaskDemands()));
        map.put("taskReward", TaskUtil.taskRewardReplaceMap(taskList.getTaskRewardsList(), player));
        map.put("taskNumber", Collections.singletonList(taskNpc.getIsEver() == 1 ? BaseUtil.getMsgNotColor("isEver") : number + " / " + taskNpc.getNumber()));
        map.put("rarity", Collections.singletonList(RarityEnum.getEnumName(taskList.getRarity())));
        map.put("description", TaskUtil.getDescription(taskList.getDescription()));
        map.put("button", Collections.singletonList(button));
        return map;
    }

    private Map<String, List<String>> getScheduleReplaceMap(TaskNpcPlayer taskNpcPlayer, Player player) {
        HashMap<String, List<String>> map = MapUtil.newHashMapWithExpectedSize(5);
        map.put("taskSchedule", TaskUtil.taskScheduleLoreList(taskNpcPlayer.getTaskPlayerDemands()));
        map.put("taskReward", TaskUtil.taskRewardReplaceMap(taskNpcPlayer.getTaskRewardsList(), player));
        map.put("button", Collections.singletonList(BaseUtil.getMsgNotColor(taskNpcPlayer.getStatus() != false ? "isFinish" : "submitFinish")));
        map.put("rarity", Collections.singletonList(RarityEnum.getEnumName(taskNpcPlayer.getRarity())));
        map.put("description", TaskUtil.getDescription(taskNpcPlayer.getDescription()));
        return map;
    }
}

