/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.inventory;

import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.entity.TaskDemand;
import com.handy.playertask.hook.PlaceholderApiUtil;
import com.handy.playertask.lib.core.MapUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.db.enter.Page;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.param.TaskDemandParam;
import com.handy.playertask.param.TaskReplaceContent;
import com.handy.playertask.service.TaskDemandService;
import com.handy.playertask.util.ConfigUtil;
import com.handy.playertask.util.DemandReplaceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ViewDemandGui {
    private static final ViewDemandGui INSTANCE = new ViewDemandGui();

    private ViewDemandGui() {
    }

    public static ViewDemandGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, String search) {
        String title = ConfigUtil.DEMAND_CONFIG.getString("viewTitle", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.DEMAND_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.VIEW_DEMAND.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setSearchType(search);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.VIEW_DEMAND.getType());
        handyInventory.setSearchType(handyInventory.getSearchType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        String searchType = handyInventory.getSearchType();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.DEMAND_CONFIG.getString("demand.index"));
        handyInventory.setPageSize(indexList.size());
        Page<TaskDemand> page = TaskDemandService.getInstance().page(searchType, handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        int i = 0;
        String name = ConfigUtil.DEMAND_CONFIG.getString("demand.name", "");
        for (TaskDemand taskDemand : page.getRecords()) {
            TaskReplaceContent demandContent = DemandReplaceUtil.getDemandContent(TaskDemandParam.init(taskDemand));
            ItemStack itemStack = demandContent.getItemStack();
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            itemMeta.setDisplayName(BaseUtil.replaceChatColor(StrUtil.replace(name, "id", taskDemand.getId().toString())));
            ArrayList<String> loreList = new ArrayList<String>();
            loreList.add(demandContent.getMsg());
            loreList.add(BaseUtil.getMsgNotColor("deleteButton"));
            itemMeta.setLore(loreList);
            itemStack.setItemMeta(itemMeta);
            Integer index = indexList.get(i++);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, taskDemand.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.DEMAND_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.DEMAND_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.DEMAND_CONFIG, inventory, "search", this.replaceSearchMap(handyInventory));
        HandyInventoryUtil.setButton(ConfigUtil.DEMAND_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.DEMAND_CONFIG, inventory, "pane");
    }

    private Map<String, String> replaceSearchMap(HandyInventory handyInventory) {
        String searchType = handyInventory.getSearchType();
        DemandTypeEnum demandTypeEnum = DemandTypeEnum.getEnumThrow(searchType);
        DemandTypeEnum nextEnum = DemandTypeEnum.getNextEnum(searchType);
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(2);
        map.put("type", DemandTypeEnum.getTypeName(demandTypeEnum.getType()));
        map.put("nextType", DemandTypeEnum.getTypeName(nextEnum.getType()));
        return map;
    }
}

