/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener;

import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.event.PlayerTaskScheduleEvent;
import com.handy.playertask.lib.annotation.HandyListener;
import com.handy.playertask.lib.core.StrUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;

@HandyListener
public class EntityDeathEventListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Player player = entity.getKiller();
        if (player == null) {
            return;
        }
        EntityType entityType = entity.getType();
        String name = entityType.getName();
        if (StrUtil.isEmpty(name)) {
            return;
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerTaskScheduleEvent(player, DemandTypeEnum.KILL_NORMAL.getType(), 1, name));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player entityPlayer = (Player)entity;
        String entityPlayerName = entityPlayer.getName();
        Player player = entity.getKiller();
        if (player == null) {
            return;
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerTaskScheduleEvent(player, DemandTypeEnum.KILL_PLAYER.getType(), 1, entityPlayerName.toLowerCase()));
    }
}

