/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener.gui;

import com.handy.playertask.constants.BaseTaskConstants;
import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.entity.TaskDemand;
import com.handy.playertask.inventory.MythicMobGui;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.inventory.IHandyClickEvent;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.service.TaskDemandService;
import com.handy.playertask.util.ConfigUtil;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class MythicMobClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.MYTHIC_MOB.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        Map<Integer, String> map = handyInventory.getStrMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.MYTHIC_MOB_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                MythicMobGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.MYTHIC_MOB_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                MythicMobGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.MYTHIC_MOB_CONFIG, "back")) {
            BaseTaskConstants.MYTHIC_MOBS_MAP.remove(player.getUniqueId());
            handyInventory.syncClose();
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.MYTHIC_MOB_CONFIG, "step")) {
            this.finish(player);
            handyInventory.syncClose();
            return;
        }
        String internalName = map.get(event.getRawSlot());
        if (StrUtil.isEmpty(internalName)) {
            return;
        }
        TaskDemand taskDemand = BaseTaskConstants.MYTHIC_MOBS_MAP.get(player.getUniqueId());
        if (taskDemand == null) {
            return;
        }
        taskDemand.setItemStack(internalName);
        MythicMobGui.getInstance().setInventoryDate(handyInventory);
    }

    private void finish(Player player) {
        TaskDemand taskDemand = BaseTaskConstants.MYTHIC_MOBS_MAP.get(player.getUniqueId());
        if (taskDemand == null || StrUtil.isEmpty(taskDemand.getItemStack())) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noMythicMob"));
            return;
        }
        BaseTaskConstants.MYTHIC_MOBS_MAP.remove(player.getUniqueId());
        boolean rst = TaskDemandService.getInstance().add(taskDemand);
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
    }
}

