/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.service;

import com.handy.playertask.entity.TaskNpcPlayerDemand;
import com.handy.playertask.lib.db.Db;
import java.util.List;
import java.util.UUID;

public class TaskNpcPlayerDemandService {
    private TaskNpcPlayerDemandService() {
    }

    public static TaskNpcPlayerDemandService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Boolean add(TaskNpcPlayerDemand taskNpcPlayerDemand) {
        return Db.use(TaskNpcPlayerDemand.class).execution().insert(taskNpcPlayerDemand) > 0;
    }

    public List<TaskNpcPlayerDemand> findByTaskNpcPlayerId(Integer taskNpcPlayerId) {
        Db<TaskNpcPlayerDemand> use = Db.use(TaskNpcPlayerDemand.class);
        use.where().eq(TaskNpcPlayerDemand::getTaskNpcPlayerId, taskNpcPlayerId);
        return use.execution().list();
    }

    public List<TaskNpcPlayerDemand> findByPlayerAndContent(UUID playerUuid, String content, String demandType) {
        Db<TaskNpcPlayerDemand> use = Db.use(TaskNpcPlayerDemand.class);
        use.where().eq(TaskNpcPlayerDemand::getPlayerUuid, playerUuid).eq(TaskNpcPlayerDemand::getItemStack, content).eq(TaskNpcPlayerDemand::getType, demandType).lt(TaskNpcPlayerDemand::getCompletionAmount, TaskNpcPlayerDemand::getAmount);
        return use.execution().list();
    }

    public boolean findCountByTaskNpcPlayerId(Integer taskNpcPlayerId) {
        Db<TaskNpcPlayerDemand> use = Db.use(TaskNpcPlayerDemand.class);
        use.where().eq(TaskNpcPlayerDemand::getTaskNpcPlayerId, taskNpcPlayerId).lt(TaskNpcPlayerDemand::getCompletionAmount, TaskNpcPlayerDemand::getAmount);
        return use.execution().count() > 0;
    }

    public Boolean updateCompletionAmount(Integer id, Integer completionAmount) {
        Db<TaskNpcPlayerDemand> use = Db.use(TaskNpcPlayerDemand.class);
        use.update().add(TaskNpcPlayerDemand::getCompletionAmount, TaskNpcPlayerDemand::getCompletionAmount, completionAmount);
        return use.execution().updateById(id) > 0;
    }

    public void deleteByTaskNpcPlayerId(Integer taskNpcPlayerId) {
        Db<TaskNpcPlayerDemand> use = Db.use(TaskNpcPlayerDemand.class);
        use.where().eq(TaskNpcPlayerDemand::getTaskNpcPlayerId, taskNpcPlayerId);
        use.execution().delete();
    }

    public void deleteByNpcId(Integer npcId) {
        Db<TaskNpcPlayerDemand> use = Db.use(TaskNpcPlayerDemand.class);
        use.where().eq(TaskNpcPlayerDemand::getNpcId, npcId);
        use.execution().delete();
    }

    public List<TaskNpcPlayerDemand> selectAll() {
        return Db.use(TaskNpcPlayerDemand.class).execution().list();
    }

    public void updateItemStack(String itemStack, Integer id) {
        Db<TaskNpcPlayerDemand> use = Db.use(TaskNpcPlayerDemand.class);
        use.update().set(TaskNpcPlayerDemand::getItemStack, itemStack);
        use.execution().updateById(id);
    }

    private static class SingletonHolder {
        private static final TaskNpcPlayerDemandService INSTANCE = new TaskNpcPlayerDemandService();

        private SingletonHolder() {
        }
    }
}

