/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.service;

import com.handy.playertask.entity.TaskList;
import com.handy.playertask.entity.TaskNpcPlayer;
import com.handy.playertask.entity.TaskNpcPlayerDemand;
import com.handy.playertask.entity.TaskRewards;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.db.Db;
import com.handy.playertask.lib.db.enter.Page;
import com.handy.playertask.service.TaskListService;
import com.handy.playertask.service.TaskNpcPlayerDemandService;
import com.handy.playertask.service.TaskRewardsService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class TaskNpcPlayerService {
    private TaskNpcPlayerService() {
    }

    public static TaskNpcPlayerService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(TaskNpcPlayer taskNpcPlayer) {
        return Db.use(TaskNpcPlayer.class).execution().insert(taskNpcPlayer);
    }

    public Boolean updateStatusById(Integer id, Boolean status) {
        Db<TaskNpcPlayer> use = Db.use(TaskNpcPlayer.class);
        use.update().set(TaskNpcPlayer::getStatus, status).set(TaskNpcPlayer::getTaskDate, new Date());
        return use.execution().updateById(id) > 0;
    }

    public List<TaskNpcPlayer> findByPlayerAndNpcId(UUID playerUuid, Integer npcId) {
        Db<TaskNpcPlayer> use = Db.use(TaskNpcPlayer.class);
        use.where().eq(TaskNpcPlayer::getPlayerUuid, playerUuid).eq(TaskNpcPlayer::getNpcId, npcId).orderByDesc(TaskNpcPlayer::getId);
        List<TaskNpcPlayer> list = use.execution().list();
        if (CollUtil.isNotEmpty(list)) {
            for (TaskNpcPlayer taskNpcPlayer : list) {
                this.setData(taskNpcPlayer);
            }
        }
        return list;
    }

    public List<TaskNpcPlayer> findByPlayerAndTaskNpcId(UUID playerUuid, List<Integer> taskNpcIds) {
        Db<TaskNpcPlayer> use = Db.use(TaskNpcPlayer.class);
        use.where().eq(TaskNpcPlayer::getPlayerUuid, playerUuid).in(TaskNpcPlayer::getTaskNpcId, taskNpcIds).orderByDesc(TaskNpcPlayer::getId);
        List<TaskNpcPlayer> list = use.execution().list();
        if (CollUtil.isNotEmpty(list)) {
            for (TaskNpcPlayer taskNpcPlayer : list) {
                this.setData(taskNpcPlayer);
            }
        }
        return list;
    }

    public Optional<TaskNpcPlayer> findByPlayerAndTaskNpcId(UUID playerUuid, Integer taskNpcId) {
        Db<TaskNpcPlayer> use = Db.use(TaskNpcPlayer.class);
        use.where().eq(TaskNpcPlayer::getPlayerUuid, playerUuid).eq(TaskNpcPlayer::getTaskNpcId, taskNpcId).orderByDesc(TaskNpcPlayer::getId);
        Optional<TaskNpcPlayer> taskNpcPlayerOptional = use.execution().selectOne();
        taskNpcPlayerOptional.ifPresent(this::setData);
        return taskNpcPlayerOptional;
    }

    public Optional<TaskNpcPlayer> existNpcTask(UUID playerUuid, Integer taskId, Boolean status) {
        Db<TaskNpcPlayer> use = Db.use(TaskNpcPlayer.class);
        use.where().eq(TaskNpcPlayer::getPlayerUuid, playerUuid).eq(TaskNpcPlayer::getTaskId, taskId).eq(status != null, TaskNpcPlayer::getStatus, status);
        return use.execution().selectOne();
    }

    public Optional<TaskNpcPlayer> findById(Integer id) {
        Optional<TaskNpcPlayer> taskNpcPlayerOptional = Db.use(TaskNpcPlayer.class).execution().selectById(id);
        taskNpcPlayerOptional.ifPresent(this::setData);
        return taskNpcPlayerOptional;
    }

    public Optional<TaskNpcPlayer> existTask(UUID playerUuid, Integer taskId) {
        Db<TaskNpcPlayer> use = Db.use(TaskNpcPlayer.class);
        use.where().eq(TaskNpcPlayer::getPlayerUuid, playerUuid).eq(TaskNpcPlayer::getTaskId, taskId).eq(TaskNpcPlayer::getStatus, true).orderByDesc(TaskNpcPlayer::getTaskDate).limit(1, 1);
        return use.execution().selectOne();
    }

    public List<TaskNpcPlayer> findByTaskId(Integer taskId) {
        Db<TaskNpcPlayer> use = Db.use(TaskNpcPlayer.class);
        use.where().eq(TaskNpcPlayer::getTaskId, taskId).orderByDesc(TaskNpcPlayer::getTaskDate);
        return use.execution().list();
    }

    private void setData(TaskNpcPlayer taskNpcPlayer) {
        Optional<TaskList> taskListOptional;
        List<TaskNpcPlayerDemand> taskNpcPlayerDemands = TaskNpcPlayerDemandService.getInstance().findByTaskNpcPlayerId(taskNpcPlayer.getId());
        taskNpcPlayer.setTaskPlayerDemands(CollUtil.isNotEmpty(taskNpcPlayerDemands) ? taskNpcPlayerDemands : null);
        if (StrUtil.isNotEmpty(taskNpcPlayer.getTaskRewards())) {
            List<TaskRewards> taskRewardsList = TaskRewardsService.getInstance().findByIds(StrUtil.strToIntList(taskNpcPlayer.getTaskRewards()));
            taskNpcPlayer.setTaskRewardsList(CollUtil.isNotEmpty(taskRewardsList) ? taskRewardsList : null);
        }
        if ((taskListOptional = TaskListService.getInstance().findById(taskNpcPlayer.getTaskId())).isPresent()) {
            TaskList taskList = taskListOptional.get();
            taskNpcPlayer.setRarity(taskList.getRarity());
            taskNpcPlayer.setDescription(taskList.getDescription());
        }
    }

    public void deleteByNpcId(Integer npcId) {
        Db<TaskNpcPlayer> use = Db.use(TaskNpcPlayer.class);
        use.where().eq(TaskNpcPlayer::getNpcId, npcId);
        use.execution().delete();
    }

    public void deleteById(Integer id) {
        Db.use(TaskNpcPlayer.class).execution().deleteById(id);
        TaskNpcPlayerDemandService.getInstance().deleteByTaskNpcPlayerId(id);
    }

    public void deleteByTaskId(Integer taskId) {
        Db<TaskNpcPlayer> use = Db.use(TaskNpcPlayer.class);
        use.where().eq(TaskNpcPlayer::getTaskId, taskId);
        use.execution().delete();
    }

    public Page<TaskNpcPlayer> page(UUID playerUuid, Integer pageNum, Integer pageSize) {
        Db<TaskNpcPlayer> use = Db.use(TaskNpcPlayer.class);
        use.where().eq(TaskNpcPlayer::getPlayerUuid, playerUuid).limit(pageNum, pageSize).orderByDesc(TaskNpcPlayer::getId);
        Page<TaskNpcPlayer> page = use.execution().page();
        if (CollUtil.isNotEmpty(page.getRecords())) {
            for (TaskNpcPlayer taskNpcPlayer : page.getRecords()) {
                this.setData(taskNpcPlayer);
            }
        }
        return page;
    }

    private static class SingletonHolder {
        private static final TaskNpcPlayerService INSTANCE = new TaskNpcPlayerService();

        private SingletonHolder() {
        }
    }
}

