/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.service;

import com.handy.playertask.entity.TaskNpc;
import com.handy.playertask.lib.db.Db;
import com.handy.playertask.lib.db.enter.Page;
import com.handy.playertask.service.TaskNpcPlayerDemandService;
import com.handy.playertask.service.TaskNpcPlayerService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TaskNpcService {
    private TaskNpcService() {
    }

    public static TaskNpcService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean add(TaskNpc taskNpc) {
        return Db.use(TaskNpc.class).execution().insert(taskNpc) > 0;
    }

    public Optional<TaskNpc> existNpcTask(Integer npcId) {
        Db<TaskNpc> use = Db.use(TaskNpc.class);
        use.where().eq(TaskNpc::getNpcId, npcId).limit(1, 1);
        return use.execution().selectOne();
    }

    public Page<TaskNpc> pageByNpcId(Integer npcId, Integer pageNum, Integer pageSize) {
        Db<TaskNpc> use = Db.use(TaskNpc.class);
        use.where().eq(TaskNpc::getNpcId, npcId).limit(pageNum, pageSize).orderByDesc(TaskNpc::getId);
        return use.execution().page();
    }

    public Optional<TaskNpc> findById(Integer id) {
        return Db.use(TaskNpc.class).execution().selectById(id);
    }

    public Page<TaskNpc> page(Integer pageNum, Integer pageSize) {
        Db<TaskNpc> use = Db.use(TaskNpc.class);
        use.where().limit(pageNum, pageSize);
        return use.execution().page();
    }

    public boolean deleteById(Integer id) {
        boolean rst;
        boolean bl = rst = Db.use(TaskNpc.class).execution().deleteById(id) > 0;
        if (rst) {
            TaskNpcPlayerService.getInstance().deleteByNpcId(id);
            TaskNpcPlayerDemandService.getInstance().deleteByNpcId(id);
        }
        return rst;
    }

    public void deleteByTaskId(Integer taskId) {
        Db<TaskNpc> use = Db.use(TaskNpc.class);
        use.where().eq(TaskNpc::getTaskId, taskId);
        use.execution().delete();
    }

    public List<String> findNpcId() {
        Db<TaskNpc> use = Db.use(TaskNpc.class);
        use.select(TaskNpc::getNpcId);
        use.where().groupBy(TaskNpc::getNpcId);
        List<TaskNpc> list = use.execution().list();
        return list.stream().map(s -> s.getNpcId().toString()).collect(Collectors.toList());
    }

    private static class SingletonHolder {
        private static final TaskNpcService INSTANCE = new TaskNpcService();

        private SingletonHolder() {
        }
    }
}

