/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.service;

import com.handy.playertask.constants.RewardTypeEnum;
import com.handy.playertask.entity.TaskRewards;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.db.Db;
import com.handy.playertask.lib.db.enter.Page;
import java.util.ArrayList;
import java.util.List;

public class TaskRewardsService {
    private TaskRewardsService() {
    }

    public static TaskRewardsService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean add(TaskRewards taskRewards) {
        return Db.use(TaskRewards.class).execution().insert(taskRewards) > 0;
    }

    public List<TaskRewards> findByIds(List<Integer> ids) {
        if (CollUtil.isEmpty(ids)) {
            return new ArrayList<TaskRewards>();
        }
        return Db.use(TaskRewards.class).execution().selectBatchIds(ids);
    }

    public Page<TaskRewards> page(String type, Integer pageNum, Integer pageSize) {
        Db<TaskRewards> use = Db.use(TaskRewards.class);
        use.where().eq(!RewardTypeEnum.ALL.getType().equalsIgnoreCase(type), TaskRewards::getType, type).limit(pageNum, pageSize);
        return use.execution().page();
    }

    public Boolean deleteById(Integer id) {
        return Db.use(TaskRewards.class).execution().deleteById(id) > 0;
    }

    public List<TaskRewards> selectByType(String type) {
        Db<TaskRewards> use = Db.use(TaskRewards.class);
        use.where().eq(TaskRewards::getType, type);
        return use.execution().list();
    }

    public void updateItemStack(String itemStack, Integer id) {
        Db<TaskRewards> use = Db.use(TaskRewards.class);
        use.update().set(TaskRewards::getItemStack, itemStack);
        use.execution().updateById(id);
    }

    private static class SingletonHolder {
        private static final TaskRewardsService INSTANCE = new TaskRewardsService();

        private SingletonHolder() {
        }
    }
}

