/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.admin;

import com.handy.guild.enter.GuildInfo;
import com.handy.guild.hook.PlayerTaskUtil;
import com.handy.guild.hook.PlayerTitleUtil;
import com.handy.guild.hook.WorldUtil;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildTaskService;
import com.handy.guild.util.ConfigUtil;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class RefreshCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "refresh";
    }

    @Override
    public String permission() {
        return "playerGuild.refresh";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] strings) {
        List<GuildInfo> guildInfoList = GuildInfoService.getInstance().findAll();
        if (CollUtil.isEmpty(guildInfoList)) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("succeedMsg"));
            return;
        }
        for (GuildInfo guildInfo : guildInfoList) {
            PlayerTitleUtil.setGuildTitle(guildInfo.getId());
            Integer count = GuildTaskService.getInstance().findCount(guildInfo.getId());
            if (count < 1) {
                PlayerTaskUtil.createTask(guildInfo.getId());
            }
            WorldUtil.setGuildBorder(guildInfo);
            HandySchedulerUtil.runTask(() -> WorldUtil.setGameRule(guildInfo.getWorldName()));
            int memberMaxCount = ConfigUtil.CONFIG.getInt("guildSetting." + guildInfo.getLevel() + ".totalNumber");
            if (memberMaxCount == 0) continue;
            GuildInfoService.getInstance().upLevel(guildInfo.getId(), null, memberMaxCount);
        }
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("succeedMsg"));
    }
}

