/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.admin;

import com.handy.guild.api.PlayerGuildApi;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildPlayerService;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "set";
    }

    @Override
    public String permission() {
        return "playerGuild.set";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        boolean rst;
        Player player;
        AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        String type = args[1].toLowerCase(Locale.ROOT);
        String name = args[2];
        Integer number = AssertUtil.isNumericToInt(args[3], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        String useName = name;
        if ("${guildName}".equalsIgnoreCase(name)) {
            if (BaseUtil.isNotPlayer(sender).booleanValue()) {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
                return;
            }
            player = (Player)sender;
            Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
            if (!guildPlayerOptional.isPresent()) {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noGuildMsg"));
                return;
            }
            useName = guildPlayerOptional.get().getGuildInfoName();
        }
        if ("${player}".equalsIgnoreCase(name)) {
            if (BaseUtil.isNotPlayer(sender).booleanValue()) {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
                return;
            }
            player = (Player)sender;
            useName = player.getName();
        }
        switch (type) {
            case "guildmoney": {
                rst = PlayerGuildApi.getInstance().setGuildMoneyByName(useName, number);
                break;
            }
            case "guildactive": {
                rst = PlayerGuildApi.getInstance().setGuildProsperityDegreeByName(useName, number);
                break;
            }
            case "guildore": {
                rst = PlayerGuildApi.getInstance().setGuildOreByName(useName, number);
                break;
            }
            case "player": {
                rst = PlayerGuildApi.getInstance().setPlayerMoneyByName(useName, (int)number);
                break;
            }
            default: {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                return;
            }
        }
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
    }
}

