/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.admin;

import com.handy.guild.inventory.ViewEquipmentGui;
import com.handy.guild.inventory.ViewLocationGui;
import com.handy.guild.inventory.ViewLogoShopGui;
import com.handy.guild.inventory.ViewNoticeGui;
import com.handy.guild.inventory.ViewShopGui;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class ViewCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "view";
    }

    @Override
    public String permission() {
        return "playerGuild.view";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        Inventory inventory;
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        switch (args[1]) {
            case "location": {
                inventory = ViewLocationGui.getInstance().createGui(player);
                break;
            }
            case "shop": {
                inventory = ViewShopGui.getInstance().createGui(player);
                break;
            }
            case "logo": {
                inventory = ViewLogoShopGui.getInstance().createGui(player);
                break;
            }
            case "equipment": {
                inventory = ViewEquipmentGui.getInstance().createGui(player);
                break;
            }
            case "notice": {
                inventory = ViewNoticeGui.getInstance().createGui(player);
                break;
            }
            default: {
                return;
            }
        }
        if (inventory == null) {
            return;
        }
        HandySchedulerUtil.runTask(() -> player.openInventory(inventory));
    }
}

